/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.client.renderer.block.LampRenderer;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LampBlock
extends Block
implements IBlockRendererProvider {
    public static final BooleanProperty BLOOM = BooleanProperty.m_61465_((String)"bloom");
    public static final BooleanProperty LIGHT = BlockStateProperties.f_61443_;
    public static final BooleanProperty INVERTED = BooleanProperty.m_61465_((String)"inverted");
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final String TAG_INVERTED = "inverted";
    public static final String TAG_BLOOM = "bloom";
    public static final String TAG_LIT = "lit";
    public static final int BLOOM_FLAG = 1;
    public static final int LIGHT_FLAG = 2;
    public static final int INVERTED_FLAG = 4;
    public static final int POWERED_FLAG = 8;
    public final DyeColor color;
    public final boolean bordered;
    private final Map<BlockState, LampRenderer> renderers = new IdentityHashMap<BlockState, LampRenderer>();

    public LampBlock(BlockBehaviour.Properties properties, DyeColor color, boolean bordered) {
        super(properties);
        this.color = color;
        this.bordered = bordered;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BLOOM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIGHT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        for (BlockState state : this.m_49965_().m_61056_()) {
            this.renderers.put(state, new LampRenderer(this, state));
        }
    }

    public static boolean isLightActive(BlockState state) {
        return state.m_61143_((Property)INVERTED) != state.m_61143_((Property)POWERED);
    }

    public static boolean isInverted(BlockState state) {
        return (Boolean)state.m_61143_((Property)INVERTED);
    }

    public static boolean isLightEnabled(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIGHT);
    }

    public static boolean isBloomEnabled(BlockState state) {
        return (Boolean)state.m_61143_((Property)BLOOM);
    }

    public static boolean isInverted(CompoundTag tag) {
        return tag.m_128471_(TAG_INVERTED);
    }

    public static boolean isLightEnabled(CompoundTag tag) {
        return tag.m_128471_(TAG_LIT);
    }

    public static boolean isBloomEnabled(CompoundTag tag) {
        return tag.m_128471_(TAG_BLOOM);
    }

    public CompoundTag getTagFromState(BlockState state) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(TAG_BLOOM, ((Boolean)state.m_61143_((Property)BLOOM)).booleanValue());
        tag.m_128379_(TAG_LIT, ((Boolean)state.m_61143_((Property)LIGHT)).booleanValue());
        tag.m_128379_(TAG_INVERTED, ((Boolean)state.m_61143_((Property)INVERTED)).booleanValue());
        return tag;
    }

    public ItemStack getStackFromIndex(int i) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(TAG_INVERTED, (i & 4) == 0);
        tag.m_128379_(TAG_BLOOM, (i & 1) == 0);
        tag.m_128379_(TAG_LIT, (i & 2) == 0);
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41751_(tag);
        return stack;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{INVERTED, BLOOM, LIGHT, POWERED}));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIGHT) != false && LampBlock.isLightActive(state) ? 15 : 0;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        boolean powered;
        if (!level.f_46443_ && (powered = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) != level.m_276867_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(!powered)), (Boolean)state.m_61143_((Property)LIGHT) != false ? 10 : 2);
        }
        super.m_6807_(state, level, pos, oldState, movedByPiston);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean powered;
        if (!level.f_46443_ && (powered = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) != level.m_276867_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(!powered)), (Boolean)state.m_61143_((Property)LIGHT) != false ? 10 : 2);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !level.m_276867_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), (Boolean)state.m_61143_((Property)LIGHT) != false ? 10 : 2);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        stack.m_41751_(this.getTagFromState(state));
        return stack;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            if (LampBlock.isInverted(tag)) {
                tooltip.add((Component)Component.m_237115_((String)"block.gtceu.lamp.tooltip.inverted"));
            }
            if (!LampBlock.isBloomEnabled(tag)) {
                tooltip.add((Component)Component.m_237115_((String)"block.gtceu.lamp.tooltip.no_bloom"));
            }
            if (!LampBlock.isLightEnabled(tag)) {
                tooltip.add((Component)Component.m_237115_((String)"block.gtceu.lamp.tooltip.no_light"));
            }
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        List returnValue = super.m_49635_(state, params);
        for (ItemStack stack : returnValue) {
            if (!stack.m_150930_(this.m_5456_())) continue;
            stack.m_41751_(this.getTagFromState(state));
            break;
        }
        return returnValue;
    }

    @Nullable
    public IRenderer getRenderer(BlockState state) {
        return (IRenderer)this.renderers.get(state);
    }
}

