/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttribute;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IDataInfoProvider;
import com.gregtechceu.gtceu.common.cover.PumpCover;
import com.gregtechceu.gtceu.common.cover.data.ManualIOMode;
import com.gregtechceu.gtceu.common.item.PortableScannerBehavior;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeType;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.PipeTankList;
import com.gregtechceu.gtceu.utils.EntityDamageUtil;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidTransferHelperImpl;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlockEntity
extends PipeBlockEntity<FluidPipeType, FluidPipeProperties>
implements IDataInfoProvider {
    public static final int FREQUENCY = 5;
    public byte lastReceivedFrom = 0;
    public byte oldLastReceivedFrom = 0;
    private PipeTankList pipeTankList;
    private final EnumMap<Direction, PipeTankList> tankLists = new EnumMap(Direction.class);
    private FluidStorage[] fluidTanks;
    private long timer = 0L;
    private final int offset = GTValues.RNG.m_188503_(20);
    private TickableSubscription updateSubs;

    public FluidPipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static void onBlockEntityRegister(BlockEntityType<FluidPipeBlockEntity> fluidPipeBlockEntityBlockEntityType) {
    }

    @Override
    public long getOffsetTimer() {
        return this.timer + (long)this.offset;
    }

    public void onLoad() {
        super.onLoad();
        if (this.updateSubs == null) {
            this.updateSubs = this.subscribeServerTick(this::update);
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.updateSubs != null) {
            this.unsubscribe(this.updateSubs);
            this.updateSubs = null;
        }
    }

    @Override
    public boolean canAttachTo(Direction side) {
        if (this.f_58857_ != null) {
            if (this.f_58857_.m_7702_(this.m_58899_().m_121945_(side)) instanceof FluidPipeBlockEntity) {
                return false;
            }
            return FluidTransferHelper.getFluidTransfer((Level)this.f_58857_, (BlockPos)this.m_58899_().m_121945_(side), (Direction)side.m_122424_()) != null;
        }
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            if (facing != null && this.isConnected(facing)) {
                PipeTankList tankList = this.getTankList(facing);
                if (tankList == null) {
                    return LazyOptional.empty();
                }
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(capability, LazyOptional.of(() -> FluidTransferHelperImpl.toFluidHandler((IFluidTransfer)tankList)));
            }
        } else {
            if (capability == GTCapability.CAPABILITY_COVERABLE) {
                return GTCapability.CAPABILITY_COVERABLE.orEmpty(capability, LazyOptional.of(this::getCoverContainer));
            }
            if (capability == GTCapability.CAPABILITY_TOOLABLE) {
                return GTCapability.CAPABILITY_TOOLABLE.orEmpty(capability, LazyOptional.of(() -> this));
            }
        }
        return super.getCapability(capability, facing);
    }

    public long getCapacityPerTank() {
        return ((FluidPipeProperties)this.getNodeData()).getThroughput() * 20L;
    }

    public void update() {
        ++this.timer;
        if (!this.f_58857_.f_46443_ && this.getOffsetTimer() % 5L == 0L) {
            this.lastReceivedFrom = (byte)(this.lastReceivedFrom & 0x3F);
            if (this.lastReceivedFrom == 63) {
                this.lastReceivedFrom = 0;
            }
            boolean shouldDistribute = this.oldLastReceivedFrom == this.lastReceivedFrom;
            int tanks = ((FluidPipeProperties)this.getNodeData()).getChannels();
            int j = GTValues.RNG.m_188503_(tanks);
            for (int i = 0; i < tanks; ++i) {
                int index = (i + j) % tanks;
                FluidStorage tank = this.getFluidTanks()[index];
                FluidStack fluid = tank.getFluid();
                if (fluid.isEmpty() || fluid.getFluid() == Fluids.f_76191_) continue;
                if (fluid.getAmount() <= 0L) {
                    tank.setFluid(FluidStack.empty());
                    continue;
                }
                if (!shouldDistribute) continue;
                this.distributeFluid(index, tank, fluid);
                this.lastReceivedFrom = 0;
            }
            this.oldLastReceivedFrom = this.lastReceivedFrom;
        }
    }

    private void distributeFluid(int channel, FluidStorage tank, FluidStack fluid) {
        ArrayList<FluidTransaction> tanks = new ArrayList<FluidTransaction>();
        long amount = fluid.getAmount();
        FluidStack maxFluid = fluid.copy();
        double availableCapacity = 0.0;
        byte j = (byte)GTValues.RNG.m_188503_(6);
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            ICoverable coverable;
            IFluidTransfer fluidHandler;
            BlockEntity neighbor;
            byte side = (byte)((i + j) % 6);
            Direction facing = GTUtil.DIRECTIONS[side];
            if (!this.isConnected(facing) || (this.lastReceivedFrom & 1 << side) != 0 || (neighbor = this.getNeighbor(facing)) == null) continue;
            IFluidHandler handler = neighbor.getCapability(ForgeCapabilities.FLUID_HANDLER, facing.m_122424_()).resolve().orElse(null);
            IFluidTransfer iFluidTransfer = fluidHandler = handler == null ? null : FluidTransferHelperImpl.toFluidTransfer((IFluidHandler)handler);
            if (fluidHandler == null) continue;
            FluidStorage pipeTank = tank;
            CoverBehavior cover = this.getCoverContainer().getCoverAtSide(facing);
            if (cover == null ? (coverable = (ICoverable)neighbor.getCapability(GTCapability.CAPABILITY_COVERABLE, facing.m_122424_()).resolve().orElse(null)) != null && this.checkForPumpCover(cover = coverable.getCoverAtSide(facing.m_122424_())) : (pipeTank = cover.getFluidTransferCap((IFluidTransfer)pipeTank)) == null || this.checkForPumpCover(cover)) continue;
            FluidStack drainable = pipeTank.drain(maxFluid, true);
            if (drainable.isEmpty() || drainable.getAmount() <= 0L) continue;
            long filled = Math.min(fluidHandler.fill(maxFluid, true), drainable.getAmount());
            if (filled > 0L) {
                tanks.add(new FluidTransaction(fluidHandler, (IFluidTransfer)pipeTank, filled));
                availableCapacity += (double)filled;
            }
            maxFluid.setAmount(amount);
        }
        if (availableCapacity <= 0.0) {
            return;
        }
        double maxAmount = Math.min(this.getCapacityPerTank() / 2L, fluid.getAmount());
        for (FluidTransaction transaction : tanks) {
            FluidStack toInsert;
            if (availableCapacity > maxAmount) {
                transaction.amount = Mth.m_14107_((double)((double)transaction.amount * maxAmount / availableCapacity));
            }
            if (transaction.amount == 0L) {
                if (tank.getFluidAmount() <= 0L) break;
                transaction.amount = 1L;
            } else if (transaction.amount < 0L) continue;
            if ((toInsert = fluid.copy()).isEmpty() || toInsert.getFluid() == Fluids.f_76191_) continue;
            toInsert.setAmount(transaction.amount);
            long inserted = transaction.target.fill(toInsert, false);
            if (inserted <= 0L) continue;
            transaction.pipeTank.drain(inserted, false);
        }
    }

    private boolean checkForPumpCover(@Nullable CoverBehavior cover) {
        if (cover instanceof PumpCover) {
            PumpCover coverPump = (PumpCover)cover;
            long pipeThroughput = ((FluidPipeProperties)this.getNodeData()).getThroughput() * 20L;
            if (coverPump.getCurrentMilliBucketsPerTick() > pipeThroughput) {
                coverPump.setTransferRate(pipeThroughput);
            }
            return coverPump.getManualIOMode() == ManualIOMode.DISABLED;
        }
        return false;
    }

    public void checkAndDestroy(@NotNull FluidStack stack) {
        Fluid fluid = stack.getFluid();
        FluidPipeProperties prop = (FluidPipeProperties)this.getNodeData();
        net.minecraftforge.fluids.FluidStack forgeStack = FluidHelperImpl.toFluidStack((FluidStack)stack);
        boolean burning = prop.getMaxFluidTemperature() < fluid.getFluidType().getTemperature(forgeStack);
        boolean leaking = !prop.isGasProof() && fluid.getFluidType().getDensity(forgeStack) < 0;
        boolean shattering = !prop.isCryoProof() && fluid.getFluidType().getTemperature() < 120;
        boolean corroding = false;
        boolean melting = false;
        if (fluid instanceof GTFluid) {
            GTFluid attributedFluid = (GTFluid)fluid;
            FluidState state = attributedFluid.getState();
            if (!prop.canContain(state)) {
                leaking = state == FluidState.GAS;
                boolean bl = melting = state == FluidState.PLASMA;
            }
            if (burning && state == FluidState.PLASMA && prop.canContain(FluidState.PLASMA)) {
                burning = false;
            }
            for (FluidAttribute attribute : attributedFluid.getAttributes()) {
                if (prop.canContain(attribute)) continue;
                corroding = true;
            }
        }
        if (burning || leaking || corroding || shattering || melting) {
            this.destroyPipe(stack, burning, leaking, corroding, shattering, melting);
        }
    }

    public void destroyPipe(FluidStack stack, boolean isBurning, boolean isLeaking, boolean isCorroding, boolean isShattering, boolean isMelting) {
        List entities;
        if (this.getOffsetTimer() % 10L == 0L) {
            this.f_58857_.m_5594_(null, this.getPipePos(), SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (isLeaking) {
            FluidPipeBlockEntity.spawnParticles(this.f_58857_, this.f_58858_, Direction.UP, (ParticleOptions)ParticleTypes.f_123762_, 7 + GTValues.RNG.m_188503_(2));
            stack.setAmount(Math.max(0L, stack.getAmount() * 9L / 10L));
            if (this.getOffsetTimer() % 20L == 0L) {
                entities = this.getPipeLevel().m_45976_(LivingEntity.class, new AABB(this.getPipePos()).m_82400_(2.0));
                for (LivingEntity entityLivingBase : entities) {
                    EntityDamageUtil.applyTemperatureDamage(entityLivingBase, stack.getFluid().getFluidType().getTemperature(FluidHelperImpl.toFluidStack((FluidStack)stack)), 2.0f, 10);
                }
            }
            if (GTValues.RNG.m_188503_(isBurning ? 3 : 7) == 0) {
                this.doExplosion(1.0f + GTValues.RNG.m_188501_());
            }
        }
        if (isCorroding) {
            FluidPipeBlockEntity.spawnParticles(this.getPipeLevel(), this.getPipePos(), Direction.UP, (ParticleOptions)ParticleTypes.f_123797_, 3 + GTValues.RNG.m_188503_(2));
            stack.setAmount(Math.max(0L, stack.getAmount() * 3L / 4L));
            if (this.getOffsetTimer() % 20L == 0L) {
                entities = this.getPipeLevel().m_45976_(LivingEntity.class, new AABB(this.getPipePos()).m_82400_(1.0));
                for (LivingEntity entityLivingBase : entities) {
                    EntityDamageUtil.applyChemicalDamage(entityLivingBase, 2);
                }
            }
            if (GTValues.RNG.m_188503_(10) == 0) {
                stack.setAmount(0L);
                this.f_58857_.m_7471_(this.getPipePos(), false);
            }
        }
        if (isBurning || isMelting) {
            FluidPipeBlockEntity.spawnParticles(this.f_58857_, this.m_58899_(), Direction.UP, (ParticleOptions)ParticleTypes.f_123744_, (isMelting ? 7 : 3) + GTValues.RNG.m_188503_(2));
            stack.setAmount(Math.max(0L, stack.getAmount() / 4L));
            if (GTValues.RNG.m_188503_(4) == 0) {
                FluidPipeBlockEntity.setNeighboursToFire(this.f_58857_, this.m_58899_());
            }
            if (isMelting && this.getOffsetTimer() % 20L == 0L) {
                entities = this.getPipeLevel().m_45976_(LivingEntity.class, new AABB(this.getPipePos()).m_82400_(2.0));
                for (LivingEntity entityLivingBase : entities) {
                    EntityDamageUtil.applyTemperatureDamage(entityLivingBase, stack.getFluid().getFluidType().getTemperature(FluidHelperImpl.toFluidStack((FluidStack)stack)), 2.0f, 10);
                }
            }
            if (GTValues.RNG.m_188503_(10) == 0) {
                stack.setAmount(0L);
                this.f_58857_.m_46597_(this.m_58899_(), Blocks.f_50083_.m_49966_());
            }
        }
        if (isShattering) {
            FluidPipeBlockEntity.spawnParticles(this.f_58857_, this.m_58899_(), Direction.UP, (ParticleOptions)ParticleTypes.f_123796_, 3 + GTValues.RNG.m_188503_(2));
            stack.setAmount(Math.max(0L, stack.getAmount() / 4L));
            if (this.getOffsetTimer() % 20L == 0L) {
                entities = this.getPipeLevel().m_45976_(LivingEntity.class, new AABB(this.getPipePos()).m_82400_(2.0));
                for (LivingEntity entityLivingBase : entities) {
                    EntityDamageUtil.applyTemperatureDamage(entityLivingBase, stack.getFluid().getFluidType().getTemperature(FluidHelperImpl.toFluidStack((FluidStack)stack)), 2.0f, 10);
                }
            }
            if (GTValues.RNG.m_188503_(10) == 0) {
                stack.setAmount(0L);
                this.f_58857_.m_7471_(this.m_58899_(), false);
            }
        }
    }

    public void receivedFrom(Direction facing) {
        if (facing != null) {
            this.lastReceivedFrom = (byte)(this.lastReceivedFrom | 1 << facing.ordinal());
        }
    }

    public FluidStack getContainedFluid(int channel) {
        if (channel < 0 || channel >= this.getFluidTanks().length) {
            return null;
        }
        return this.getFluidTanks()[channel].getFluid();
    }

    private void createTanksList() {
        this.fluidTanks = new FluidStorage[((FluidPipeProperties)this.getNodeData()).getChannels()];
        for (int i = 0; i < ((FluidPipeProperties)this.getNodeData()).getChannels(); ++i) {
            this.fluidTanks[i] = new FluidStorage(this.getCapacityPerTank());
        }
        this.pipeTankList = new PipeTankList(this, null, this.fluidTanks);
        for (Direction facing : GTUtil.DIRECTIONS) {
            this.tankLists.put(facing, new PipeTankList(this, facing, this.fluidTanks));
        }
    }

    public PipeTankList getTankList() {
        if (this.pipeTankList == null || this.fluidTanks == null) {
            this.createTanksList();
        }
        return this.pipeTankList;
    }

    public PipeTankList getTankList(Direction facing) {
        if (this.tankLists.isEmpty() || this.fluidTanks == null) {
            this.createTanksList();
        }
        return this.tankLists.getOrDefault(facing, this.pipeTankList);
    }

    public FluidStorage[] getFluidTanks() {
        if (this.pipeTankList == null || this.fluidTanks == null) {
            this.createTanksList();
        }
        return this.fluidTanks;
    }

    public FluidStack[] getContainedFluids() {
        FluidStack[] fluids = new FluidStack[this.getFluidTanks().length];
        for (int i = 0; i < fluids.length; ++i) {
            fluids[i] = this.fluidTanks[i].getFluid();
        }
        return fluids;
    }

    public void saveCustomPersistedData(CompoundTag tag, boolean forDrop) {
        super.saveCustomPersistedData(tag, forDrop);
        ListTag list = new ListTag();
        for (int i = 0; i < this.getFluidTanks().length; ++i) {
            FluidStack stack1 = this.getContainedFluid(i);
            CompoundTag fluidTag = new CompoundTag();
            if (stack1 == null || stack1.getAmount() <= 0L) {
                fluidTag.m_128379_("isNull", true);
            } else {
                stack1.saveToTag(fluidTag);
            }
            list.add((Object)fluidTag);
        }
        tag.m_128365_("Fluids", (Tag)list);
    }

    public void loadCustomPersistedData(CompoundTag nbt) {
        super.loadCustomPersistedData(nbt);
        ListTag list = nbt.m_128437_("Fluids", 10);
        this.createTanksList();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            if (tag.m_128471_("isNull")) continue;
            this.fluidTanks[i].setFluid(FluidStack.loadFromTag((CompoundTag)tag));
        }
    }

    public static void spawnParticles(Level worldIn, BlockPos pos, Direction direction, ParticleOptions particleType, int particleCount) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            serverLevel.m_8767_(particleType, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, particleCount, (double)direction.m_122429_() * 0.2 + GTValues.RNG.m_188500_() * 0.1, (double)direction.m_122430_() * 0.2 + GTValues.RNG.m_188500_() * 0.1, (double)direction.m_122431_() * 0.2 + GTValues.RNG.m_188500_() * 0.1, 0.1);
        }
    }

    public static void setNeighboursToFire(Level world, BlockPos selfPos) {
        for (Direction side : GTUtil.DIRECTIONS) {
            if (!GTValues.RNG.m_188499_()) continue;
            BlockPos blockPos = selfPos.m_121945_(side);
            BlockState blockState = world.m_8055_(blockPos);
            if (!world.m_46859_(blockPos) && !blockState.isFlammable((BlockGetter)world, blockPos, side.m_122424_())) continue;
            world.m_46597_(blockPos, Blocks.f_50083_.m_49966_());
        }
    }

    @Override
    @NotNull
    public List<Component> getDataInfo(PortableScannerBehavior.DisplayMode mode) {
        FluidStack[] fluids;
        ArrayList<Component> list = new ArrayList<Component>();
        if ((mode == PortableScannerBehavior.DisplayMode.SHOW_ALL || mode == PortableScannerBehavior.DisplayMode.SHOW_MACHINE_INFO) && (fluids = this.getContainedFluids()) != null) {
            boolean allTanksEmpty = true;
            for (int i = 0; i < fluids.length; ++i) {
                if (fluids[i] == null || fluids[i].getFluid() == null || fluids[i].isEmpty()) continue;
                allTanksEmpty = false;
                list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.tank", (Object[])new Object[]{i, Component.m_237115_((String)FormattingUtil.formatNumbers(fluids[i].getAmount())).m_130940_(ChatFormatting.GREEN), Component.m_237115_((String)FormattingUtil.formatNumbers(this.getCapacityPerTank())).m_130940_(ChatFormatting.YELLOW), fluids[i].getDisplayName().m_6881_().m_130940_(ChatFormatting.GOLD)}));
            }
            if (allTanksEmpty) {
                list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.tanks_empty"));
            }
        }
        return list;
    }

    private static class FluidTransaction {
        public final IFluidTransfer target;
        public final IFluidTransfer pipeTank;
        public long amount;

        private FluidTransaction(IFluidTransfer target, IFluidTransfer pipeTank, long amount) {
            this.target = target;
            this.pipeTank = pipeTank;
            this.amount = amount;
        }
    }
}

