/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.capability;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IMedicalConditionTracker;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.HazardProperty;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.common.particle.HazardParticleOptions;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.BreadthFirstBlockSearch;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalizedHazardSavedData
extends SavedData {
    public static final int MIN_STRENGTH_FOR_SPREAD = 100;
    private final ServerLevel serverLevel;
    private final Map<BlockPos, HazardZone> hazardZones = new HashMap<BlockPos, HazardZone>();

    public static LocalizedHazardSavedData getOrCreate(ServerLevel serverLevel) {
        return (LocalizedHazardSavedData)serverLevel.m_8895_().m_164861_(tag -> new LocalizedHazardSavedData(serverLevel, (CompoundTag)tag), () -> new LocalizedHazardSavedData(serverLevel), "gtceu_localized_hazard_tracker");
    }

    public LocalizedHazardSavedData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    public LocalizedHazardSavedData(ServerLevel serverLevel, CompoundTag tag) {
        this(serverLevel);
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        ListTag allHazardZones = tag.m_128437_("zones", 10);
        for (int i = 0; i < allHazardZones.size(); ++i) {
            CompoundTag zoneTag = allHazardZones.m_128728_(i);
            BlockPos source = BlockPos.m_122022_((long)zoneTag.m_128454_("pos"));
            HazardZone zone = HazardZone.deserializeNBT(zoneTag);
            this.hazardZones.put(source, zone);
        }
    }

    public void tick() {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        Object2IntOpenHashMap zonesToSpread = new Object2IntOpenHashMap();
        RandomSource random = this.serverLevel.f_46441_;
        for (Map.Entry<BlockPos, HazardZone> entry : this.hazardZones.entrySet()) {
            HazardZone zone = entry.getValue();
            if (zone.strength() < 20) continue;
            for (BlockPos pos : zone.blocks()) {
                if (!this.serverLevel.m_46749_(pos) || this.serverLevel.m_8055_(pos).m_60838_((BlockGetter)this.serverLevel, pos) || GTValues.RNG.m_188503_(64000 / zone.strength()) != 0) continue;
                this.serverLevel.m_8767_((ParticleOptions)new HazardParticleOptions(zone.condition().color, (float)zone.strength() / 250.0f), (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + random.m_188500_(), (double)pos.m_123343_() + random.m_188500_(), 1, 0.0, 0.0, 0.0, 0.1);
            }
            Stream<ServerPlayer> playersInZone = this.serverLevel.m_6907_().stream().filter(player -> zone.blocks().contains(BlockPos.m_274446_((Position)player.m_146892_())));
            this.tickPlayerHazards(zone, playersInZone);
            if (!zone.canSpread() || zone.strength() <= 100) continue;
            zonesToSpread.put((Object)entry.getKey(), (zone.strength() - 100) / 500);
        }
        zonesToSpread.forEach(this::expandHazard);
    }

    public void tickPlayerHazards(HazardZone zone, Stream<ServerPlayer> playerStream) {
        playerStream.forEach(player -> {
            if (zone.trigger().protectionType().isProtected((LivingEntity)player)) {
                if (player.m_9236_().m_46467_() % 100L == 0L) {
                    for (ArmorItem.Type type : zone.trigger().protectionType().getEquipmentTypes()) {
                        player.m_6844_(type.m_266308_()).m_41622_(1, (LivingEntity)player, p -> p.m_21166_(type.m_266308_()));
                    }
                }
                return;
            }
            IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)player);
            if (tracker == null) {
                return;
            }
            tracker.progressCondition(zone.condition(), (float)zone.strength() / 1000.0f);
        });
    }

    @Nullable
    public HazardZone getZoneByContainedPos(BlockPos containedPos) {
        for (HazardZone zone : this.hazardZones.values()) {
            if (!zone.blocks().contains(containedPos)) continue;
            return zone;
        }
        return null;
    }

    @Nullable
    public HazardZone getZoneByContainedPosAndCondition(BlockPos containedPos, MedicalCondition condition) {
        for (HazardZone zone : this.hazardZones.values()) {
            if (zone.condition() != condition || !zone.blocks().contains(containedPos)) continue;
            return zone;
        }
        return null;
    }

    public void removeZoneByPosition(BlockPos containedPos) {
        BlockPos toRemove = null;
        for (Map.Entry<BlockPos, HazardZone> entry : this.hazardZones.entrySet()) {
            if (!entry.getValue().blocks().contains(containedPos)) continue;
            toRemove = entry.getKey();
        }
        this.hazardZones.remove(toRemove);
    }

    public void removeZoneByPosition(BlockPos containedPos, MedicalCondition condition) {
        BlockPos toRemove = null;
        for (Map.Entry<BlockPos, HazardZone> entry : this.hazardZones.entrySet()) {
            if (entry.getValue().condition() != condition || !entry.getValue().blocks().contains(containedPos)) continue;
            toRemove = entry.getKey();
        }
        this.hazardZones.remove(toRemove);
    }

    public boolean expandHazard(BlockPos source, int blocksToAdd) {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return true;
        }
        if (blocksToAdd <= 0) {
            return false;
        }
        if (this.hazardZones.containsKey(source)) {
            HazardZone zone = this.hazardZones.get(source);
            Set<BlockPos> allValidBlocks = BreadthFirstBlockSearch.search(blockPos -> !zone.blocks().contains(blockPos), source, blocksToAdd);
            for (BlockPos found : allValidBlocks) {
                zone.blocks().add(found);
            }
            this.m_77762_();
            return true;
        }
        return false;
    }

    public void addSphericalZone(BlockPos source, int sphereRadius, boolean canSpread, HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
        if (this.expandHazard(source, (int)(4.1887902047863905 * Math.pow(sphereRadius, 3.0) / 50.0))) {
            return;
        }
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int x = -sphereRadius; x < sphereRadius; ++x) {
            for (int y = -sphereRadius; y < sphereRadius; ++y) {
                for (int z = -sphereRadius; z < sphereRadius; ++z) {
                    float sizeFractionX = (float)x / (float)sphereRadius;
                    float sizeFractionY = (float)y / (float)sphereRadius;
                    float sizeFractionZ = (float)z / (float)sphereRadius;
                    if (!(sizeFractionX * sizeFractionX + sizeFractionY * sizeFractionY + sizeFractionZ * sizeFractionZ <= 1.0f)) continue;
                    blocks.add(source.m_7918_(x, y, z));
                }
            }
        }
        this.hazardZones.put(source, new HazardZone(blocks, canSpread, trigger, condition));
        this.m_77762_();
    }

    public void addCuboidZone(BlockPos source, int sizeX, int sizeY, int sizeZ, boolean canSpread, HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
        if (this.expandHazard(source, sizeX * sizeY * sizeZ / 100)) {
            return;
        }
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        sizeY /= 2;
        sizeZ /= 2;
        for (int x = -(sizeX /= 2); x < sizeX; ++x) {
            for (int y = -sizeY; y < sizeY; ++y) {
                for (int z = -sizeZ; z < sizeZ; ++z) {
                    blocks.add(source.m_7918_(x, y, z));
                }
            }
        }
        this.hazardZones.put(source, new HazardZone(blocks, canSpread, trigger, condition));
        this.m_77762_();
    }

    public void addCuboidZone(BlockPos source, int size, boolean canSpread, HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
        if (this.expandHazard(source, size * size * size / 100)) {
            return;
        }
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int x = -(size /= 2); x < size; ++x) {
            for (int y = -size; y < size; ++y) {
                for (int z = -size; z < size; ++z) {
                    blocks.add(source.m_7918_(x, y, z));
                }
            }
        }
        this.hazardZones.put(source, new HazardZone(blocks, canSpread, trigger, condition));
        this.m_77762_();
    }

    public void addCuboidZone(BlockPos source, BlockPos start, BlockPos end, boolean canSpread, HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
        int sizeZ;
        int sizeY;
        int sizeX = start.m_123341_() - end.m_123341_();
        if (this.expandHazard(source, Math.abs(sizeX * (sizeY = start.m_123342_() - end.m_123342_()) * (sizeZ = start.m_123343_() - end.m_123343_())) / 100)) {
            return;
        }
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)start, (BlockPos)end)) {
            blocks.add(pos.m_7949_());
        }
        this.hazardZones.put(source, new HazardZone(blocks, canSpread, trigger, condition));
        this.m_77762_();
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        ListTag hazardZonesTag = new ListTag();
        for (Map.Entry<BlockPos, HazardZone> entry : this.hazardZones.entrySet()) {
            CompoundTag zoneTag = new CompoundTag();
            zoneTag.m_128356_("pos", entry.getKey().m_121878_());
            entry.getValue().serializeNBT(zoneTag);
            hazardZonesTag.add((Object)zoneTag);
        }
        compoundTag.m_128365_("zones", (Tag)hazardZonesTag);
        return compoundTag;
    }

    public Map<BlockPos, HazardZone> getHazardZones() {
        return this.hazardZones;
    }

    public record HazardZone(Set<BlockPos> blocks, boolean canSpread, HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
        public int strength() {
            return this.blocks.size();
        }

        public CompoundTag serializeNBT(CompoundTag zoneTag) {
            ListTag blocksTag = new ListTag();
            this.blocks.stream().map(NbtUtils::m_129224_).forEach(arg_0 -> blocksTag.add(arg_0));
            zoneTag.m_128365_("blocks", (Tag)blocksTag);
            zoneTag.m_128379_("can_spread", this.canSpread);
            zoneTag.m_128359_("trigger", this.trigger.name());
            zoneTag.m_128359_("condition", this.condition.name);
            return zoneTag;
        }

        public static HazardZone deserializeNBT(CompoundTag zoneTag) {
            Set<BlockPos> blocks = zoneTag.m_128437_("blocks", 10).stream().map(CompoundTag.class::cast).map(NbtUtils::m_129239_).collect(Collectors.toSet());
            boolean canSpread = zoneTag.m_128471_("can_spread");
            HazardProperty.HazardTrigger trigger = HazardProperty.HazardTrigger.ALL_TRIGGERS.get(zoneTag.m_128461_("trigger"));
            MedicalCondition condition = MedicalCondition.CONDITIONS.get(zoneTag.m_128461_("condition"));
            return new HazardZone(blocks, canSpread, trigger, condition);
        }
    }
}

