/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.commands;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IMedicalConditionTracker;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.HazardProperty;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.gui.factory.GTUIEditorFactory;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.capability.LocalizedHazardSavedData;
import com.gregtechceu.gtceu.common.commands.arguments.MedicalConditionArgument;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public class ServerCommands {
    private static final SimpleCommandExceptionType ERROR_CLEAR_EVERYTHING_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.effect.clear.everything.failed"));
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.effect.give.failed"));

    public static List<LiteralArgumentBuilder<CommandSourceStack>> createServerCommands() {
        return List.of((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"gtceu").then(Commands.m_82127_((String)"ui_editor").executes(context -> {
            GTUIEditorFactory.INSTANCE.openUI((Object)GTUIEditorFactory.INSTANCE, ((CommandSourceStack)context.getSource()).m_81375_());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"check_recipes_valid").requires(cs -> cs.m_6761_(0))).executes(context -> {
            for (Recipe recipe : ((CommandSourceStack)context.getSource()).m_81377_().m_129894_().m_44051_()) {
                GTRecipe gtRecipe;
                if (!(recipe instanceof GTRecipe) || (gtRecipe = (GTRecipe)recipe).checkRecipeValid()) continue;
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"recipe %s is invalid".formatted(gtRecipe.id)), false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"medical_condition").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"query").executes(context -> ServerCommands.queryMedicalConditions(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> ServerCommands.queryMedicalConditions(EntityArgument.m_91474_((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").executes(context -> ServerCommands.clearMedicalConditions(Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()), null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(context -> ServerCommands.clearMedicalConditions(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), null))).then(Commands.m_82129_((String)"condition", (ArgumentType)MedicalConditionArgument.medicalCondition()).executes(context -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)context, (String)"targets");
            MedicalCondition condition = MedicalConditionArgument.getCondition(context, "condition");
            return ServerCommands.clearMedicalConditions(targets, condition);
        }))))).then(Commands.m_82127_((String)"apply").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"condition", (ArgumentType)MedicalConditionArgument.medicalCondition()).executes(context -> {
            MedicalCondition condition = MedicalConditionArgument.getCondition(context, "condition");
            Collection players = EntityArgument.m_91477_((CommandContext)context, (String)"targets");
            return ServerCommands.applyMedicalConditions(players, condition, 1.0f);
        })).then(Commands.m_82129_((String)"progression_multiplier", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> {
            MedicalCondition condition = MedicalConditionArgument.getCondition(context, "condition");
            Collection players = EntityArgument.m_91477_((CommandContext)context, (String)"targets");
            float strength = FloatArgumentType.getFloat((CommandContext)context, (String)"progression_multiplier");
            return ServerCommands.applyMedicalConditions(players, condition, strength);
        }))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"environmental_hazard").then(Commands.m_82129_((String)"condition", (ArgumentType)MedicalConditionArgument.medicalCondition()).then(Commands.m_82129_((String)"can_spread", (ArgumentType)BoolArgumentType.bool()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"source", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82127_((String)"chunk").then(Commands.m_82129_((String)"strength", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ServerCommands::spawnChunkEnvironmentalHazard)))).then(Commands.m_82127_((String)"local").then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(ServerCommands::spawnLocalEnvironmentalHazard)))))))).then(Commands.m_82127_((String)"clear").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"source", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            BlockPos source = BlockPosArgument.m_264582_((CommandContext)context, (String)"source");
            return ServerCommands.clearEnvironmentalHazard((CommandContext<CommandSourceStack>)context, source, null);
        })).then(Commands.m_82129_((String)"condition", (ArgumentType)MedicalConditionArgument.medicalCondition()).executes(context -> {
            BlockPos source = BlockPosArgument.m_264582_((CommandContext)context, (String)"source");
            MedicalCondition condition = MedicalConditionArgument.getCondition(context, "condition");
            return ServerCommands.clearEnvironmentalHazard((CommandContext<CommandSourceStack>)context, source, condition);
        }))))));
    }

    private static int queryMedicalConditions(ServerPlayer target) throws CommandSyntaxException {
        IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)target);
        if (tracker == null) {
            throw EntityArgument.f_91440_.create();
        }
        int count = tracker.getMedicalConditions().size();
        if (count == 0) {
            target.m_213846_((Component)Component.m_237110_((String)"command.gtceu.medical_condition.get.empty", (Object[])new Object[]{target.m_7755_()}));
        } else {
            target.m_213846_((Component)Component.m_237110_((String)"command.gtceu.medical_condition.get", (Object[])new Object[]{target.m_7755_()}));
        }
        for (Object2FloatMap.Entry entry : tracker.getMedicalConditions().object2FloatEntrySet()) {
            String langKey = "command.gtceu.medical_condition.get.element";
            if (((MedicalCondition)entry.getKey()).maxProgression * 2.0f <= entry.getFloatValue() && ((MedicalCondition)entry.getKey()).canBePermanent) {
                langKey = "command.gtceu.medical_condition.get.element.permanent";
            }
            target.m_213846_((Component)Component.m_237110_((String)langKey, (Object[])new Object[]{Component.m_237115_((String)("gtceu.medical_condition." + ((MedicalCondition)entry.getKey()).name)), Float.valueOf(entry.getFloatValue() / 20.0f)}));
        }
        return count;
    }

    private static int clearMedicalConditions(Collection<ServerPlayer> targets, @Nullable MedicalCondition condition) throws CommandSyntaxException {
        int count = 0;
        for (ServerPlayer target : targets) {
            IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)target);
            if (tracker == null) continue;
            if (condition == null) {
                count += tracker.getMedicalConditions().keySet().size();
                for (MedicalCondition medicalCondition : tracker.getMedicalConditions().keySet()) {
                    tracker.removeMedicalCondition(medicalCondition);
                }
                continue;
            }
            ++count;
            tracker.removeMedicalCondition(condition);
        }
        if (count == 0) {
            throw ERROR_CLEAR_EVERYTHING_FAILED.create();
        }
        return count;
    }

    private static int applyMedicalConditions(Collection<ServerPlayer> targets, MedicalCondition condition, float strength) throws CommandSyntaxException {
        int success = 0;
        for (ServerPlayer player : targets) {
            IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)player);
            if (tracker == null) continue;
            tracker.progressCondition(condition, strength);
            ++success;
        }
        if (success == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        return success;
    }

    private static int spawnChunkEnvironmentalHazard(CommandContext<CommandSourceStack> context) {
        ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).m_81372_();
        BlockPos source = BlockPosArgument.m_264582_(context, (String)"source");
        int strength = IntegerArgumentType.getInteger(context, (String)"strength");
        MedicalCondition condition = MedicalConditionArgument.getCondition(context, "condition");
        boolean canSpread = BoolArgumentType.getBool(context, (String)"can_spread");
        EnvironmentalHazardSavedData.getOrCreate(serverLevel).addZone(source, strength, canSpread, HazardProperty.HazardTrigger.INHALATION, condition);
        return 1;
    }

    private static int spawnLocalEnvironmentalHazard(CommandContext<CommandSourceStack> context) {
        ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).m_81372_();
        BlockPos source = BlockPosArgument.m_264582_(context, (String)"source");
        BlockPos from = BlockPosArgument.m_264582_(context, (String)"from");
        BlockPos to = BlockPosArgument.m_264582_(context, (String)"to");
        MedicalCondition condition = MedicalConditionArgument.getCondition(context, "condition");
        boolean canSpread = BoolArgumentType.getBool(context, (String)"can_spread");
        LocalizedHazardSavedData.getOrCreate(serverLevel).addCuboidZone(source, from, to, canSpread, HazardProperty.HazardTrigger.INHALATION, condition);
        return 1;
    }

    private static int clearEnvironmentalHazard(CommandContext<CommandSourceStack> context, BlockPos clearAt, MedicalCondition condition) {
        ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).m_81372_();
        if (condition == null) {
            EnvironmentalHazardSavedData.getOrCreate(serverLevel).removeZone(clearAt);
            LocalizedHazardSavedData.getOrCreate(serverLevel).removeZoneByPosition(clearAt);
        } else {
            EnvironmentalHazardSavedData.getOrCreate(serverLevel).removeZone(clearAt, condition);
            LocalizedHazardSavedData.getOrCreate(serverLevel).removeZoneByPosition(clearAt, condition);
        }
        return 1;
    }
}

