/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.common.cover.data.ItemFilterMode;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemFilterCover
extends CoverBehavior
implements IUICover {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ItemFilterCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    protected ItemFilter itemFilter;
    @Persisted
    @DescSynced
    protected ItemFilterMode filterMode = ItemFilterMode.FILTER_INSERT;

    public ItemFilterCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    public ItemFilter getItemFilter() {
        if (this.itemFilter == null) {
            this.itemFilter = ItemFilter.loadFilter(this.attachItem);
        }
        return this.itemFilter;
    }

    public void setFilterMode(ItemFilterMode filterMode) {
        this.filterMode = filterMode;
        this.coverHolder.markDirty();
    }

    @Override
    public boolean canAttach() {
        return ItemTransferHelper.getItemTransfer((Level)this.coverHolder.getLevel(), (BlockPos)this.coverHolder.getPos(), (Direction)this.attachedSide) != null;
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 85);
        group.addWidget((Widget)new LabelWidget(7, 5, this.attachItem.m_41778_()));
        group.addWidget((Widget)new EnumSelectorWidget(7, 61, 18, 18, (Enum[])ItemFilterMode.VALUES, (Enum)this.filterMode, this::setFilterMode));
        group.addWidget((Widget)this.getItemFilter().openConfigurator(30, 25));
        return group;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public ItemFilterMode getFilterMode() {
        return this.filterMode;
    }
}

