/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IEnergyInfoProvider;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.LongInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.common.cover.detector.DetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.EnergyDetectorCover;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.RedstoneUtil;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextBoxWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AdvancedEnergyDetectorCover
extends EnergyDetectorCover
implements IUICover {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(AdvancedEnergyDetectorCover.class, DetectorCover.MANAGED_FIELD_HOLDER);
    @Persisted
    public long minValue;
    @Persisted
    public long maxValue;
    @Persisted
    private int outputAmount;
    @Persisted
    private boolean usePercent;
    private LongInputWidget minValueInput;
    private LongInputWidget maxValueInput;

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public AdvancedEnergyDetectorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
        int DEFAULT_MIN_PERCENT = 33;
        int DEFAULT_MAX_PERCENT = 66;
        this.minValue = 33L;
        this.maxValue = 66L;
        this.usePercent = true;
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IEnergyInfoProvider energyInfoProvider = this.getEnergyInfoProvider();
        if (energyInfoProvider == null) {
            this.setRedstoneSignalOutput(this.outputAmount);
            return;
        }
        IEnergyInfoProvider.EnergyInfo energyInfo = energyInfoProvider.getEnergyInfo();
        long capacity = energyInfo.capacity().longValue();
        long stored = energyInfo.stored().longValue();
        if (this.usePercent) {
            if (capacity > 0L) {
                float ratio = (float)stored / (float)capacity;
                this.outputAmount = RedstoneUtil.computeLatchedRedstoneBetweenValues(ratio * 100.0f, this.maxValue, this.minValue, this.isInverted(), this.outputAmount);
            } else {
                this.outputAmount = this.isInverted() ? 0 : 15;
            }
        } else {
            this.outputAmount = RedstoneUtil.computeLatchedRedstoneBetweenValues(stored, this.maxValue, this.minValue, this.isInverted(), this.outputAmount);
        }
        this.setRedstoneSignalOutput(this.outputAmount);
    }

    public void setUsePercent(boolean usePercent) {
        boolean wasPercent = this.usePercent;
        this.usePercent = usePercent;
        this.initializeMinMaxInputs(wasPercent);
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 105);
        group.addWidget((Widget)new LabelWidget(10, 5, "cover.advanced_energy_detector.label"));
        group.addWidget((Widget)new TextBoxWidget(10, 55, 25, List.of(LocalizationUtils.format((String)"cover.advanced_energy_detector.min", (Object[])new Object[0]))));
        group.addWidget((Widget)new TextBoxWidget(10, 80, 25, List.of(LocalizationUtils.format((String)"cover.advanced_energy_detector.max", (Object[])new Object[0]))));
        this.minValueInput = new LongInputWidget(40, 50, 126, 20, this::getMinValue, this::setMinValue);
        this.maxValueInput = new LongInputWidget(40, 75, 126, 20, this::getMaxValue, this::setMaxValue);
        this.initializeMinMaxInputs(this.usePercent);
        group.addWidget((Widget)this.minValueInput);
        group.addWidget((Widget)this.maxValueInput);
        group.addWidget((Widget)new ToggleButtonWidget(9, 20, 20, 20, (IGuiTexture)GuiTextures.INVERT_REDSTONE_BUTTON, this::isInverted, this::setInverted){

            @Override
            public void updateScreen() {
                super.updateScreen();
                this.setHoverTooltips(List.copyOf(LangHandler.getMultiLang("cover.advanced_energy_detector.invert." + (this.isPressed ? "enabled" : "disabled"))));
            }
        });
        group.addWidget((Widget)new ToggleButtonWidget(147, 20, 20, 20, (IGuiTexture)GuiTextures.ENERGY_DETECTOR_COVER_MODE_BUTTON, this::isUsePercent, this::setUsePercent){

            @Override
            public void updateScreen() {
                super.updateScreen();
                this.setHoverTooltips(List.copyOf(LangHandler.getMultiLang("cover.advanced_energy_detector.use_percent." + (this.isPressed ? "enabled" : "disabled"))));
            }
        });
        return group;
    }

    private void initializeMinMaxInputs(boolean wasPercent) {
        if (LDLib.isRemote() || this.minValueInput == null || this.maxValueInput == null) {
            return;
        }
        long energyCapacity = this.getEnergyInfoProvider().getEnergyInfo().capacity().longValue();
        this.minValueInput.setMin(0L);
        this.maxValueInput.setMin(0L);
        if (this.usePercent) {
            if (!wasPercent) {
                this.minValueInput.setValue(Math.max((long)((double)this.minValue / (double)energyCapacity * 100.0), 100L));
                this.minValueInput.setValue(GTMath.clamp((long)((double)this.minValue / (double)energyCapacity * 100.0), 0L, 100L));
                this.maxValueInput.setValue(GTMath.clamp((long)((double)this.maxValue / (double)energyCapacity * 100.0), 0L, 100L));
            }
            this.minValueInput.setMax(100L);
            this.maxValueInput.setMax(100L);
        } else {
            this.minValueInput.setMax(energyCapacity);
            this.maxValueInput.setMax(energyCapacity);
            if (wasPercent) {
                this.minValueInput.setValue(GTMath.clamp((int)((double)this.minValue / 100.0 * (double)energyCapacity), 0L, energyCapacity));
                this.maxValueInput.setValue(GTMath.clamp((int)((double)this.maxValue / 100.0 * (double)energyCapacity), 0L, energyCapacity));
            }
        }
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public int getOutputAmount() {
        return this.outputAmount;
    }

    public void setOutputAmount(int outputAmount) {
        this.outputAmount = outputAmount;
    }

    public boolean isUsePercent() {
        return this.usePercent;
    }
}

