/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.common.cover.detector.DetectorCover;
import com.gregtechceu.gtceu.utils.RedstoneUtil;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public class FluidDetectorCover
extends DetectorCover {
    public FluidDetectorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public boolean canAttach() {
        return this.getFluidTransfer() != null;
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IFluidTransfer fluidHandler = this.getFluidTransfer();
        if (fluidHandler == null) {
            return;
        }
        long storedFluid = 0L;
        long fluidCapacity = 0L;
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            FluidStack content = fluidHandler.getFluidInTank(tank);
            if (!content.isEmpty()) {
                storedFluid += content.getAmount();
            }
            fluidCapacity += fluidHandler.getTankCapacity(tank);
        }
        if (fluidCapacity == 0L) {
            return;
        }
        this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneValue(storedFluid, fluidCapacity, this.isInverted()));
    }

    protected IFluidTransfer getFluidTransfer() {
        return FluidTransferHelper.getFluidTransfer((Level)this.coverHolder.getLevel(), (BlockPos)this.coverHolder.getPos(), (Direction)this.attachedSide);
    }
}

