/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.voiding;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.common.cover.ConveyorCover;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemVoidingCover
extends ConveyorCover
implements IUICover,
IControllable {
    @Persisted
    protected boolean isEnabled = false;
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ItemVoidingCover.class, ConveyorCover.MANAGED_FIELD_HOLDER);

    public ItemVoidingCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide, 0);
    }

    @Override
    protected boolean isSubscriptionActive() {
        return this.isWorkingEnabled() && this.isEnabled();
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 5L != 0L) {
            return;
        }
        this.doVoidItems();
        this.subscriptionHandler.updateSubscription();
    }

    protected void doVoidItems() {
        IItemTransfer itemTransfer = this.getOwnItemTransfer();
        if (itemTransfer == null) {
            return;
        }
        this.voidAny(itemTransfer);
    }

    void voidAny(IItemTransfer itemTransfer) {
        ItemFilter filter = (ItemFilter)this.filterHandler.getFilter();
        for (int slot = 0; slot < itemTransfer.getSlots(); ++slot) {
            ItemStack sourceStack = itemTransfer.extractItem(slot, Integer.MAX_VALUE, true);
            if (sourceStack.m_41619_() || !filter.test(sourceStack)) continue;
            itemTransfer.extractItem(slot, Integer.MAX_VALUE, false);
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.isWorkingEnabled = workingEnabled;
        this.subscriptionHandler.updateSubscription();
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.subscriptionHandler.updateSubscription();
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 120);
        group.addWidget((Widget)new LabelWidget(10, 5, this.getUITitle()));
        group.addWidget((Widget)new ToggleButtonWidget(10, 20, 20, 20, (IGuiTexture)GuiTextures.BUTTON_POWER, this::isEnabled, this::setEnabled));
        group.addWidget(this.filterHandler.createFilterSlotUI(148, 91));
        group.addWidget(this.filterHandler.createFilterConfigUI(10, 50, 126, 60));
        this.buildAdditionalUI(group);
        return group;
    }

    @Override
    @NotNull
    protected String getUITitle() {
        return "cover.item.voiding.title";
    }

    @Override
    protected void buildAdditionalUI(WidgetGroup group) {
    }

    @Override
    protected void configureFilter() {
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

