/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.client.renderer.cover.ConveyorCoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.FacadeCoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.FluidRegulatorCoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.PumpCoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.RobotArmCoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.SimpleCoverRenderer;
import com.gregtechceu.gtceu.common.cover.ComputerMonitorCover;
import com.gregtechceu.gtceu.common.cover.ConveyorCover;
import com.gregtechceu.gtceu.common.cover.CoverSolarPanel;
import com.gregtechceu.gtceu.common.cover.FacadeCover;
import com.gregtechceu.gtceu.common.cover.FluidFilterCover;
import com.gregtechceu.gtceu.common.cover.FluidRegulatorCover;
import com.gregtechceu.gtceu.common.cover.InfiniteWaterCover;
import com.gregtechceu.gtceu.common.cover.ItemFilterCover;
import com.gregtechceu.gtceu.common.cover.MachineControllerCover;
import com.gregtechceu.gtceu.common.cover.PumpCover;
import com.gregtechceu.gtceu.common.cover.RobotArmCover;
import com.gregtechceu.gtceu.common.cover.ShutterCover;
import com.gregtechceu.gtceu.common.cover.detector.ActivityDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.AdvancedActivityDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.AdvancedEnergyDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.AdvancedFluidDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.AdvancedItemDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.EnergyDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.FluidDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.ItemDetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.MaintenanceDetectorCover;
import com.gregtechceu.gtceu.common.cover.voiding.AdvancedFluidVoidingCover;
import com.gregtechceu.gtceu.common.cover.voiding.AdvancedItemVoidingCover;
import com.gregtechceu.gtceu.common.cover.voiding.FluidVoidingCover;
import com.gregtechceu.gtceu.common.cover.voiding.ItemVoidingCover;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.Arrays;
import java.util.Locale;
import net.minecraftforge.fml.ModLoader;

public class GTCovers {
    public static final int[] ALL_TIERS = GTValues.tiersBetween(1, GTCEuAPI.isHighTier() ? 13 : 8);
    public static final int[] ALL_TIERS_WITH_ULV = GTValues.tiersBetween(0, GTCEuAPI.isHighTier() ? 13 : 8);
    public static final CoverDefinition FACADE;
    public static final CoverDefinition ITEM_FILTER;
    public static final CoverDefinition FLUID_FILTER;
    public static final CoverDefinition INFINITE_WATER;
    public static final CoverDefinition SHUTTER;
    public static final CoverDefinition[] CONVEYORS;
    public static final CoverDefinition[] ROBOT_ARMS;
    public static final CoverDefinition[] PUMPS;
    public static final CoverDefinition[] FLUID_REGULATORS;
    public static final CoverDefinition COMPUTER_MONITOR;
    public static final CoverDefinition MACHINE_CONTROLLER;
    public static final CoverDefinition ITEM_VOIDING;
    public static final CoverDefinition ITEM_VOIDING_ADVANCED;
    public static final CoverDefinition FLUID_VOIDING;
    public static final CoverDefinition FLUID_VOIDING_ADVANCED;
    public static final CoverDefinition ACTIVITY_DETECTOR;
    public static final CoverDefinition ACTIVITY_DETECTOR_ADVANCED;
    public static final CoverDefinition FLUID_DETECTOR;
    public static final CoverDefinition FLUID_DETECTOR_ADVANCED;
    public static final CoverDefinition ITEM_DETECTOR;
    public static final CoverDefinition ITEM_DETECTOR_ADVANCED;
    public static final CoverDefinition ENERGY_DETECTOR;
    public static final CoverDefinition ENERGY_DETECTOR_ADVANCED;
    public static final CoverDefinition MAINTENANCE_DETECTOR;
    public static final CoverDefinition[] SOLAR_PANEL;

    public static CoverDefinition register(String id, CoverDefinition.CoverBehaviourProvider behaviorCreator) {
        return GTCovers.register(id, behaviorCreator, new SimpleCoverRenderer(GTCEu.id("block/cover/" + id)));
    }

    public static CoverDefinition register(String id, CoverDefinition.CoverBehaviourProvider behaviorCreator, ICoverRenderer coverRenderer) {
        CoverDefinition definition = new CoverDefinition(GTCEu.id(id), behaviorCreator, coverRenderer);
        GTRegistries.COVERS.register(GTCEu.id(id), definition);
        return definition;
    }

    public static CoverDefinition[] registerTiered(String id, CoverDefinition.TieredCoverBehaviourProvider behaviorCreator, Int2ObjectFunction<ICoverRenderer> coverRenderer, int ... tiers) {
        return (CoverDefinition[])Arrays.stream(tiers).mapToObj(tier -> {
            String name = id + "." + GTValues.VN[tier].toLowerCase(Locale.ROOT);
            return GTCovers.register(name, (def, coverable, side) -> behaviorCreator.create(def, coverable, side, tier), (ICoverRenderer)coverRenderer.apply(tier));
        }).toArray(CoverDefinition[]::new);
    }

    public static CoverDefinition[] registerTiered(String id, CoverDefinition.TieredCoverBehaviourProvider behaviorCreator, int ... tiers) {
        return (CoverDefinition[])Arrays.stream(tiers).mapToObj(tier -> {
            String name = id + "." + GTValues.VN[tier].toLowerCase(Locale.ROOT);
            return GTCovers.register(name, (def, coverable, side) -> behaviorCreator.create(def, coverable, side, tier));
        }).toArray(CoverDefinition[]::new);
    }

    public static void init() {
        AddonFinder.getAddons().forEach(IGTAddon::registerCovers);
        ModLoader.get().postEvent(new GTCEuAPI.RegisterEvent(GTRegistries.COVERS, CoverDefinition.class));
        GTRegistries.COVERS.freeze();
    }

    static {
        GTRegistries.COVERS.unfreeze();
        FACADE = GTCovers.register("facade", FacadeCover::new, FacadeCoverRenderer.INSTANCE);
        ITEM_FILTER = GTCovers.register("item_filter", ItemFilterCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_item_filter")));
        FLUID_FILTER = GTCovers.register("fluid_filter", FluidFilterCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_fluid_filter")));
        INFINITE_WATER = GTCovers.register("infinite_water", InfiniteWaterCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_infinite_water")));
        SHUTTER = GTCovers.register("shutter", ShutterCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_shutter")));
        CONVEYORS = GTCovers.registerTiered("conveyor", ConveyorCover::new, (Int2ObjectFunction<ICoverRenderer>)((Int2ObjectFunction)tier -> ConveyorCoverRenderer.INSTANCE), ALL_TIERS);
        ROBOT_ARMS = GTCovers.registerTiered("robot_arm", RobotArmCover::new, (Int2ObjectFunction<ICoverRenderer>)((Int2ObjectFunction)tier -> RobotArmCoverRenderer.INSTANCE), ALL_TIERS);
        PUMPS = GTCovers.registerTiered("pump", PumpCover::new, (Int2ObjectFunction<ICoverRenderer>)((Int2ObjectFunction)tier -> PumpCoverRenderer.INSTANCE), ALL_TIERS);
        FLUID_REGULATORS = GTCovers.registerTiered("fluid_regulator", FluidRegulatorCover::new, (Int2ObjectFunction<ICoverRenderer>)((Int2ObjectFunction)tier -> FluidRegulatorCoverRenderer.INSTANCE), ALL_TIERS);
        COMPUTER_MONITOR = GTCovers.register("computer_monitor", ComputerMonitorCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_display")));
        MACHINE_CONTROLLER = GTCovers.register("machine_controller", MachineControllerCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_controller")));
        ITEM_VOIDING = GTCovers.register("item_voiding", ItemVoidingCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_item_voiding")));
        ITEM_VOIDING_ADVANCED = GTCovers.register("item_voiding_advanced", AdvancedItemVoidingCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_item_voiding_advanced")));
        FLUID_VOIDING = GTCovers.register("fluid_voiding", FluidVoidingCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_fluid_voiding")));
        FLUID_VOIDING_ADVANCED = GTCovers.register("fluid_voiding_advanced", AdvancedFluidVoidingCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_fluid_voiding_advanced")));
        ACTIVITY_DETECTOR = GTCovers.register("activity_detector", ActivityDetectorCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_activity_detector")));
        ACTIVITY_DETECTOR_ADVANCED = GTCovers.register("activity_detector_advanced", AdvancedActivityDetectorCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_activity_detector_advanced")));
        FLUID_DETECTOR = GTCovers.register("fluid_detector", FluidDetectorCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_fluid_detector")));
        FLUID_DETECTOR_ADVANCED = GTCovers.register("fluid_detector_advanced", AdvancedFluidDetectorCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_fluid_detector_advanced")));
        ITEM_DETECTOR = GTCovers.register("item_detector", ItemDetectorCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_item_detector")));
        ITEM_DETECTOR_ADVANCED = GTCovers.register("item_detector_advanced", AdvancedItemDetectorCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_item_detector_advanced")));
        ENERGY_DETECTOR = GTCovers.register("energy_detector", EnergyDetectorCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_energy_detector")));
        ENERGY_DETECTOR_ADVANCED = GTCovers.register("energy_detector_advanced", AdvancedEnergyDetectorCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_energy_detector_advanced")));
        MAINTENANCE_DETECTOR = GTCovers.register("maintenance_detector", MaintenanceDetectorCover::new, new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_maintenance_detector")));
        SOLAR_PANEL = GTCovers.registerTiered("solar_panel", CoverSolarPanel::new, (Int2ObjectFunction<ICoverRenderer>)((Int2ObjectFunction)tier -> new SimpleCoverRenderer(GTCEu.id("block/cover/overlay_solar_panel"))), ALL_TIERS_WITH_ULV);
    }
}

