/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.CoilWorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.data.GTMedicalConditions;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.LongIntPair;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTRecipeModifiers {
    public static final Function<OverclockingLogic, RecipeModifier> ELECTRIC_OVERCLOCK = Util.m_143827_(ElectricOverclockModifier::new);
    public static final RecipeModifier PARALLEL_HATCH = (machine, recipe) -> (GTRecipe)GTRecipeModifiers.hatchParallel(machine, recipe, false).getFirst();
    public static final RecipeModifier SUBTICK_PARALLEL = (machine, recipe) -> GTRecipeModifiers.subtickParallel(machine, recipe, false);
    public static final BiFunction<MedicalCondition, Integer, RecipeModifier> ENVIRONMENT_REQUIREMENT = Util.m_143821_((condition, maxAllowedStrength) -> (machine, recipe) -> {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return recipe;
        }
        Level level = machine.getLevel();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        EnvironmentalHazardSavedData data = EnvironmentalHazardSavedData.getOrCreate(serverLevel);
        BlockPos machinePos = machine.getPos();
        EnvironmentalHazardSavedData.HazardZone zone = data.getZoneByContainedPosAndCondition(machinePos, (MedicalCondition)condition);
        if (zone == null) {
            return recipe;
        }
        float strength = zone.strength();
        if (strength > (float)maxAllowedStrength.intValue()) {
            return null;
        }
        recipe = recipe.copy();
        int originalDuration = recipe.duration;
        recipe.duration *= 1 + (int)(strength * 5.0f / (float)maxAllowedStrength.intValue());
        if (recipe.duration > 5 * originalDuration) {
            return null;
        }
        return recipe;
    });
    public static final RecipeModifier DEFAULT_ENVIRONMENT_REQUIREMENT = ENVIRONMENT_REQUIREMENT.apply(GTMedicalConditions.CARBON_MONOXIDE_POISONING, 1000);

    public static Pair<GTRecipe, Integer> fastParallel(MetaMachine machine, @NotNull GTRecipe recipe, int maxParallel, boolean modifyDuration) {
        if (machine instanceof IRecipeCapabilityHolder) {
            IRecipeCapabilityHolder holder = (IRecipeCapabilityHolder)((Object)machine);
            while (maxParallel > 0) {
                GTRecipe copied = recipe.copy(ContentModifier.multiplier(maxParallel), modifyDuration);
                if (copied.matchRecipe(holder).isSuccess() && copied.matchTickRecipe(holder).isSuccess()) {
                    return Pair.of((Object)copied, (Object)maxParallel);
                }
                maxParallel /= 2;
            }
        }
        return Pair.of((Object)recipe, (Object)1);
    }

    public static Pair<GTRecipe, Integer> accurateParallel(MetaMachine machine, @NotNull GTRecipe recipe, int maxParallel, boolean modifyDuration) {
        if (maxParallel == 1) {
            return Pair.of((Object)recipe, (Object)1);
        }
        return ParallelLogic.applyParallel(machine, recipe, maxParallel, modifyDuration);
    }

    public static Pair<GTRecipe, Integer> hatchParallel(MetaMachine machine, @NotNull GTRecipe recipe, boolean modifyDuration) {
        IMultiController controller;
        if (machine instanceof IMultiController && (controller = (IMultiController)((Object)machine)).isFormed()) {
            Optional<IParallelHatch> optional = controller.getParts().stream().filter(IParallelHatch.class::isInstance).map(IParallelHatch.class::cast).findAny();
            if (optional.isPresent()) {
                IParallelHatch hatch = optional.get();
                return ParallelLogic.applyParallel(machine, recipe, hatch.getCurrentParallel(), modifyDuration);
            }
        }
        return Pair.of((Object)recipe, (Object)1);
    }

    public static GTRecipe crackerOverclock(MetaMachine machine, @NotNull GTRecipe recipe) {
        if (machine instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
            if (RecipeHelper.getRecipeEUtTier(recipe) > coilMachine.getTier()) {
                return null;
            }
            return RecipeHelper.applyOverclock(new OverclockingLogic((recipe1, recipeEUt, maxVoltage, duration, amountOC) -> {
                LongIntPair pair = OverclockingLogic.NON_PERFECT_OVERCLOCK.getLogic().runOverclockingLogic(recipe, recipeEUt, maxVoltage, duration, amountOC);
                if (coilMachine.getCoilTier() > 0) {
                    double eu = (double)pair.firstLong() * (1.0 - (double)coilMachine.getCoilTier() * 0.1);
                    pair.first((long)Math.max(1.0, eu));
                }
                return pair;
            }), recipe, coilMachine.getOverclockVoltage());
        }
        return null;
    }

    public static GTRecipe ebfOverclock(MetaMachine machine, @NotNull GTRecipe recipe) {
        if (machine instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
            int blastFurnaceTemperature = coilMachine.getCoilType().getCoilTemperature() + 100 * Math.max(0, coilMachine.getTier() - 2);
            if (!recipe.data.m_128441_("ebf_temp") || recipe.data.m_128451_("ebf_temp") > blastFurnaceTemperature) {
                return null;
            }
            if (RecipeHelper.getRecipeEUtTier(recipe) > coilMachine.getTier()) {
                return null;
            }
            return RecipeHelper.applyOverclock(new OverclockingLogic((recipe1, recipeEUt, maxVoltage, duration, amountOC) -> OverclockingLogic.heatingCoilOverclockingLogic(Math.abs(recipeEUt), maxVoltage, duration, amountOC, blastFurnaceTemperature, recipe.data.m_128441_("ebf_temp") ? recipe.data.m_128451_("ebf_temp") : 0)), recipe, coilMachine.getOverclockVoltage());
        }
        return null;
    }

    public static GTRecipe pyrolyseOvenOverclock(MetaMachine machine, @NotNull GTRecipe recipe) {
        if (machine instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
            if (RecipeHelper.getRecipeEUtTier(recipe) > coilMachine.getTier()) {
                return null;
            }
            return RecipeHelper.applyOverclock(new OverclockingLogic((recipe1, recipeEUt, maxVoltage, duration, amountOC) -> {
                LongIntPair pair = OverclockingLogic.NON_PERFECT_OVERCLOCK.getLogic().runOverclockingLogic(recipe1, recipeEUt, maxVoltage, duration, amountOC);
                if (coilMachine.getCoilTier() == 0) {
                    pair.second(pair.secondInt() * 5 / 4);
                } else {
                    pair.second(pair.secondInt() * 2 / (coilMachine.getCoilTier() + 1));
                }
                pair.second(Math.max(1, pair.secondInt()));
                return pair;
            }), recipe, coilMachine.getOverclockVoltage());
        }
        return null;
    }

    public static GTRecipe multiSmelterParallel(MetaMachine machine, @NotNull GTRecipe recipe) {
        if (machine instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
            int maxParallel = 32 * coilMachine.getCoilType().getLevel();
            Pair<GTRecipe, Integer> result = GTRecipeModifiers.accurateParallel(machine, recipe, maxParallel, false);
            recipe = result.getFirst() == recipe ? ((GTRecipe)result.getFirst()).copy() : (GTRecipe)result.getFirst();
            int parallelValue = (Integer)result.getSecond();
            recipe.duration = Math.max(1, 256 * parallelValue / maxParallel);
            long eut = 4 * (parallelValue / 8) / coilMachine.getCoilType().getEnergyDiscount();
            recipe.tickInputs.put(EURecipeCapability.CAP, List.of(new Content(eut, ChanceLogic.getMaxChancedValue(), ChanceLogic.getMaxChancedValue(), 0, null, null)));
            return recipe;
        }
        return null;
    }

    public static GTRecipe subtickParallel(MetaMachine machine, @NotNull GTRecipe recipe, boolean modifyDuration) {
        if (machine instanceof WorkableElectricMultiblockMachine) {
            WorkableElectricMultiblockMachine electricMachine = (WorkableElectricMultiblockMachine)machine;
            Pair[] result = new Pair[]{null};
            RecipeHelper.applyOverclock(new OverclockingLogic((recipe1, recipeEUt, maxVoltage, duration, amountOC) -> {
                ImmutableTriple<Long, Integer, Integer> parallel = OverclockingLogic.standardOverclockingLogicWithSubTickParallelCount(Math.abs(recipeEUt), maxVoltage, duration, amountOC, OverclockingLogic.STANDARD_OVERCLOCK_DURATION_DIVISOR, 4.0);
                result[0] = GTRecipeModifiers.accurateParallel(machine, recipe, (Integer)parallel.getRight(), modifyDuration);
                return LongIntPair.of((long)((Long)parallel.getLeft()), (int)((Integer)parallel.getMiddle()));
            }), recipe, electricMachine.getOverclockVoltage());
            if (result[0] != null) {
                return (GTRecipe)result[0].getFirst();
            }
        }
        return recipe;
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    public static class ElectricOverclockModifier
    implements RecipeModifier {
        private final OverclockingLogic overclockingLogic;

        public ElectricOverclockModifier(OverclockingLogic overclockingLogic) {
            this.overclockingLogic = overclockingLogic;
        }

        @Override
        @Nullable
        public GTRecipe apply(MetaMachine machine, @NotNull GTRecipe recipe) {
            if (machine instanceof IOverclockMachine) {
                IOverclockMachine overclockMachine = (IOverclockMachine)((Object)machine);
                if (RecipeHelper.getRecipeEUtTier(recipe) / recipe.parallels > overclockMachine.getMaxOverclockTier()) {
                    return null;
                }
                return RecipeHelper.applyOverclock(this.overclockingLogic, recipe, overclockMachine.getOverclockVoltage());
            }
            if (machine instanceof ITieredMachine) {
                ITieredMachine tieredMachine = (ITieredMachine)((Object)machine);
                if (RecipeHelper.getRecipeEUtTier(recipe) > tieredMachine.getTier()) {
                    return null;
                }
            }
            return recipe;
        }
    }
}

