/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.common.item.armor.Jetpack;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AdvancedJetpack
extends Jetpack {
    public AdvancedJetpack(int energyPerUse, long capacity, int tier) {
        super(energyPerUse, capacity, tier);
    }

    @Override
    public void onArmorTick(Level world, Player player, @NotNull ItemStack stack) {
        boolean jetpackEnabled;
        IElectricItem cont = GTCapabilityHelper.getElectricItem(stack);
        if (cont == null) {
            return;
        }
        CompoundTag data = stack.m_41784_();
        boolean hoverMode = data.m_128441_("hover") && data.m_128471_("hover");
        byte toggleTimer = data.m_128441_("toggleTimer") ? data.m_128445_("toggleTimer") : (byte)0;
        boolean bl = jetpackEnabled = !data.m_128441_("enabled") || data.m_128471_("enabled");
        if (toggleTimer == 0 && KeyBind.ARMOR_HOVER.isKeyDown(player)) {
            hoverMode = !hoverMode;
            toggleTimer = 5;
            data.m_128379_("hover", hoverMode);
            if (!world.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)("metaarmor.jetpack.hover." + (hoverMode ? "enable" : "disable"))), true);
            }
        }
        if (toggleTimer == 0 && KeyBind.JETPACK_ENABLE.isKeyDown(player)) {
            jetpackEnabled = !jetpackEnabled;
            toggleTimer = 5;
            data.m_128379_("enabled", jetpackEnabled);
            if (!world.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)("metaarmor.jetpack.flight." + (jetpackEnabled ? "enable" : "disable"))), true);
            }
        }
        this.performFlying(player, jetpackEnabled, hoverMode, stack);
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.m_128379_("hover", hoverMode);
        data.m_128379_("enabled", jetpackEnabled);
        data.m_128344_("toggleTimer", toggleTimer);
    }

    @Override
    public double getSprintEnergyModifier() {
        return 2.5;
    }

    @Override
    public double getSprintSpeedModifier() {
        return 1.3;
    }

    @Override
    public double getVerticalHoverSpeed() {
        return 0.34;
    }

    @Override
    public double getVerticalHoverSlowSpeed() {
        return 0.03;
    }

    @Override
    public double getVerticalAcceleration() {
        return 0.13;
    }

    @Override
    public double getVerticalSpeed() {
        return 0.48;
    }

    @Override
    public double getSidewaysSpeed() {
        return 0.14;
    }

    @Override
    public ParticleOptions getParticle() {
        return ParticleTypes.f_123796_;
    }

    @Override
    public float getFallDamageReduction() {
        return 2.0f;
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return GTCEu.id("textures/armor/advanced_jetpack.png");
    }
}

