/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IJetpack {
    default public double getSprintEnergyModifier() {
        return 1.0;
    }

    default public double getSprintSpeedModifier() {
        return 1.0;
    }

    default public double getVerticalHoverSpeed() {
        return 0.18;
    }

    default public double getVerticalHoverSlowSpeed() {
        return 0.14;
    }

    default public double getVerticalAcceleration() {
        return 0.1;
    }

    default public double getVerticalSpeed() {
        return 0.22;
    }

    default public double getSidewaysSpeed() {
        return 0.0;
    }

    @Nullable
    default public ParticleOptions getParticle() {
        return ParticleTypes.f_123755_;
    }

    default public float getFallDamageReduction() {
        return 0.0f;
    }

    public int getEnergyPerUse();

    public boolean canUseEnergy(ItemStack var1, int var2);

    public void drainEnergy(ItemStack var1, int var2);

    public boolean hasEnergy(ItemStack var1);

    default public void performFlying(@NotNull Player player, boolean flightEnabled, boolean hover, ItemStack stack) {
        double deltaY = player.m_20184_().m_7098_();
        if (!hover || !flightEnabled) {
            if (player.m_20182_().m_7098_() < (double)(player.m_9236_().m_141937_() - 5)) {
                IJetpack.performEHover(stack, player);
            } else if (!player.m_7500_() && player.f_19789_ - 1.2f >= player.m_21223_() && !player.m_20096_() && !player.m_6069_()) {
                IJetpack.performEHover(stack, player);
            }
        }
        if (!flightEnabled) {
            return;
        }
        boolean flyKeyDown = KeyBind.VANILLA_JUMP.isKeyDown(player);
        boolean descendKeyDown = KeyBind.VANILLA_SNEAK.isKeyDown(player);
        double hoverSpeed = descendKeyDown ? this.getVerticalHoverSpeed() : this.getVerticalHoverSlowSpeed();
        double currentAccel = this.getVerticalAcceleration() * (deltaY < 0.3 ? 2.5 : 1.0);
        double currentSpeedVertical = this.getVerticalSpeed() * (player.m_20069_() ? 0.4 : 1.0);
        if (!player.m_20096_() && this.canUseEnergy(stack, this.getEnergyPerUse())) {
            this.drainEnergy(stack, (int)(player.m_20142_() ? Math.round((double)this.getEnergyPerUse() * this.getSprintEnergyModifier()) : (long)this.getEnergyPerUse()));
            boolean editMotion = false;
            if (this.hasEnergy(stack)) {
                double potentialY;
                if (hover) {
                    potentialY = flyKeyDown && descendKeyDown ? this.getVerticalHoverSlowSpeed() : (flyKeyDown ? this.getVerticalHoverSpeed() : (descendKeyDown ? -this.getVerticalHoverSpeed() : 0.0));
                    if (player.m_21255_()) {
                        player.m_36321_();
                    }
                    editMotion = true;
                } else if (flyKeyDown) {
                    potentialY = currentSpeedVertical;
                    editMotion = true;
                    if (descendKeyDown) {
                        potentialY -= currentSpeedVertical;
                    }
                } else {
                    potentialY = -hoverSpeed;
                }
                potentialY = Math.min(deltaY + currentAccel, potentialY);
                if (editMotion) {
                    IJetpack.setYMotion(player, potentialY);
                }
                float speedSideways = (float)(player.m_6144_() ? this.getSidewaysSpeed() * 0.5 : this.getSidewaysSpeed());
                float speedForward = (float)(player.m_20142_() ? (double)speedSideways * this.getSprintSpeedModifier() : (double)speedSideways);
                if (!player.m_21255_()) {
                    if (KeyBind.VANILLA_FORWARD.isKeyDown(player)) {
                        player.m_19920_(speedForward, new Vec3(0.0, 0.0, (double)speedForward));
                    }
                    if (KeyBind.VANILLA_BACKWARD.isKeyDown(player)) {
                        player.m_19920_(speedSideways * 0.8f, new Vec3(0.0, 0.0, (double)(-speedForward)));
                    }
                    if (KeyBind.VANILLA_LEFT.isKeyDown(player)) {
                        player.m_19920_(speedSideways, new Vec3((double)speedSideways, 0.0, 0.0));
                    }
                    if (KeyBind.VANILLA_RIGHT.isKeyDown(player)) {
                        player.m_19920_(-speedSideways, new Vec3((double)speedSideways, 0.0, 0.0));
                    }
                }
                if (!player.m_9236_().f_46443_ && (hover || flyKeyDown)) {
                    player.f_19789_ = 0.0f;
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.f_8906_.f_9737_ = 0;
                    }
                }
            }
            ArmorUtils.spawnParticle(player.m_9236_(), player, this.getParticle(), -0.6);
        }
    }

    private static void setYMotion(Player player, double value) {
        Vec3 motion = player.m_20184_();
        player.m_20334_(motion.m_7096_(), value, motion.m_7094_());
    }

    private static void performEHover(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("enabled")) {
            tag.m_128379_("enabled", true);
        }
        if (tag.m_128441_("hover")) {
            tag.m_128379_("hover", true);
        }
        player.m_5661_((Component)Component.m_237115_((String)"metaarmor.jetpack.emergency_hover_mode"), true);
        stack.m_41751_(tag);
        if (!player.m_9236_().f_46443_) {
            player.f_19789_ = 0.0f;
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).f_8906_.f_9737_ = 0;
            }
        }
        player.f_36095_.m_150429_();
    }

    private static void addYMotion(Player player, double value) {
        Vec3 motion = player.m_20184_();
        player.m_246865_(new Vec3(motion.m_7096_(), value, motion.m_7094_()));
    }
}

