/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorLogicSuite;
import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.common.item.armor.IJetpack;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import com.lowdragmc.lowdraglib.Platform;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jetpack
extends ArmorLogicSuite
implements IJetpack {
    @OnlyIn(value=Dist.CLIENT)
    protected ArmorUtils.ModularHUD HUD;

    public Jetpack(int energyPerUse, long capacity, int tier) {
        super(energyPerUse, capacity, tier, ArmorItem.Type.CHESTPLATE);
        if (Platform.isClient() && this.shouldDrawHUD()) {
            this.HUD = new ArmorUtils.ModularHUD();
        }
    }

    @Override
    public void onArmorTick(Level world, Player player, @NotNull ItemStack stack) {
        boolean jetpackEnabled;
        CompoundTag data = stack.m_41784_();
        boolean hoverMode = data.m_128441_("hover") && data.m_128471_("hover");
        byte toggleTimer = data.m_128441_("toggleTimer") ? data.m_128445_("toggleTimer") : (byte)0;
        boolean bl = jetpackEnabled = !data.m_128441_("enabled") || data.m_128471_("enabled");
        if (toggleTimer == 0 && KeyBind.ARMOR_HOVER.isKeyDown(player)) {
            hoverMode = !hoverMode;
            toggleTimer = 5;
            data.m_128379_("hover", hoverMode);
            if (!world.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)("metaarmor.jetpack.hover." + (hoverMode ? "enable" : "disable"))), true);
            }
        }
        if (toggleTimer == 0 && KeyBind.JETPACK_ENABLE.isKeyDown(player)) {
            jetpackEnabled = !jetpackEnabled;
            toggleTimer = 5;
            data.m_128379_("enabled", jetpackEnabled);
            if (!world.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)("metaarmor.jetpack.flight." + (jetpackEnabled ? "enable" : "disable"))), true);
            }
        }
        this.performFlying(player, jetpackEnabled, hoverMode, stack);
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.m_128379_("hover", hoverMode);
        data.m_128379_("enabled", jetpackEnabled);
        data.m_128344_("toggleTimer", toggleTimer);
    }

    @Override
    public boolean canUseEnergy(@NotNull ItemStack stack, int amount) {
        IElectricItem container = Jetpack.getIElectricItem(stack);
        if (container == null) {
            return false;
        }
        return container.canUse(amount);
    }

    @Override
    public void drainEnergy(@NotNull ItemStack stack, int amount) {
        IElectricItem container = Jetpack.getIElectricItem(stack);
        if (container == null) {
            return;
        }
        container.discharge(amount, this.tier, true, false, false);
    }

    @Override
    public boolean hasEnergy(@NotNull ItemStack stack) {
        IElectricItem container = Jetpack.getIElectricItem(stack);
        if (container == null) {
            return false;
        }
        return container.getCharge() > 0L;
    }

    @Nullable
    private static IElectricItem getIElectricItem(@NotNull ItemStack stack) {
        return GTCapabilityHelper.getElectricItem(stack);
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return GTCEu.id("textures/armor/jetpack.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(ItemStack item, GuiGraphics guiGraphics) {
        Jetpack.addCapacityHUD(item, this.HUD);
        CompoundTag data = item.m_41783_();
        if (data != null) {
            MutableComponent result;
            MutableComponent status;
            if (data.m_128441_("enabled")) {
                status = data.m_128471_("enabled") ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
                result = Component.m_237110_((String)"metaarmor.hud.engine_enabled", (Object[])new Object[]{status});
                this.HUD.newString((Component)result);
            }
            if (data.m_128441_("hover")) {
                status = data.m_128471_("hover") ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
                result = Component.m_237110_((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{status});
                this.HUD.newString((Component)result);
            }
        }
        this.HUD.draw(guiGraphics);
        this.HUD.reset();
    }

    @Override
    public void addInfo(ItemStack itemStack, List<Component> lines) {
        super.addInfo(itemStack, lines);
        CompoundTag data = itemStack.m_41784_();
        boolean enabled = !data.m_128441_("enabled") || data.m_128471_("enabled");
        MutableComponent state = enabled ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
        lines.add((Component)Component.m_237110_((String)"metaarmor.hud.engine_enabled", (Object[])new Object[]{state}));
        boolean hover = data.m_128441_("hover") && data.m_128471_("hover");
        state = hover ? Component.m_237115_((String)"metaarmor.hud.status.enabled") : Component.m_237115_((String)"metaarmor.hud.status.disabled");
        lines.add((Component)Component.m_237110_((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{state}));
    }

    @Override
    public double getVerticalHoverSlowSpeed() {
        return 0.1;
    }

    @Override
    public double getVerticalAcceleration() {
        return 0.12;
    }

    @Override
    public double getVerticalSpeed() {
        return 0.3;
    }

    @Override
    public double getSidewaysSpeed() {
        return 0.08;
    }

    @Override
    public ParticleOptions getParticle() {
        return ParticleTypes.f_123762_;
    }
}

