/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorLogicSuite;
import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.item.armor.IStepAssist;
import com.gregtechceu.gtceu.core.IFireImmuneEntity;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import com.lowdragmc.lowdraglib.Platform;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class QuarkTechSuite
extends ArmorLogicSuite
implements IStepAssist {
    protected static final Map<MobEffect, Integer> potionRemovalCost = new IdentityHashMap<MobEffect, Integer>();
    private float charge = 0.0f;
    private static final byte RUNNING_TIMER = 10;
    private static final byte JUMPING_TIMER = 10;
    private static final double LEGGING_ACCEL = 0.085;
    @OnlyIn(value=Dist.CLIENT)
    protected ArmorUtils.ModularHUD HUD;

    public QuarkTechSuite(ArmorItem.Type slot, int energyPerUse, long capacity, int tier) {
        super(energyPerUse, capacity, tier, slot);
        potionRemovalCost.put(MobEffects.f_19614_, 10000);
        potionRemovalCost.put(MobEffects.f_19615_, 25000);
        potionRemovalCost.put(MobEffects.f_19604_, 8000);
        potionRemovalCost.put(MobEffects.f_19599_, 12500);
        potionRemovalCost.put(MobEffects.f_19597_, 9000);
        potionRemovalCost.put(MobEffects.f_19590_, 5000);
        if (Platform.isClient() && this.shouldDrawHUD()) {
            this.HUD = new ArmorUtils.ModularHUD();
        }
    }

    @Override
    public void onArmorTick(Level world, Player player, ItemStack itemStack) {
        int boostedJumpTimer;
        IElectricItem item = GTCapabilityHelper.getElectricItem(itemStack);
        if (item == null) {
            return;
        }
        CompoundTag data = itemStack.m_41784_();
        byte toggleTimer = data.m_128441_("toggleTimer") ? data.m_128445_("toggleTimer") : (byte)0;
        int nightVisionTimer = data.m_128441_("nightVisionTimer") ? data.m_128451_("nightVisionTimer") : 400;
        byte runningTimer = data.m_128441_("runningTimer") ? (byte)data.m_128445_("runningTimer") : (byte)10;
        int n = boostedJumpTimer = data.m_128441_("boostedJumpTimer") ? (int)data.m_128445_("boostedJumpTimer") : 10;
        if (!(player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)GTItems.QUANTUM_CHESTPLATE.get()) || player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)GTItems.QUANTUM_CHESTPLATE_ADVANCED.get()) || world.f_46443_)) {
            ((IFireImmuneEntity)player).gtceu$setFireImmune(false);
        }
        boolean ret = false;
        if (this.type == ArmorItem.Type.HELMET) {
            boolean nightVision;
            ret = this.supplyAir(item, player) || this.supplyFood(item, player);
            this.removeNegativeEffects(item, player);
            boolean bl = nightVision = data.m_128441_("nightVision") && data.m_128471_("nightVision");
            if (toggleTimer == 0 && KeyBind.ARMOR_MODE_SWITCH.isKeyDown(player)) {
                nightVision = !nightVision;
                toggleTimer = 5;
                if (item.getCharge() < 4L) {
                    nightVision = false;
                    player.m_5661_((Component)Component.m_237115_((String)"metaarmor.nms.nightvision.error"), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)("metaarmor.nms.nightvision." + (nightVision ? "enabled" : "disabled"))), true);
                }
            }
            if (nightVision) {
                player.m_21195_(MobEffects.f_19610_);
                if (nightVisionTimer <= 220) {
                    nightVisionTimer = 400;
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 400, 0, true, false));
                    item.discharge(4L, this.tier, true, false, false);
                }
            } else {
                player.m_21195_(MobEffects.f_19611_);
            }
            data.m_128379_("nightVision", nightVision);
            if (nightVisionTimer > 0) {
                --nightVisionTimer;
            }
            if (toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
            }
            data.m_128405_("nightVisionTimer", nightVisionTimer);
            data.m_128344_("toggleTimer", toggleTimer);
        } else if (this.type == ArmorItem.Type.CHESTPLATE && !player.m_5825_()) {
            ((IFireImmuneEntity)player).gtceu$setFireImmune(true);
            if (player.m_6060_()) {
                player.m_252836_();
            }
        } else if (this.type == ArmorItem.Type.LEGGINGS) {
            boolean canUseEnergy = item.canUse(this.energyPerUse / 100);
            boolean sprinting = KeyBind.VANILLA_FORWARD.isKeyDown(player) && player.m_20142_();
            boolean jumping = KeyBind.VANILLA_JUMP.isKeyDown(player);
            boolean sneaking = KeyBind.VANILLA_SNEAK.isKeyDown(player);
            if (canUseEnergy && sprinting && runningTimer == 0) {
                runningTimer = 10;
                item.discharge(this.energyPerUse / 100, item.getTier(), true, false, false);
            }
            if (canUseEnergy && (player.m_20096_() || player.m_20069_()) && sprinting) {
                float speed = 0.25f;
                if (player.m_20069_()) {
                    speed = 0.1f;
                    if (jumping) {
                        player.m_5997_(0.0, 0.1, 0.0);
                        player.f_19864_ = true;
                    }
                }
                player.m_19920_(speed, new Vec3(0.0, 0.0, 1.0));
            } else if (canUseEnergy && player.m_20069_() && (sneaking || jumping)) {
                if (sneaking) {
                    player.m_5997_(0.0, -0.085, 0.0);
                }
                if (jumping) {
                    player.m_5997_(0.0, 0.085, 0.0);
                }
            }
            if (runningTimer > 0) {
                runningTimer = (byte)(runningTimer - 1);
            }
            data.m_128344_("runningTimer", runningTimer);
        } else if (this.type == ArmorItem.Type.BOOTS) {
            boolean boostedJump;
            boolean canUseEnergy = item.canUse(this.energyPerUse / 100);
            boolean jumping = KeyBind.VANILLA_JUMP.isKeyDown(player);
            boolean bl = boostedJump = data.m_128441_("boostedJump") && data.m_128471_("boostedJump");
            if (boostedJumpTimer == 0 && KeyBind.BOOTS_ENABLE.isKeyDown(player)) {
                boostedJump = !boostedJump;
                boostedJumpTimer = 10;
                player.m_5661_((Component)Component.m_237115_((String)("metaarmor.nms.boosted_jump." + (boostedJump ? "enabled" : "disabled"))), true);
            }
            if (boostedJump) {
                if (!world.f_46443_) {
                    boolean onGround;
                    boolean bl2 = onGround = !data.m_128441_("onGround") || data.m_128471_("onGround");
                    if (onGround && !player.m_20096_() && jumping) {
                        item.discharge(this.energyPerUse / 100, item.getTier(), true, false, false);
                        ret = true;
                    }
                    if (player.m_20096_() != onGround) {
                        data.m_128379_("onGround", player.m_20096_());
                    }
                } else {
                    if (canUseEnergy && player.m_20096_()) {
                        this.charge = 1.0f;
                    }
                    Vec3 delta = player.m_20184_();
                    if (delta.f_82480_ >= 0.0 && this.charge > 0.0f && !player.m_20069_()) {
                        if (jumping) {
                            if (this.charge == 1.0f) {
                                player.m_20334_(delta.f_82479_ * 3.6, delta.f_82480_, delta.f_82481_ * 3.6);
                            }
                            player.m_246865_(new Vec3(0.0, (double)this.charge * 0.32, 0.0));
                            this.charge = (float)((double)this.charge * 0.7);
                        } else if (this.charge < 1.0f) {
                            this.charge = 0.0f;
                        }
                    }
                }
            }
            this.updateStepHeight(player);
            data.m_128379_("boostedJump", boostedJump);
            if (boostedJumpTimer > 0) {
                boostedJumpTimer = (byte)(boostedJumpTimer - 1);
            }
            data.m_128405_("boostedJumpTimer", boostedJumpTimer);
        }
        if (ret) {
            player.f_36095_.m_150429_();
        }
    }

    public boolean supplyAir(@NotNull IElectricItem item, Player player) {
        int air = player.m_20146_();
        if (item.canUse(this.energyPerUse / 100) && air < 100) {
            player.m_20301_(air + 200);
            item.discharge(this.energyPerUse / 100, item.getTier(), true, false, false);
            return true;
        }
        return false;
    }

    public boolean supplyFood(@NotNull IElectricItem item, Player player) {
        if (item.canUse(this.energyPerUse / 10) && player.m_36324_().m_38721_()) {
            int slotId = -1;
            IItemHandler playerInv = player.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElse(null);
            if (playerInv instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable items = (IItemHandlerModifiable)playerInv;
                for (int i = 0; i < items.getSlots(); ++i) {
                    ItemStack current = items.getStackInSlot(i);
                    if (current.getFoodProperties((LivingEntity)player) == null) continue;
                    slotId = i;
                    break;
                }
                if (slotId > -1) {
                    ItemStack stack = items.getStackInSlot(slotId);
                    InteractionResultHolder<ItemStack> result = ArmorUtils.eat(player, stack);
                    if ((stack = (ItemStack)result.m_19095_()).m_41619_()) {
                        items.setStackInSlot(slotId, ItemStack.f_41583_);
                    }
                    if (result.m_19089_() == InteractionResult.SUCCESS) {
                        item.discharge(this.energyPerUse / 10, item.getTier(), true, false, false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void removeNegativeEffects(@NotNull IElectricItem item, Player player) {
        for (MobEffectInstance effect : new LinkedList(player.m_21220_())) {
            MobEffect potion = effect.m_19544_();
            Integer cost = potionRemovalCost.get(potion);
            if (cost == null || !item.canUse((cost = Integer.valueOf(cost * (effect.m_19564_() + 1))).intValue())) continue;
            item.discharge(cost.intValue(), item.getTier(), true, false, false);
            player.m_21195_(potion);
        }
    }

    @Override
    public void damageArmor(LivingEntity entity, ItemStack itemStack, DamageSource source, int damage, EquipmentSlot equipmentSlot) {
        IElectricItem item = GTCapabilityHelper.getElectricItem(itemStack);
        if (item == null) {
            return;
        }
        item.discharge((long)this.energyPerUse / 100L * (long)damage, item.getTier(), true, false, false);
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ItemStack currentChest = (ItemStack)Minecraft.m_91087_().f_91074_.m_150109_().f_35975_.get(EquipmentSlot.CHEST.m_20749_());
        String armorTexture = "quark_tech_suite";
        if (currentChest.m_150930_((Item)GTItems.QUANTUM_CHESTPLATE_ADVANCED.get())) {
            armorTexture = "advanced_quark_tech_suite";
        }
        return slot != EquipmentSlot.LEGS ? GTCEu.id(String.format("textures/armor/%s_1.png", armorTexture)) : GTCEu.id(String.format("textures/armor/%s_2.png", armorTexture));
    }

    @Override
    public double getDamageAbsorption() {
        return this.type == ArmorItem.Type.CHESTPLATE ? 1.2 : 1.0;
    }

    @Override
    public float getHeatResistance() {
        return 0.5f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(ItemStack item, GuiGraphics guiGraphics) {
        QuarkTechSuite.addCapacityHUD(item, this.HUD);
        this.HUD.draw(guiGraphics);
        this.HUD.reset();
    }

    @Override
    public void addInfo(ItemStack itemStack, List<Component> lines) {
        super.addInfo(itemStack, lines);
        if (this.type == ArmorItem.Type.HELMET) {
            CompoundTag nbtData = itemStack.m_41784_();
            boolean nv = nbtData.m_128471_("nightVision");
            if (nv) {
                lines.add((Component)Component.m_237115_((String)"metaarmor.message.nightvision.enabled"));
            } else {
                lines.add((Component)Component.m_237115_((String)"metaarmor.message.nightvision.disabled"));
            }
            lines.add((Component)Component.m_237115_((String)"metaarmor.tooltip.potions"));
            lines.add((Component)Component.m_237115_((String)"metaarmor.tooltip.breath"));
            lines.add((Component)Component.m_237115_((String)"metaarmor.tooltip.autoeat"));
        } else if (this.type == ArmorItem.Type.CHESTPLATE) {
            lines.add((Component)Component.m_237115_((String)"metaarmor.tooltip.burning"));
        } else if (this.type == ArmorItem.Type.LEGGINGS) {
            lines.add((Component)Component.m_237115_((String)"metaarmor.tooltip.speed"));
        } else if (this.type == ArmorItem.Type.BOOTS) {
            lines.add((Component)Component.m_237115_((String)"metaarmor.tooltip.stepassist"));
            lines.add((Component)Component.m_237115_((String)"metaarmor.tooltip.falldamage"));
            lines.add((Component)Component.m_237115_((String)"metaarmor.tooltip.jump"));
        }
    }

    @Override
    public boolean isPPE() {
        return true;
    }
}

