/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.google.common.collect.ImmutableSet;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HarvestCropsBehavior
implements IToolBehavior {
    public static final HarvestCropsBehavior INSTANCE = new HarvestCropsBehavior();

    protected HarvestCropsBehavior() {
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        Object blocks;
        if (context.m_43725_().f_46443_) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        InteractionHand hand = context.m_43724_();
        ItemStack stack = player.m_21120_(hand);
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (aoeDefinition == AoESymmetrical.none()) {
            blocks = ImmutableSet.of((Object)pos);
        } else {
            HitResult rayTraceResult = ToolHelper.getPlayerDefaultRaytrace(player);
            if (rayTraceResult == null) {
                return InteractionResult.PASS;
            }
            if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
                return InteractionResult.PASS;
            }
            if (!(rayTraceResult instanceof BlockHitResult)) {
                return InteractionResult.PASS;
            }
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            if (blockHitResult.m_82434_() == null) {
                return InteractionResult.PASS;
            }
            blocks = ToolHelper.iterateAoE(stack, aoeDefinition, player.m_9236_(), player, rayTraceResult, HarvestCropsBehavior::isBlockCrops);
            if (HarvestCropsBehavior.isBlockCrops(stack, context.m_43725_(), player, blockHitResult.m_82425_(), context)) {
                blocks.add(blockHitResult.m_82425_());
            }
        }
        boolean harvested = false;
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = (BlockPos)iterator.next();
            if (!HarvestCropsBehavior.harvestBlockRoutine(stack, blockPos, player)) continue;
            harvested = true;
        }
        return harvested ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    private static boolean isBlockCrops(ItemStack stack, Level world, Player player, BlockPos pos, @Nullable UseOnContext context) {
        if (world.m_8055_(pos.m_7494_()).m_60795_()) {
            Block block = world.m_8055_(pos).m_60734_();
            return block instanceof CropBlock;
        }
        return false;
    }

    private static boolean harvestBlockRoutine(ItemStack stack, BlockPos pos, Player player) {
        BlockState blockState = player.m_9236_().m_8055_(pos);
        Block block = blockState.m_60734_();
        CropBlock blockCrops = (CropBlock)block;
        if (blockCrops.m_52307_(blockState)) {
            NonNullList drops = NonNullList.m_122779_();
            drops.addAll((Collection)Block.m_49869_((BlockState)blockState, (ServerLevel)((ServerLevel)player.m_9236_()), (BlockPos)pos, null));
            HarvestCropsBehavior.dropListOfItems(player.m_9236_(), pos, (List<ItemStack>)drops);
            player.m_9236_().m_46796_(2001, pos, Block.m_49956_((BlockState)blockState));
            player.m_9236_().m_7731_(pos, blockCrops.m_52289_(0), 3);
            if (!player.m_7500_()) {
                ToolHelper.damageItem(stack, (LivingEntity)player);
            }
            return true;
        }
        return false;
    }

    private static void dropListOfItems(Level world, BlockPos pos, List<ItemStack> drops) {
        for (ItemStack stack : drops) {
            float f = 0.7f;
            double offX = (double)(GTValues.RNG.m_188501_() * f) + (double)(1.0f - f) * 0.5;
            double offY = (double)(GTValues.RNG.m_188501_() * f) + (double)(1.0f - f) * 0.5;
            double offZ = (double)(GTValues.RNG.m_188501_() * f) + (double)(1.0f - f) * 0.5;
            ItemEntity entityItem = new ItemEntity(world, (double)pos.m_123341_() + offX, (double)pos.m_123342_() + offY, (double)pos.m_123343_() + offZ, stack);
            entityItem.m_32060_();
            world.m_7967_((Entity)entityItem);
        }
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.crop_harvesting"));
    }
}

