/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.common.block.explosive.GTExplosiveBlock;
import com.gregtechceu.gtceu.utils.GradientUtil;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LighterBehavior
implements IDurabilityBar,
IInteractionItem,
IAddInformation {
    public static final String LIGHTER_OPEN = "lighterOpen";
    private static final String USES_LEFT = "usesLeft";
    private static final Pair<Integer, Integer> DURABILITY_BAR_COLORS = GradientUtil.getGradient(15761181, 10);
    private final ResourceLocation overrideLocation;
    private final boolean usesFluid;
    private final boolean hasMultipleUses;
    private final boolean canOpen;
    private Item destroyItem = Items.f_41852_;
    private int maxUses = 0;

    public LighterBehavior(boolean useFluid, boolean hasMultipleUses, boolean canOpen) {
        this(null, useFluid, hasMultipleUses, canOpen);
    }

    public LighterBehavior(boolean useFluid, boolean hasMultipleUses, boolean canOpen, Item destroyItem, int maxUses) {
        this(null, useFluid, hasMultipleUses, canOpen);
        this.maxUses = maxUses;
        this.destroyItem = destroyItem;
    }

    public LighterBehavior(@javax.annotation.Nullable ResourceLocation overrideLocation, boolean useFluid, boolean hasMultipleUses, boolean canOpen) {
        this.overrideLocation = overrideLocation;
        this.usesFluid = useFluid;
        this.hasMultipleUses = hasMultipleUses;
        this.canOpen = canOpen;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        CompoundTag tag = itemStack.m_41784_();
        if (this.canOpen && player.m_6047_()) {
            tag.m_128379_(LIGHTER_OPEN, !tag.m_128471_(LIGHTER_OPEN));
            itemStack.m_41751_(tag);
        }
        return IInteractionItem.super.use(item, level, player, usedHand);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        CompoundTag tag = itemStack.m_41784_();
        Player player = context.m_43723_();
        if ((!this.canOpen || tag.m_128471_(LIGHTER_OPEN) && !player.m_6047_()) && this.consumeFuel(player, itemStack)) {
            player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, GTValues.RNG.m_188501_() * 0.4f + 0.8f);
            BlockState state = context.m_43725_().m_8055_(context.m_8083_());
            Block block = state.m_60734_();
            if (block instanceof TntBlock) {
                TntBlock tnt = (TntBlock)block;
                tnt.onCaughtFire(null, context.m_43725_(), context.m_8083_(), null, (LivingEntity)player);
                context.m_43725_().m_7731_(context.m_8083_(), Blocks.f_50016_.m_49966_(), 11);
                return InteractionResult.SUCCESS;
            }
            if (block instanceof GTExplosiveBlock) {
                GTExplosiveBlock explosive = (GTExplosiveBlock)block;
                explosive.explode(context.m_43725_(), context.m_8083_(), (LivingEntity)player);
                context.m_43725_().m_7731_(context.m_8083_(), Blocks.f_50016_.m_49966_(), 11);
                return InteractionResult.SUCCESS;
            }
            BlockPos offset = context.m_8083_().m_121955_(context.m_43719_().m_122436_());
            if (context.m_43725_().m_46859_(offset)) {
                context.m_43725_().m_7731_(offset, Blocks.f_50083_.m_49966_(), 11);
                if (!context.m_43725_().f_46443_) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, offset, itemStack);
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    public boolean consumeFuel(Player player, ItemStack stack) {
        if (player != null && player.m_7500_()) {
            return true;
        }
        int usesLeft = this.getUsesLeft(stack);
        if (usesLeft - 1 >= 0) {
            this.setUsesLeft(player, stack, usesLeft - 1);
            return true;
        }
        return false;
    }

    private int getUsesLeft(ItemStack stack) {
        if (this.usesFluid) {
            IFluidHandlerItem fluidHandlerItem = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).resolve().orElse(null);
            if (fluidHandlerItem == null) {
                return 0;
            }
            FluidStack fluid = fluidHandlerItem.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            return fluid.isEmpty() ? 0 : fluid.getAmount();
        }
        if (this.hasMultipleUses) {
            CompoundTag compound = stack.m_41784_();
            if (compound.m_128441_(USES_LEFT)) {
                return compound.m_128451_(USES_LEFT);
            }
            compound.m_128405_(USES_LEFT, this.maxUses);
            stack.m_41751_(compound);
            return compound.m_128451_(USES_LEFT);
        }
        return stack.m_41613_();
    }

    private void setUsesLeft(Player player, @NotNull ItemStack stack, int usesLeft) {
        if (this.usesFluid) {
            FluidStack fluid;
            IFluidHandlerItem fluidHandlerItem = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).resolve().orElse(null);
            if (fluidHandlerItem != null && !(fluid = fluidHandlerItem.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
                fluidHandlerItem.drain(fluid.getAmount() - usesLeft, IFluidHandler.FluidAction.EXECUTE);
            }
        } else if (this.hasMultipleUses) {
            if (usesLeft == 0) {
                stack.m_41764_(0);
                player.m_36356_(new ItemStack((ItemLike)this.destroyItem));
            } else {
                stack.m_41784_().m_128405_(USES_LEFT, usesLeft);
            }
        } else {
            stack.m_41764_(usesLeft);
        }
    }

    @Override
    public float getDurabilityForDisplay(ItemStack stack) {
        if (this.usesFluid) {
            IFluidHandlerItem fluidHandlerItem = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).resolve().orElse(null);
            if (fluidHandlerItem == null) {
                return 0.0f;
            }
            FluidStack fluid = fluidHandlerItem.getFluidInTank(0);
            return fluid.isEmpty() ? 0.0f : (float)fluid.getAmount() / (float)fluidHandlerItem.getTankCapacity(0);
        }
        if (this.hasMultipleUses) {
            return (float)this.getUsesLeft(stack) / (float)this.maxUses;
        }
        return 0.0f;
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return this.usesFluid || this.hasMultipleUses;
    }

    @Override
    public boolean showEmptyBar(ItemStack itemStack) {
        return this.usesFluid || this.hasMultipleUses;
    }

    @Override
    @javax.annotation.Nullable
    public Pair<Integer, Integer> getDurabilityColorsForDisplay(ItemStack itemStack) {
        if (this.hasMultipleUses && this.usesFluid) {
            return DURABILITY_BAR_COLORS;
        }
        return null;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)(this.usesFluid ? "behaviour.lighter.fluid.tooltip" : "behaviour.lighter.tooltip")));
        if (this.hasMultipleUses && !this.usesFluid) {
            tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.lighter.uses", (Object[])new Object[]{this.getUsesLeft(stack)}));
        }
    }
}

