/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.forge.IComponentCapability;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.misc.forge.VoidFluidHandlerItemStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlungerBehavior
implements IToolBehavior,
IComponentCapability,
IInteractionItem {
    public static final PlungerBehavior INSTANCE = PlungerBehavior.create();

    protected PlungerBehavior() {
    }

    protected static PlungerBehavior create() {
        return new PlungerBehavior();
    }

    @Override
    public boolean shouldOpenUIAfterUse(UseOnContext context) {
        return context.m_43723_() == null || !context.m_43723_().m_6144_();
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        IFluidTransfer fluidHandler;
        if (context.m_43723_() == null || !context.m_43723_().m_6144_()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity instanceof IMachineBlockEntity) {
            IMachineBlockEntity metaMachineBlockEntity = (IMachineBlockEntity)blockEntity;
            fluidHandler = metaMachineBlockEntity.getMetaMachine().getFluidTransferCap(context.m_43719_(), false);
        } else {
            fluidHandler = FluidTransferHelper.getFluidTransfer((Level)context.m_43725_(), (BlockPos)context.m_8083_(), (Direction)context.m_43719_());
        }
        if (fluidHandler == null) {
            return InteractionResult.PASS;
        }
        FluidStack drained = fluidHandler.drain(FluidHelper.getBucket(), true);
        if (drained != null && !drained.isEmpty()) {
            fluidHandler.drain(FluidHelper.getBucket(), false);
            ToolHelper.onActionDone(context.m_43723_(), context.m_43725_(), context.m_43724_());
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.plunger"));
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(ItemStack itemStack, @NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.FLUID_HANDLER_ITEM) {
            return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, LazyOptional.of(() -> new VoidFluidHandlerItemStack(itemStack){

                @Override
                public int fill(net.minecraftforge.fluids.FluidStack resource, IFluidHandler.FluidAction doFill) {
                    int result = super.fill(resource, doFill);
                    if (result > 0) {
                        ToolHelper.damageItem(this.getContainer(), null);
                    }
                    return result;
                }
            }));
        }
        return LazyOptional.empty();
    }
}

