/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.editor.EditableUI;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChargerMachine
extends TieredEnergyMachine
implements IControllable,
IFancyUIMachine,
IMachineModifyDrops {
    public static final long AMPS_PER_ITEM = 4L;
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ChargerMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private boolean isWorkingEnabled = true;
    private final int inventorySize;
    @Persisted
    protected final ItemStackTransfer chargerInventory;
    @DescSynced
    @RequireRerender
    private State state;

    public ChargerMachine(IMachineBlockEntity holder, int tier, int inventorySize, Object ... args) {
        super(holder, tier, inventorySize);
        this.inventorySize = inventorySize;
        this.chargerInventory = this.createChargerInventory(args);
        this.state = State.IDLE;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        return new EnergyBatteryTrait((Integer)args[0]);
    }

    protected ItemStackTransfer createChargerInventory(Object ... args) {
        ItemStackTransfer itemTransfer = new ItemStackTransfer(this.inventorySize);
        itemTransfer.setFilter(item -> GTCapabilityHelper.getElectricItem(item) != null || ConfigHolder.INSTANCE.compat.energy.nativeEUToPlatformNative && GTCapabilityHelper.getForgeEnergyItem(item) != null);
        return itemTransfer;
    }

    @Override
    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    @Override
    public void onDrops(List<ItemStack> drops, Player entity) {
        ChargerMachine.clearInventory(drops, (IItemTransfer)this.chargerInventory);
    }

    @Override
    public Widget createUIWidget() {
        int rowSize;
        int colSize = rowSize = (int)Math.sqrt(this.inventorySize);
        if (this.inventorySize == 8) {
            rowSize = 4;
            colSize = 2;
        }
        WidgetGroup template = new WidgetGroup(0, 0, 18 * rowSize + 8, 18 * colSize + 8);
        template.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        int index = 0;
        for (int y = 0; y < colSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                template.addWidget((Widget)new SlotWidget((IItemTransfer)this.chargerInventory, index++, 4 + x * 18, 4 + y * 18, true, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY})));
            }
        }
        EditableUI<ProgressWidget, TieredEnergyMachine> editableUI = ChargerMachine.createEnergyBar();
        ProgressWidget energyBar = editableUI.createDefault();
        WidgetGroup group = new WidgetGroup(0, 0, Math.max(energyBar.getSize().width + template.getSize().width + 4 + 8, 172), Math.max(template.getSize().height + 8, energyBar.getSize().height + 8));
        Size size = group.getSize();
        energyBar.setSelfPosition(new Position(3, (size.height - energyBar.getSize().height) / 2));
        template.setSelfPosition(new Position((size.width - energyBar.getSize().width - 4 - template.getSize().width) / 2 + 2 + energyBar.getSize().width + 2, (size.height - template.getSize().height) / 2));
        group.addWidget((Widget)energyBar);
        group.addWidget((Widget)template);
        editableUI.setupUI(group, this);
        return group;
    }

    private List<Object> getNonFullElectricItem() {
        ArrayList<Object> electricItems = new ArrayList<Object>();
        for (int i = 0; i < this.chargerInventory.getSlots(); ++i) {
            IEnergyStorage energyStorage;
            ItemStack electricItemStack = this.chargerInventory.getStackInSlot(i);
            IElectricItem electricItem = GTCapabilityHelper.getElectricItem(electricItemStack);
            if (electricItem != null) {
                if (electricItem.getCharge() >= electricItem.getMaxCharge()) continue;
                electricItems.add(electricItem);
                continue;
            }
            if (!ConfigHolder.INSTANCE.compat.energy.nativeEUToPlatformNative || (energyStorage = GTCapabilityHelper.getForgeEnergyItem(electricItemStack)) == null || energyStorage.getEnergyStored() >= energyStorage.getMaxEnergyStored()) continue;
            electricItems.add(energyStorage);
        }
        return electricItems;
    }

    private void changeState(State newState) {
        if (this.state != newState) {
            this.state = newState;
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingEnabled) {
        this.isWorkingEnabled = isWorkingEnabled;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    public ItemStackTransfer getChargerInventory() {
        return this.chargerInventory;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        IDLE,
        RUNNING,
        FINISHED;

    }

    protected class EnergyBatteryTrait
    extends NotifiableEnergyContainer {
        protected EnergyBatteryTrait(int inventorySize) {
            super(ChargerMachine.this, GTValues.V[ChargerMachine.this.tier] * (long)inventorySize * 32L, GTValues.V[ChargerMachine.this.tier], (long)inventorySize * 4L, 0L, 0L);
            this.setSideInputCondition(side -> ChargerMachine.this.isWorkingEnabled());
            this.setSideOutputCondition(side -> false);
        }

        @Override
        public long acceptEnergyFromNetwork(@Nullable Direction side, long voltage, long amperage) {
            long latestTimeStamp = this.getMachine().getOffsetTimer();
            if (this.lastTimeStamp < latestTimeStamp) {
                this.amps = 0L;
                this.lastTimeStamp = latestTimeStamp;
            }
            if (amperage <= 0L || voltage <= 0L) {
                ChargerMachine.this.changeState(State.IDLE);
                return 0L;
            }
            List<Object> electricItems = ChargerMachine.this.getNonFullElectricItem();
            long maxAmps = (long)electricItems.size() * 4L - this.amps;
            long usedAmps = Math.min(maxAmps, amperage);
            if (maxAmps <= 0L) {
                return 0L;
            }
            if (side == null || this.inputsEnergy(side)) {
                if (voltage > this.getInputVoltage()) {
                    ChargerMachine.this.doExplosion(GTUtil.getExplosionPower(voltage));
                    return usedAmps;
                }
                long internalAmps = Math.min(maxAmps, Math.max(0L, this.getInternalStorage() / voltage));
                usedAmps = Math.min(usedAmps, maxAmps - internalAmps);
                this.amps += usedAmps;
                long energy = (usedAmps + internalAmps) * voltage;
                long distributed = energy / (long)electricItems.size();
                boolean changed = false;
                long charged = 0L;
                for (Object electricItem : electricItems) {
                    if (electricItem instanceof IElectricItem) {
                        IElectricItem item = (IElectricItem)electricItem;
                        charged += item.charge(Math.min(distributed, GTValues.V[item.getTier()] * 4L), ChargerMachine.this.getTier(), true, false);
                    } else if (electricItem instanceof IEnergyStorage) {
                        IEnergyStorage energyStorage = (IEnergyStorage)electricItem;
                        energy += FeCompat.insertEu(energyStorage, Math.min(distributed, GTValues.V[ChargerMachine.this.getTier()] * 4L), false);
                    }
                    if (charged > 0L) {
                        changed = true;
                    }
                    energy -= charged;
                }
                if (changed) {
                    ChargerMachine.this.markDirty();
                    ChargerMachine.this.changeState(State.RUNNING);
                }
                this.setEnergyStored(this.getInternalStorage() - internalAmps * voltage + energy);
                return usedAmps;
            }
            return 0L;
        }

        @Override
        public long getEnergyCapacity() {
            long energyCapacity = 0L;
            for (int i = 0; i < ChargerMachine.this.chargerInventory.getSlots(); ++i) {
                IEnergyStorage energyStorage;
                ItemStack electricItemStack = ChargerMachine.this.chargerInventory.getStackInSlot(i);
                IElectricItem electricItem = GTCapabilityHelper.getElectricItem(electricItemStack);
                if (electricItem != null) {
                    energyCapacity += electricItem.getMaxCharge();
                    continue;
                }
                if (!ConfigHolder.INSTANCE.compat.energy.nativeEUToPlatformNative || (energyStorage = GTCapabilityHelper.getForgeEnergyItem(electricItemStack)) == null) continue;
                energyCapacity += FeCompat.toEu(energyStorage.getMaxEnergyStored(), FeCompat.ratio(false));
            }
            if (energyCapacity == 0L) {
                ChargerMachine.this.changeState(State.IDLE);
            }
            return energyCapacity;
        }

        @Override
        public long getEnergyStored() {
            long energyStored = 0L;
            for (int i = 0; i < ChargerMachine.this.chargerInventory.getSlots(); ++i) {
                IEnergyStorage energyStorage;
                ItemStack electricItemStack = ChargerMachine.this.chargerInventory.getStackInSlot(i);
                IElectricItem electricItem = GTCapabilityHelper.getElectricItem(electricItemStack);
                if (electricItem != null) {
                    energyStored += electricItem.getCharge();
                    continue;
                }
                if (!ConfigHolder.INSTANCE.compat.energy.nativeEUToPlatformNative || (energyStorage = GTCapabilityHelper.getForgeEnergyItem(electricItemStack)) == null) continue;
                energyStored += FeCompat.toEu(energyStorage.getEnergyStored(), FeCompat.ratio(false));
            }
            long capacity = this.getEnergyCapacity();
            if (capacity != 0L && capacity == energyStored) {
                ChargerMachine.this.changeState(State.FINISHED);
            }
            return energyStored;
        }

        private long getInternalStorage() {
            return this.energyStored;
        }
    }
}

