/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.WidgetUtils;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.gui.editor.EditableUI;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FisherMachine
extends TieredEnergyMachine
implements IAutoOutputItem,
IFancyUIMachine,
IMachineModifyDrops,
IWorkable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FisherMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacingItems;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputItems;
    @Persisted
    protected final NotifiableItemStackHandler cache;
    @Persisted
    protected boolean allowInputFromOutputSideItems;
    @Persisted
    protected final NotifiableItemStackHandler baitHandler;
    @Persisted
    protected final ItemStackTransfer chargerInventory;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected TickableSubscription batterySubs;
    @Nullable
    protected TickableSubscription fishingSubs;
    @Nullable
    protected ISubscription exportItemSubs;
    @Nullable
    protected ISubscription energySubs;
    @Nullable
    protected ISubscription baitSubs;
    private final long energyPerTick;
    private final int inventorySize;
    public final int maxProgress;
    @Persisted
    private int progress = 0;
    @Persisted
    @DescSynced
    private boolean isWorkingEnabled = true;
    @Persisted
    private boolean active = false;
    public static final int WATER_CHECK_SIZE = 5;
    private static final ItemStack fishingRod = new ItemStack((ItemLike)Items.f_42523_);
    private boolean hasWater = false;
    public static BiFunction<ResourceLocation, Integer, EditableMachineUI> EDITABLE_UI_CREATOR = Util.m_143821_((path, inventorySize) -> new EditableMachineUI("misc", (ResourceLocation)path, () -> {
        WidgetGroup template = FisherMachine.createTemplate(inventorySize).createDefault();
        ProgressWidget energyBar = FisherMachine.createEnergyBar().createDefault();
        SlotWidget batterySlot = FisherMachine.createBatterySlot().createDefault();
        WidgetGroup energyGroup = new WidgetGroup(0, 0, energyBar.getSize().width, energyBar.getSize().height + 20);
        batterySlot.setSelfPosition(new Position((energyBar.getSize().width - 18) / 2, energyBar.getSize().height + 1));
        energyGroup.addWidget((Widget)energyBar);
        energyGroup.addWidget((Widget)batterySlot);
        WidgetGroup group = new WidgetGroup(0, 0, Math.max(energyGroup.getSize().width + template.getSize().width + 4 + 8, 172), Math.max(template.getSize().height + 8, energyGroup.getSize().height + 8));
        Size size = group.getSize();
        energyGroup.setSelfPosition(new Position(3, (size.height - energyGroup.getSize().height) / 2));
        template.setSelfPosition(new Position((size.width - energyGroup.getSize().width - 4 - template.getSize().width) / 2 + 2 + energyGroup.getSize().width + 2, (size.height - template.getSize().height) / 2));
        group.addWidget((Widget)energyGroup);
        group.addWidget((Widget)template);
        return group;
    }, (template, machine) -> {
        if (machine instanceof FisherMachine) {
            FisherMachine fisherMachine = (FisherMachine)machine;
            FisherMachine.createTemplate(inventorySize).setupUI((WidgetGroup)template, fisherMachine);
            FisherMachine.createEnergyBar().setupUI((WidgetGroup)template, fisherMachine);
            FisherMachine.createBatterySlot().setupUI((WidgetGroup)template, fisherMachine);
        }
    }));

    public FisherMachine(IMachineBlockEntity holder, int tier, Object ... ignoredArgs) {
        super(holder, tier, new Object[0]);
        this.inventorySize = (tier + 1) * (tier + 1);
        this.maxProgress = 1000 - tier * 200;
        this.energyPerTick = GTValues.V[tier - 1];
        this.cache = this.createCacheItemHandler();
        this.baitHandler = this.createBaitItemHandler();
        this.chargerInventory = this.createChargerItemHandler();
        this.setOutputFacingItems(this.getFrontFacing());
    }

    protected ItemStackTransfer createChargerItemHandler() {
        ItemStackTransfer transfer = new ItemStackTransfer();
        transfer.setFilter(item -> GTCapabilityHelper.getElectricItem(item) != null || ConfigHolder.INSTANCE.compat.energy.nativeEUToPlatformNative && GTCapabilityHelper.getForgeEnergyItem(item) != null);
        return transfer;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableItemStackHandler createCacheItemHandler() {
        return new NotifiableItemStackHandler(this, this.inventorySize, IO.BOTH, IO.OUT);
    }

    protected NotifiableItemStackHandler createBaitItemHandler() {
        NotifiableItemStackHandler handler = new NotifiableItemStackHandler(this, 1, IO.BOTH, IO.IN);
        handler.setFilter(item -> item.m_150930_(Items.f_42401_));
        return handler;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.isRemote()) {
            return;
        }
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
        }
        this.exportItemSubs = this.cache.addChangedListener(this::updateAutoOutputSubscription);
        this.energySubs = this.energyContainer.addChangedListener(() -> {
            this.updateBatterySubscription();
            this.updateFishingUpdateSubscription();
        });
        this.baitSubs = this.baitHandler.addChangedListener(this::updateFishingUpdateSubscription);
        this.chargerInventory.setOnContentsChanged(this::updateBatterySubscription);
        this.updateFishingUpdateSubscription();
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.energySubs != null) {
            this.energySubs.unsubscribe();
            this.energySubs = null;
        }
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
            this.exportItemSubs = null;
        }
        if (this.baitSubs != null) {
            this.baitSubs.unsubscribe();
            this.baitSubs = null;
        }
    }

    @Override
    public boolean shouldWeatherOrTerrainExplosion() {
        return false;
    }

    @Override
    public void onDrops(List<ItemStack> drops, Player entity) {
        FisherMachine.clearInventory(drops, (IItemTransfer)this.chargerInventory);
        FisherMachine.clearInventory(drops, (IItemTransfer)this.baitHandler.storage);
        FisherMachine.clearInventory(drops, (IItemTransfer)this.cache.storage);
    }

    public void updateFishingUpdateSubscription() {
        if (this.drainEnergy(true) && this.baitHandler.getStackInSlot(0).m_150930_(Items.f_42401_) && this.isWorkingEnabled) {
            this.fishingSubs = this.subscribeServerTick(this.fishingSubs, this::fishingUpdate);
            this.active = true;
            return;
        }
        if (this.fishingSubs != null) {
            this.fishingSubs.unsubscribe();
            this.fishingSubs = null;
            this.active = false;
        }
        this.progress = 0;
    }

    private void updateHasWater() {
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                BlockPos waterCheckPos = this.getPos().m_7495_().m_7918_(x - 2, 0, z - 2);
                if (this.getLevel().m_8055_(waterCheckPos).m_60819_().m_192917_((Fluid)Fluids.f_76193_)) continue;
                this.hasWater = false;
                return;
            }
        }
        this.hasWater = true;
    }

    public void fishingUpdate() {
        if (this.getOffsetTimer() % (long)this.maxProgress == 0L) {
            this.updateHasWater();
        }
        if (!this.hasWater) {
            return;
        }
        this.drainEnergy(false);
        if (this.progress >= this.maxProgress) {
            LootTable lootTable = this.getLevel().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78720_);
            FishingHook simulatedHook = new FishingHook(EntityType.f_20533_, this.getLevel()){

                public boolean m_37166_() {
                    return true;
                }
            };
            LootParams lootContext = new LootParams.Builder((ServerLevel)this.getLevel()).m_287289_(LootContextParams.f_81455_, (Object)simulatedHook).m_287286_(LootContextParams.f_81463_, (Object)fishingRod).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)this.getPos().m_123341_(), (double)this.getPos().m_123342_(), (double)this.getPos().m_123343_())).m_287235_(LootContextParamSets.f_81414_);
            NonNullList generatedLoot = NonNullList.m_122779_();
            generatedLoot.addAll((Collection)lootTable.m_287195_(lootContext));
            boolean useBait = false;
            for (ItemStack itemStack : generatedLoot) {
                useBait |= this.tryFillCache(itemStack);
            }
            if (useBait) {
                this.baitHandler.storage.extractItem(0, 1, false);
            }
            this.updateFishingUpdateSubscription();
            this.progress = -1;
        }
        ++this.progress;
    }

    private boolean tryFillCache(ItemStack stack) {
        for (int i = 0; i < this.cache.getSlots(); ++i) {
            if (this.cache.insertItemInternal(i, stack, false).m_41613_() >= stack.m_41613_()) continue;
            return true;
        }
        return false;
    }

    public boolean drainEnergy(boolean simulate) {
        long resultEnergy = this.energyContainer.getEnergyStored() - this.energyPerTick;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.removeEnergy(this.energyPerTick);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setAutoOutputItems(boolean allow) {
        this.autoOutputItems = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void setOutputFacingItems(@Nullable Direction outputFacing) {
        this.outputFacingItems = outputFacing;
        this.updateAutoOutputSubscription();
    }

    protected void updateBatterySubscription() {
        if (this.energyContainer.dischargeOrRechargeEnergyContainers((IItemTransfer)this.chargerInventory, 0, true)) {
            this.batterySubs = this.subscribeServerTick(this.batterySubs, this::chargeBattery);
        } else if (this.batterySubs != null) {
            this.batterySubs.unsubscribe();
            this.batterySubs = null;
        }
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacing = this.getOutputFacingItems();
        if (this.isAutoOutputItems() && !this.cache.isEmpty() && outputFacing != null && ItemTransferHelper.getItemTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(outputFacing), (Direction)outputFacing.m_122424_()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.cache.exportToNearby(this.getOutputFacingItems());
            }
            this.updateAutoOutputSubscription();
        }
    }

    protected void chargeBattery() {
        if (!this.energyContainer.dischargeOrRechargeEnergyContainers((IItemTransfer)this.chargerInventory, 0, false)) {
            this.updateBatterySubscription();
        }
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        if (facing == this.getOutputFacingItems()) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    protected static EditableUI<SlotWidget, FisherMachine> createBatterySlot() {
        return new EditableUI<SlotWidget, FisherMachine>("battery_slot", SlotWidget.class, () -> {
            SlotWidget slotWidget = new SlotWidget();
            slotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY});
            return slotWidget;
        }, (slotWidget, machine) -> {
            slotWidget.setHandlerSlot((IItemTransfer)machine.chargerInventory, 0);
            slotWidget.setCanPutItems(true);
            slotWidget.setCanTakeItems(true);
            slotWidget.setHoverTooltips((Component[])LangHandler.getMultiLang("gtceu.gui.charger_slot.tooltip", GTValues.VNF[machine.getTier()], GTValues.VNF[machine.getTier()]).toArray(new MutableComponent[0]));
        });
    }

    protected static EditableUI<WidgetGroup, FisherMachine> createTemplate(int inventorySize) {
        return new EditableUI<WidgetGroup, FisherMachine>("functional_container", WidgetGroup.class, () -> {
            int rowSize = (int)Math.sqrt(inventorySize);
            WidgetGroup main = new WidgetGroup(0, 0, rowSize * 18 + 8 + 20, rowSize * 18 + 8);
            for (int y = 0; y < rowSize; ++y) {
                for (int x = 0; x < rowSize; ++x) {
                    int index = y * rowSize + x;
                    SlotWidget slotWidget = new SlotWidget();
                    slotWidget.initTemplate();
                    slotWidget.setSelfPosition(new Position(24 + x * 18, 4 + y * 18));
                    slotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT});
                    slotWidget.setId("slot_" + index);
                    main.addWidget((Widget)slotWidget);
                }
            }
            SlotWidget baitSlotWidget = new SlotWidget();
            baitSlotWidget.initTemplate();
            baitSlotWidget.setSelfPosition(new Position(4, (main.getSize().height - baitSlotWidget.getSize().height) / 2));
            baitSlotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.STRING_SLOT_OVERLAY});
            baitSlotWidget.setId("bait_slot");
            main.addWidget((Widget)baitSlotWidget);
            main.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
            return main;
        }, (group, machine) -> {
            WidgetUtils.widgetByIdForEach(group, "^slot_[0-9]+$", SlotWidget.class, slot -> {
                int index = WidgetUtils.widgetIdIndex((Widget)slot);
                if (index >= 0 && index < machine.cache.getSlots()) {
                    slot.setHandlerSlot((IItemTransfer)machine.cache, index);
                    slot.setCanTakeItems(true);
                    slot.setCanPutItems(false);
                }
            });
            WidgetUtils.widgetByIdForEach(group, "^bait_slot$", SlotWidget.class, slot -> {
                slot.setHandlerSlot((IItemTransfer)machine.baitHandler.storage, 0);
                slot.setCanTakeItems(true);
                slot.setCanPutItems(true);
            });
        });
    }

    @Override
    public ResourceTexture sideTips(Player player, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (!(player.m_6144_() || this.hasFrontFacing() && side == this.getFrontFacing())) {
                return GuiTextures.TOOL_IO_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SCREWDRIVER)) {
            if (side == this.getOutputFacingItems()) {
                return GuiTextures.TOOL_ALLOW_INPUT;
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            return this.isWorkingEnabled ? GuiTextures.TOOL_PAUSE : GuiTextures.TOOL_START;
        }
        return super.sideTips(player, toolTypes, side);
    }

    @Override
    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!playerIn.m_6144_() && !this.isRemote()) {
            ItemStack tool = playerIn.m_21120_(hand);
            if (tool.m_41773_() >= tool.m_41776_()) {
                return InteractionResult.PASS;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return InteractionResult.PASS;
            }
            Direction itemFacing = this.outputFacingItems;
            if (gridSide != itemFacing) {
                this.setOutputFacingItems(gridSide);
            } else {
                this.setOutputFacingItems(null);
            }
            return InteractionResult.CONSUME;
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    public Direction getOutputFacingItems() {
        return this.outputFacingItems;
    }

    @Override
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSideItems;
    }

    @Override
    public void setAllowInputFromOutputSideItems(boolean allowInputFromOutputSideItems) {
        this.allowInputFromOutputSideItems = allowInputFromOutputSideItems;
    }

    public ItemStackTransfer getChargerInventory() {
        return this.chargerInventory;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingEnabled) {
        this.isWorkingEnabled = isWorkingEnabled;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }
}

