/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.misc.FluidBlockTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PumpMachine
extends TieredEnergyMachine
implements IAutoOutputFluid,
IUIMachine,
IMachineLife {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PumpMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    public static final int BASE_PUMP_RANGE = 32;
    public static final int EXTRA_PUMP_RANGE = 8;
    public static final int PUMP_SPEED_BASE = 80;
    private final Deque<BlockPos> fluidSourceBlocks = new ArrayDeque<BlockPos>();
    private final Deque<BlockPos> blocksToCheck = new ArrayDeque<BlockPos>();
    private boolean initializedQueue = false;
    @Persisted
    private int pumpHeadY;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputFluids;
    @Persisted
    @DropSaved
    protected final NotifiableFluidTank cache;

    public PumpMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, new Object[0]);
        this.cache = this.createCacheFluidHandler(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createCacheFluidHandler(Object ... args) {
        return new NotifiableFluidTank(this, 1, 16L * FluidHelper.getBucket() * (long)Math.max(1, this.getTier()), IO.NONE, IO.OUT);
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return false;
    }

    @Override
    public void setAllowInputFromOutputSideFluids(boolean allow) {
    }

    @Override
    public Direction getOutputFacingFluids() {
        return this.getFrontFacing();
    }

    @Override
    public void setOutputFacingFluids(Direction outputFacing) {
        this.setFrontFacing(outputFacing);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscribeServerTick(this::update);
    }

    @Override
    public boolean shouldWeatherOrTerrainExplosion() {
        return false;
    }

    private int getMaxPumpRange() {
        return 32 + 8 * this.getTier();
    }

    private boolean isStraightInPumpRange(BlockPos checkPos) {
        BlockPos pos = this.getPos();
        return checkPos.m_123341_() == pos.m_123341_() && checkPos.m_123343_() == pos.m_123343_() && pos.m_123342_() < checkPos.m_123342_() && pos.m_123342_() + this.pumpHeadY >= checkPos.m_123342_();
    }

    private void updateQueueState(int blocksToCheckAmount) {
        BlockPos selfPos = this.getPos().m_6625_(this.pumpHeadY);
        for (int i = 0; i < blocksToCheckAmount; ++i) {
            BlockPos checkPos = null;
            int amountIterated = 0;
            do {
                if (checkPos == null) continue;
                this.blocksToCheck.push(checkPos);
                ++amountIterated;
            } while ((checkPos = this.blocksToCheck.poll()) != null && !this.getLevel().m_46749_(checkPos) && amountIterated < this.blocksToCheck.size());
            if (checkPos == null) break;
            this.checkFluidBlockAt(selfPos, checkPos);
        }
        if (this.fluidSourceBlocks.isEmpty()) {
            if (this.getOffsetTimer() % 20L == 0L) {
                BlockState downBlock;
                BlockPos downPos = selfPos.m_6625_(1);
                if (downPos.m_123342_() >= this.getLevel().m_141937_() && (downBlock = this.getLevel().m_8055_(downPos)).m_60734_() instanceof LiquidBlock) {
                    ServerLevel serverLevel;
                    ++this.pumpHeadY;
                    Level level = this.getLevel();
                    if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_8055_(selfPos).m_60795_()) {
                        serverLevel.m_46597_(selfPos, GTBlocks.MINER_PIPE.getDefaultState());
                    }
                }
                this.initializedQueue = false;
            }
            if (!this.initializedQueue || this.getOffsetTimer() % 6000L == 0L) {
                this.initializedQueue = true;
                this.blocksToCheck.add(selfPos);
            }
        }
    }

    @Override
    public void onMachineRemoved() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.getPos().m_121945_(Direction.DOWN);
            while (serverLevel.m_8055_(pos).m_60713_((Block)GTBlocks.MINER_PIPE.get())) {
                serverLevel.m_7471_(pos, false);
                pos = pos.m_121945_(Direction.DOWN);
            }
        }
    }

    private void checkFluidBlockAt(BlockPos pumpHeadPos, BlockPos checkPos) {
        LiquidBlock liquidBlock;
        BlockState blockHere = this.getLevel().m_8055_(checkPos);
        boolean shouldCheckNeighbours = this.isStraightInPumpRange(checkPos);
        Direction[] directionArray = blockHere.m_60734_();
        if (directionArray instanceof LiquidBlock && (liquidBlock = (LiquidBlock)directionArray).m_5888_(blockHere).m_76170_()) {
            FluidBlockTransfer fluidHandler = new FluidBlockTransfer(liquidBlock, this.getLevel(), checkPos);
            FluidStack drainStack = fluidHandler.drain(Integer.MAX_VALUE, true);
            if (!drainStack.isEmpty()) {
                this.fluidSourceBlocks.add(checkPos);
            }
            shouldCheckNeighbours = true;
        }
        if (shouldCheckNeighbours) {
            int maxPumpRange = this.getMaxPumpRange();
            for (Direction facing : GTUtil.DIRECTIONS) {
                BlockPos offsetPos = checkPos.m_121945_(facing);
                if (offsetPos.m_123331_((Vec3i)pumpHeadPos) > (double)(maxPumpRange * maxPumpRange) || this.fluidSourceBlocks.contains(offsetPos) || this.blocksToCheck.contains(offsetPos)) continue;
                this.blocksToCheck.add(offsetPos);
            }
        }
    }

    private void tryPumpFirstBlock() {
        FluidBlockTransfer fluidHandler;
        FluidStack drainStack;
        LiquidBlock liquidBlock;
        BlockPos fluidBlockPos = this.fluidSourceBlocks.poll();
        if (fluidBlockPos == null) {
            return;
        }
        BlockState blockHere = this.getLevel().m_8055_(fluidBlockPos);
        Block block = blockHere.m_60734_();
        if (block instanceof LiquidBlock && (liquidBlock = (LiquidBlock)block).m_5888_(blockHere).m_76170_() && !(drainStack = (fluidHandler = new FluidBlockTransfer(liquidBlock, this.getLevel(), fluidBlockPos)).drain(Integer.MAX_VALUE, true)).isEmpty() && this.cache.fillInternal(drainStack, true) == drainStack.getAmount()) {
            this.cache.fillInternal(drainStack, false);
            fluidHandler.drain(drainStack, false);
            this.getLevel().m_46597_(fluidBlockPos, Blocks.f_50016_.m_49966_());
            this.fluidSourceBlocks.remove(fluidBlockPos);
            this.energyContainer.changeEnergy(-GTValues.V[this.getTier()] * 2L);
        }
    }

    public void update() {
        if (this.getOutputFacingFluids() != null) {
            this.cache.exportToNearby(this.getOutputFacingFluids());
        }
        if (this.energyContainer.getEnergyStored() < GTValues.V[this.getTier()] * 2L) {
            return;
        }
        this.updateQueueState(this.getTier());
        if (this.getOffsetTimer() % (long)this.getPumpingCycleLength() == 0L && !this.fluidSourceBlocks.isEmpty()) {
            this.tryPumpFirstBlock();
        }
    }

    private int getPumpingCycleLength() {
        return 80 / (1 << this.getTier() - 1);
    }

    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new ImageWidget(7, 16, 81, 55, (IGuiTexture)GuiTextures.DISPLAY)).widget((Widget)new LabelWidget(11, 20, "gtceu.gui.fluid_amount")).widget((Widget)new LabelWidget(11, 30, () -> "" + this.cache.getFluidInTank(0).getAmount()).setTextColor(-1).setDropShadow(true)).widget((Widget)new LabelWidget(6, 6, this.getBlockState().m_60734_().m_7705_())).widget((Widget)new TankWidget((IFluidStorage)this.cache.getStorages()[0], 90, 35, true, true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT)).widget((Widget)new ToggleButtonWidget(7, 53, 18, 18, (IGuiTexture)GuiTextures.BUTTON_FLUID_OUTPUT, this::isAutoOutputFluids, this::setAutoOutputFluids).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_auto_output.tooltip")).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT, 7, 84, true));
    }

    @Override
    public ResourceTexture sideTips(Player player, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.WRENCH) && player.m_6144_() && this.hasFrontFacing() && side != this.getFrontFacing() && this.isFacingValid(side)) {
            return GuiTextures.TOOL_IO_FACING_ROTATION;
        }
        return super.sideTips(player, toolTypes, side);
    }

    public int getPumpHeadY() {
        return this.pumpHeadY;
    }

    @Override
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    public void setAutoOutputFluids(boolean autoOutputFluids) {
        this.autoOutputFluids = autoOutputFluids;
    }
}

