/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.kinetic;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.common.blockentity.KineticMachineBlockEntity;
import com.gregtechceu.gtceu.common.machine.kinetic.IKineticMachine;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ElectricGearBoxMachine
extends TieredEnergyMachine
implements IKineticMachine,
IFancyUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ElectricGearBoxMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    public final int maxAmps;
    @Persisted
    @DescSynced
    protected int currentAmps;

    public ElectricGearBoxMachine(IMachineBlockEntity holder, int tier, int maxAmps) {
        super(holder, tier, maxAmps);
        this.maxAmps = maxAmps;
        this.currentAmps = maxAmps;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        NotifiableEnergyContainer container;
        long tierVoltage = GTValues.V[this.tier];
        int amps = (Integer)args[0];
        if (this.isEnergyEmitter()) {
            container = NotifiableEnergyContainer.emitterContainer(this, tierVoltage * 64L, tierVoltage, amps);
            container.setSideOutputCondition(dir -> dir.m_122434_() != this.getRotationFacing().m_122434_());
        } else {
            container = NotifiableEnergyContainer.receiverContainer(this, tierVoltage * 64L, tierVoltage, amps);
            container.setSideInputCondition(dir -> dir.m_122434_() != this.getRotationFacing().m_122434_());
        }
        container.setCapabilityValidator(dir -> dir == null || dir.m_122434_() != this.getRotationFacing().m_122434_());
        return container;
    }

    @Override
    protected boolean isEnergyEmitter() {
        return !this.getKineticDefinition().isSource();
    }

    @Override
    protected long getMaxInputOutputAmperage() {
        return this.maxAmps;
    }

    public void setCurrentAmps(int currentAmps) {
        this.currentAmps = Mth.m_14045_((int)currentAmps, (int)0, (int)this.maxAmps);
    }

    public float getCurrentRPM() {
        return this.getCurrentAmps() * 8;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscribeServerTick(this::outputRotation);
    }

    @Override
    public void onRotated(Direction oldFacing, Direction newFacing) {
        super.onRotated(oldFacing, newFacing);
        if (!this.isRemote() && oldFacing.m_122434_() != newFacing.m_122434_()) {
            KineticMachineBlockEntity holder = this.getKineticHolder();
            if (holder.hasNetwork()) {
                holder.getOrCreateNetwork().remove((KineticBlockEntity)holder);
            }
            holder.detachKinetics();
            holder.removeSource();
        }
    }

    @Override
    public float getRotationSpeedModifier(Direction direction) {
        if (direction == this.getRotationFacing().m_122424_()) {
            return -1.0f;
        }
        return 1.0f;
    }

    protected void outputRotation() {
        if (this.getKineticDefinition().isSource()) {
            long maxCharged;
            long charged;
            if (this.getCurrentAmps() == 0) {
                this.getKineticHolder().stopWorking();
            }
            if ((charged = this.energyContainer.removeEnergy(maxCharged = (long)this.getCurrentAmps() * this.energyContainer.getInputVoltage())) > 0L) {
                this.getKineticHolder().scheduleWorking(this.getCurrentRPM() * this.getKineticDefinition().getTorque() * (float)charged / (float)maxCharged);
            } else {
                this.getKineticHolder().stopWorking();
            }
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 164, 48);
        group.addWidget((Widget)new ImageWidget(36, 4, 92, 20, (IGuiTexture)new TextTexture("").setWidth(92).setType(TextTexture.TextType.ROLL).setSupplier(() -> "Speed: " + this.getKineticHolder().workingSpeed))).addWidget(new ButtonWidget(4, 24, 30, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, new TextTexture("-8rpm")}), cd -> {
            if (!cd.isRemote) {
                int amount = cd.isCtrlClick ? (cd.isShiftClick ? 32 : 16) : (cd.isShiftClick ? 4 : 1);
                this.setCurrentAmps(this.currentAmps - amount);
            }
        }).setHoverTooltips(new String[]{"gui.widget.incrementButton.default_tooltip"})).addWidget(new ButtonWidget(130, 24, 30, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, new TextTexture("+8rpm")}), cd -> {
            if (!cd.isRemote) {
                int amount = cd.isCtrlClick ? (cd.isShiftClick ? 32 : 16) : (cd.isShiftClick ? 4 : 1);
                this.setCurrentAmps(this.currentAmps + amount);
            }
        }).setHoverTooltips(new String[]{"gui.widget.incrementButton.default_tooltip"})).addWidget((Widget)new ImageWidget(36, 24, 92, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{new ColorRectTexture(-16777216), new ColorBorderTexture(1, -1), new TextTexture("").setWidth(92).setType(TextTexture.TextType.ROLL).setSupplier(() -> this.getCurrentRPM() + "rpm")})));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    @Override
    public boolean hasPlayerInventory() {
        return false;
    }

    public int getCurrentAmps() {
        return this.currentAmps;
    }
}

