/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class AssemblyLineMachine
extends WorkableElectricMultiblockMachine {
    public AssemblyLineMachine(IMachineBlockEntity holder) {
        super(holder, new Object[0]);
    }

    @Override
    public boolean beforeWorking(@Nullable GTRecipe recipe) {
        if (ConfigHolder.INSTANCE.machines.orderedAssemblyLineItems) {
            List<Content> recipeInputs = recipe.inputs.get(ItemRecipeCapability.CAP);
            List<List> itemInputInventory = Objects.requireNonNullElseGet((List)this.getCapabilitiesProxy().get((Object)IO.IN, (Object)ItemRecipeCapability.CAP), Collections::emptyList).stream().filter(handler -> !handler.isProxy()).map(container -> container.getContents().stream().filter(ItemStack.class::isInstance).map(ItemStack.class::cast).toList()).filter(container -> !container.isEmpty()).toList();
            if (itemInputInventory.size() < recipeInputs.size()) {
                return false;
            }
            for (int i = 0; i < recipeInputs.size(); ++i) {
                ItemStack itemStack = (ItemStack)itemInputInventory.get(i).get(0);
                Ingredient recipeStack = (Ingredient)ItemRecipeCapability.CAP.of(recipeInputs.get((int)i).content);
                if (recipeStack.test(itemStack)) continue;
                return false;
            }
            if (ConfigHolder.INSTANCE.machines.orderedAssemblyLineFluids) {
                recipeInputs = recipe.inputs.get(FluidRecipeCapability.CAP);
                List<List> itemFluidInventory = Objects.requireNonNullElseGet((List)this.getCapabilitiesProxy().get((Object)IO.IN, (Object)FluidRecipeCapability.CAP), Collections::emptyList).stream().map(container -> container.getContents().stream().filter(FluidStack.class::isInstance).map(FluidStack.class::cast).toList()).filter(container -> !container.isEmpty()).toList();
                if (itemFluidInventory.size() < recipeInputs.size()) {
                    return false;
                }
                for (int i = 0; i < recipeInputs.size(); ++i) {
                    FluidStack fluidStack = (FluidStack)itemFluidInventory.get(i).get(0);
                    FluidIngredient recipeStack = (FluidIngredient)FluidRecipeCapability.CAP.of(recipeInputs.get((int)i).content);
                    if (recipeStack.test(fluidStack) && recipeStack.getAmount() <= fluidStack.getAmount()) continue;
                    return false;
                }
            }
        }
        return super.beforeWorking(recipe);
    }

    @Override
    public void onStructureFormed() {
        this.getDefinition().setPartSorter(Comparator.comparing(it -> this.multiblockPartSorter().apply(it.self().getPos())));
        super.onStructureFormed();
    }

    private Function<BlockPos, Integer> multiblockPartSorter() {
        return RelativeDirection.RIGHT.getSorter(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
    }
}

