/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.fluids.PropertyFluidFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MultiblockTankMachine
extends MultiblockControllerMachine
implements IFancyUIMachine {
    @Persisted
    @NotNull
    private final NotifiableFluidTank tank;
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MultiblockTankMachine.class, MultiblockControllerMachine.MANAGED_FIELD_HOLDER);

    public MultiblockTankMachine(IMachineBlockEntity holder, int capacity, @Nullable PropertyFluidFilter filter, Object ... args) {
        super(holder);
        this.tank = this.createTank(capacity, filter, args);
    }

    protected NotifiableFluidTank createTank(int capacity, @Nullable PropertyFluidFilter filter, Object ... args) {
        NotifiableFluidTank fluidTank = new NotifiableFluidTank((MetaMachine)this, 1, capacity, IO.BOTH);
        if (filter != null) {
            fluidTank.setFilter(filter);
        }
        return fluidTank;
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult superResult = super.onUse(state, world, pos, player, hand, hit);
        if (superResult != InteractionResult.PASS) {
            return superResult;
        }
        if (!this.isFormed()) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 90, 63);
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)new ImageWidget(4, 4, 82, 55, (IGuiTexture)GuiTextures.DISPLAY));
        group.addWidget((Widget)new LabelWidget(8, 8, "gtceu.gui.fluid_amount"));
        group.addWidget((Widget)new LabelWidget(8, 18, this::getFluidLabel).setTextColor(-1).setDropShadow(true));
        group.addWidget((Widget)new TankWidget((IFluidStorage)this.tank.getStorages()[0], 68, 23, true, true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
        return group;
    }

    private String getFluidLabel() {
        return String.valueOf(this.tank.getFluidInTank(0).getAmount() / (FluidHelper.getBucket() / 1000L));
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @NotNull
    public NotifiableFluidTank getTank() {
        return this.tank;
    }
}

