/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.common.machine.multiblock.part.FluidHatchPartMachine;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import java.util.Collections;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ReservoirHatchPartMachine
extends FluidHatchPartMachine {
    protected InfiniteWaterTank waterTank;
    public static final long FLUID_AMOUNT = 2000000000L;

    public ReservoirHatchPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, 4, IO.IN, 2000000000L, 1, args);
    }

    @Override
    protected NotifiableFluidTank createTank(long initialCapacity, int slots, Object ... args) {
        this.waterTank = new InfiniteWaterTank(initialCapacity);
        return new NotifiableFluidTank((MetaMachine)this, Collections.singletonList(this.waterTank), this.io, IO.BOTH);
    }

    @Override
    protected void updateTankSubscription() {
        if (this.isWorkingEnabled() && !this.waterTank.isFull()) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    @Override
    protected void autoIO() {
        if (this.getOffsetTimer() % 20L == 0L) {
            this.waterTank.refillWater();
            this.updateTankSubscription();
        }
    }

    protected static class InfiniteWaterTank
    extends FluidStorage {
        private static final CompoundTag EMPTY = new CompoundTag();
        private static final FluidStack WATER = FluidStack.create((Fluid)Fluids.f_76193_, (long)Long.MAX_VALUE);

        public InfiniteWaterTank(long capacity) {
            super(capacity);
            this.setFluid(FluidStack.create((Fluid)Fluids.f_76193_, (long)capacity));
        }

        public void refillWater() {
            super.fill(0, WATER, false, true);
        }

        public boolean isFull() {
            return this.getFluidAmount() >= this.capacity;
        }

        public boolean supportsFill(int tank) {
            return false;
        }

        public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChange) {
            return 0L;
        }

        public CompoundTag serializeNBT() {
            return EMPTY;
        }

        public void deserializeNBT(CompoundTag nbt) {
        }

        public FluidStorage copy() {
            InfiniteWaterTank storage = new InfiniteWaterTank(this.capacity);
            storage.setFluid(this.fluid.copy());
            return storage;
        }
    }
}

