/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.primitive;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.item.tool.behavior.LighterBehavior;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CharcoalPileIgniterMachine
extends WorkableMultiblockMachine
implements IWorkable {
    private static final Set<Block> WALL_BLOCKS = new ObjectOpenHashSet();
    private final Collection<BlockPos> logPos = new ObjectOpenHashSet();
    private static final int MIN_RADIUS = 1;
    private static final int MIN_DEPTH = 2;
    @DescSynced
    private int lDist = 0;
    @DescSynced
    private int rDist = 0;
    @DescSynced
    private int hDist = 0;
    @DescSynced
    @RequireRerender
    private boolean isActive;
    private int progressTime = 0;
    private int maxTime = 0;
    private TickableSubscription burnLogsSubscription;

    public CharcoalPileIgniterMachine(IMachineBlockEntity holder) {
        super(holder, new Object[0]);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.updateMaxProgessTime();
        this.burnLogsSubscription = this.subscribeServerTick(this::tick);
        this.tick();
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.resetState();
        this.progressTime = 0;
        this.maxTime = 0;
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.resetState();
    }

    private void resetState() {
        this.unsubscribe(this.burnLogsSubscription);
        this.isActive = false;
    }

    @Override
    public int getProgress() {
        return this.progressTime;
    }

    @Override
    public int getMaxProgress() {
        return this.maxTime;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public BlockPattern getPattern() {
        int i;
        this.updateDimensions();
        if (this.lDist < 1) {
            this.lDist = 1;
        }
        if (this.rDist < 1) {
            this.rDist = 1;
        }
        if (this.hDist < 2) {
            this.hDist = 1;
        }
        if (this.getFrontFacing().m_122434_() == Direction.Axis.X) {
            int tmp = this.lDist;
            this.lDist = this.rDist;
            this.rDist = tmp;
        }
        StringBuilder wallBuilder = new StringBuilder();
        StringBuilder floorBuilder = new StringBuilder();
        StringBuilder cornerBuilder = new StringBuilder();
        StringBuilder ctrlBuilder = new StringBuilder();
        StringBuilder woodBuilder = new StringBuilder();
        wallBuilder.append(" ");
        floorBuilder.append(" ");
        ctrlBuilder.append(" ");
        woodBuilder.append("X");
        for (i = 0; i < this.lDist; ++i) {
            cornerBuilder.append(" ");
            if (i <= 0) continue;
            wallBuilder.append("X");
            floorBuilder.append("B");
            ctrlBuilder.append("X");
            woodBuilder.append("C");
        }
        wallBuilder.append("X");
        floorBuilder.append("B");
        cornerBuilder.append(" ");
        ctrlBuilder.append("S");
        woodBuilder.append("C");
        for (i = 0; i < this.rDist; ++i) {
            cornerBuilder.append(" ");
            if (i >= this.rDist - 1) continue;
            wallBuilder.append("X");
            floorBuilder.append("B");
            ctrlBuilder.append("X");
            woodBuilder.append("C");
        }
        wallBuilder.append(" ");
        floorBuilder.append(" ");
        ctrlBuilder.append(" ");
        woodBuilder.append("X");
        Object[] wall = new String[this.hDist + 1];
        Arrays.fill(wall, wallBuilder.toString());
        wall[0] = cornerBuilder.toString();
        wall[wall.length - 1] = cornerBuilder.toString();
        Object[] slice = new String[this.hDist + 1];
        Arrays.fill(slice, woodBuilder.toString());
        slice[0] = floorBuilder.toString();
        String[] center = (String[])Arrays.copyOf(slice, slice.length);
        center[center.length - 1] = this.getFrontFacing().m_122434_() == Direction.Axis.X ? ctrlBuilder.reverse().toString() : ctrlBuilder.toString();
        slice[slice.length - 1] = wallBuilder.toString();
        return FactoryBlockPattern.start().aisle((String[])wall).aisle((String[])slice).setRepeatable(0, 4).aisle(center).aisle((String[])slice).setRepeatable(0, 4).aisle((String[])wall).where('S', Predicates.controller(Predicates.blocks(this.getDefinition().get()))).where('B', Predicates.blocks(Blocks.f_50076_)).where('X', Predicates.blocks(WALL_BLOCKS.toArray(new Block[0]))).where('C', this.logPredicate()).where(' ', Predicates.any()).build();
    }

    private TraceabilityPredicate logPredicate() {
        return new TraceabilityPredicate(multiblockState -> {
            if (multiblockState.getBlockState().m_204336_(BlockTags.f_13105_)) {
                this.logPos.add(multiblockState.getPos());
                return true;
            }
            return false;
        }, null);
    }

    public boolean updateDimensions() {
        Level level = this.getLevel();
        Direction left = this.getFrontFacing().m_122424_().m_122428_();
        Direction right = left.m_122424_();
        BlockPos.MutableBlockPos lPos = new BlockPos.MutableBlockPos(this.getPos().m_123341_(), this.getPos().m_123342_(), this.getPos().m_123343_()).m_122173_(Direction.DOWN);
        BlockPos.MutableBlockPos rPos = new BlockPos.MutableBlockPos(this.getPos().m_123341_(), this.getPos().m_123342_(), this.getPos().m_123343_()).m_122173_(Direction.DOWN);
        BlockPos.MutableBlockPos hPos = new BlockPos.MutableBlockPos(this.getPos().m_123341_(), this.getPos().m_123342_(), this.getPos().m_123343_());
        int lDist = 0;
        int rDist = 0;
        int hDist = 0;
        for (int i = 1; i < 6 && (lDist == 0 || rDist == 0 || hDist == 0); ++i) {
            if (lDist == 0 && CharcoalPileIgniterMachine.isBlockWall(level, lPos, left)) {
                lDist = i;
            }
            if (rDist == 0 && CharcoalPileIgniterMachine.isBlockWall(level, rPos, right)) {
                rDist = i;
            }
            if (hDist != 0 || !CharcoalPileIgniterMachine.isBlockFloor(level, hPos)) continue;
            hDist = i;
        }
        if (lDist < 1 || rDist < 1 || hDist < 2) {
            this.onStructureInvalid();
            return false;
        }
        this.lDist = lDist;
        this.rDist = rDist;
        this.hDist = hDist;
        return true;
    }

    private static boolean isBlockWall(Level level, BlockPos.MutableBlockPos pos, Direction direction) {
        return WALL_BLOCKS.contains(level.m_8055_((BlockPos)pos.m_122173_(direction)).m_60734_());
    }

    private static boolean isBlockFloor(Level level, BlockPos.MutableBlockPos pos) {
        return level.m_8055_((BlockPos)pos.m_122173_(Direction.DOWN)).m_60734_() == Blocks.f_50076_;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    private void updateMaxProgessTime() {
        this.maxTime = Math.max(1, (int)Math.sqrt(this.logPos.size() * 240000));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        if (this.recipeLogic.isWorking()) {
            BlockPos pos = this.getPos();
            Direction facing = Direction.UP;
            float xPos = (float)facing.m_122429_() * 0.76f + (float)pos.m_123341_() + 0.5f;
            float yPos = (float)facing.m_122430_() * 0.76f + (float)pos.m_123342_() + 0.25f;
            float zPos = (float)facing.m_122431_() * 0.76f + (float)pos.m_123343_() + 0.5f;
            float ySpd = (float)facing.m_122430_() * 0.1f + 0.2f + 0.1f * GTValues.RNG.m_188501_();
            this.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)xPos, (double)yPos, (double)zPos, 0.0, (double)ySpd, 0.0);
        }
    }

    public void tick() {
        if (this.isActive && this.maxTime > 0 && ++this.progressTime == this.maxTime) {
            this.progressTime = 0;
            this.maxTime = 0;
            this.convertLogBlocks();
            this.isActive = false;
        }
    }

    private void convertLogBlocks() {
        Level level = this.getLevel();
        for (BlockPos pos : this.logPos) {
            level.m_7731_(pos, GTBlocks.BRITTLE_CHARCOAL.getDefaultState(), 3);
        }
        this.logPos.clear();
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        CharcoalPileIgniterMachine cpi;
        IMachineBlockEntity machineBe;
        MetaMachine mte;
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof IMachineBlockEntity && (mte = (machineBe = (IMachineBlockEntity)be).getMetaMachine()) instanceof CharcoalPileIgniterMachine && (cpi = (CharcoalPileIgniterMachine)mte).isFormed()) {
            if (world.f_46443_) {
                player.m_6674_(hand);
            } else if (!cpi.isActive()) {
                boolean shouldActivate = false;
                ItemStack stack = player.m_21120_(hand);
                if (stack.m_41720_() instanceof FlintAndSteelItem) {
                    stack.m_41720_().damageItem(stack, 1, (LivingEntity)player, null);
                    this.getLevel().m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    shouldActivate = true;
                } else if (stack.m_41720_() instanceof FireChargeItem) {
                    stack.m_41774_(1);
                    this.getLevel().m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    shouldActivate = true;
                } else {
                    Item item = stack.m_41720_();
                    if (item instanceof ComponentItem) {
                        ComponentItem compItem = (ComponentItem)item;
                        for (IItemComponent component : compItem.getComponents()) {
                            LighterBehavior lighter;
                            if (!(component instanceof LighterBehavior) || !(lighter = (LighterBehavior)component).consumeFuel(player, stack)) continue;
                            this.getLevel().m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            shouldActivate = true;
                            break;
                        }
                    }
                }
                if (shouldActivate) {
                    cpi.setActive(true);
                    return InteractionResult.CONSUME;
                }
            }
        }
        return super.onUse(state, world, pos, player, hand, hit);
    }

    static {
        WALL_BLOCKS.add(Blocks.f_50493_);
        WALL_BLOCKS.add(Blocks.f_50546_);
        WALL_BLOCKS.add(Blocks.f_50599_);
        WALL_BLOCKS.add(Blocks.f_50440_);
        WALL_BLOCKS.add(Blocks.f_152481_);
        WALL_BLOCKS.add(Blocks.f_49992_);
        WALL_BLOCKS.add(Blocks.f_49993_);
    }
}

