/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.steam;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IMiner;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.PredicatedImageWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IDataInfoProvider;
import com.gregtechceu.gtceu.api.machine.feature.IExhaustVentMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamWorkableMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.item.PortableScannerBehavior;
import com.gregtechceu.gtceu.common.machine.trait.miner.SteamMinerLogic;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SteamMinerMachine
extends SteamWorkableMachine
implements IMiner,
IControllable,
IExhaustVentMachine,
IUIMachine,
IMachineModifyDrops,
IDataInfoProvider {
    @Persisted
    @DescSynced
    private boolean needsVenting;
    @Persisted
    public final NotifiableItemStackHandler importItems;
    @Persisted
    public final NotifiableItemStackHandler exportItems;
    private final int inventorySize;
    private final int energyPerTick = (int)(16L * FluidHelper.getBucket() / 1000L);
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription exportItemSubs;

    public SteamMinerMachine(IMachineBlockEntity holder, int speed, int maximumRadius, int fortune) {
        super(holder, false, fortune, speed, maximumRadius);
        this.inventorySize = 4;
        this.importItems = this.createImportItemHandler(new Object[0]);
        this.exportItems = this.createExportItemHandler(new Object[0]);
    }

    @Override
    @NotNull
    protected RecipeLogic createRecipeLogic(Object ... args) {
        Object object;
        if (args.length > 2 && (object = args[args.length - 3]) instanceof Integer) {
            Integer fortune = (Integer)object;
            object = args[args.length - 2];
            if (object instanceof Integer) {
                Integer speed = (Integer)object;
                object = args[args.length - 1];
                if (object instanceof Integer) {
                    Integer maxRadius = (Integer)object;
                    return new SteamMinerLogic(this, fortune, speed, maxRadius);
                }
            }
        }
        throw new IllegalArgumentException("MinerMachine need args [inventorySize, fortune, speed, maximumRadius] for initialization");
    }

    @Override
    public SteamMinerLogic getRecipeLogic() {
        return (SteamMinerLogic)super.getRecipeLogic();
    }

    @Override
    protected NotifiableFluidTank createSteamTank(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, 16L * FluidHelper.getBucket(), IO.IN);
    }

    protected NotifiableItemStackHandler createImportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, 0, IO.IN);
    }

    protected NotifiableItemStackHandler createExportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.inventorySize, IO.OUT);
    }

    @Override
    public void onDrops(List<ItemStack> drops, Player entity) {
        SteamMinerMachine.clearInventory(drops, (IItemTransfer)this.exportItems.storage);
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
            }
            this.exportItemSubs = this.exportItems.addChangedListener(this::updateAutoOutputSubscription);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
            this.exportItemSubs = null;
        }
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacingItems = this.getFrontFacing();
        if (!this.exportItems.isEmpty() && ItemTransferHelper.getItemTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(outputFacingItems), (Direction)outputFacingItems.m_122424_()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::autoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void autoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            this.exportItems.exportToNearby(this.getFrontFacing());
        }
        this.updateAutoOutputSubscription();
    }

    public ModularUI createUI(Player entityPlayer) {
        int rowSize = (int)Math.sqrt(this.inventorySize);
        ModularUI builder = new ModularUI(175, 176, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND_STEAM.get(false)});
        builder.widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT_STEAM.get(false), 7, 94, true));
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int index = y * rowSize + x;
                builder.widget((Widget)new SlotWidget((IItemTransfer)this.exportItems, index, 142 - rowSize * 9 + x * 18, 18 + y * 18, true, false).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT_STEAM.get(false)));
            }
        }
        builder.widget((Widget)new LabelWidget(5, 5, this.getBlockState().m_60734_().m_7705_()));
        builder.widget((Widget)new PredicatedImageWidget(79, 42, 18, 18, (IGuiTexture)GuiTextures.INDICATOR_NO_STEAM.get(this.isHighPressure)).setPredicate(this.recipeLogic::isWaiting));
        builder.widget((Widget)new ImageWidget(7, 16, 105, 75, (IGuiTexture)GuiTextures.DISPLAY_STEAM.get(false)));
        builder.widget((Widget)new ComponentPanelWidget(10, 19, this::addDisplayText).setMaxWidthLimit(84));
        builder.widget((Widget)new ComponentPanelWidget(70, 19, this::addDisplayText2).setMaxWidthLimit(84));
        return builder;
    }

    void addDisplayText(List<Component> textList) {
        int workingArea = IMiner.getWorkingArea(this.getRecipeLogic().getCurrentRadius());
        textList.add((Component)Component.m_237110_((String)"gtceu.machine.miner.startx", (Object[])new Object[]{this.getRecipeLogic().getX()}));
        textList.add((Component)Component.m_237110_((String)"gtceu.machine.miner.starty", (Object[])new Object[]{this.getRecipeLogic().getY()}));
        textList.add((Component)Component.m_237110_((String)"gtceu.machine.miner.startz", (Object[])new Object[]{this.getRecipeLogic().getZ()}));
        textList.add((Component)Component.m_237110_((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{workingArea, workingArea}));
        if (this.getRecipeLogic().isDone()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.done").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
        } else if (this.getRecipeLogic().isWorking()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.working").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
        } else if (!this.isWorkingEnabled()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.work_paused"));
        }
        if (this.getRecipeLogic().isInventoryFull()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.invfull").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
    }

    void addDisplayText2(List<Component> textList) {
        textList.add((Component)Component.m_237110_((String)"gtceu.machine.miner.minex", (Object[])new Object[]{this.getRecipeLogic().getMineX()}));
        textList.add((Component)Component.m_237110_((String)"gtceu.machine.miner.miney", (Object[])new Object[]{this.getRecipeLogic().getMineY()}));
        textList.add((Component)Component.m_237110_((String)"gtceu.machine.miner.minez", (Object[])new Object[]{this.getRecipeLogic().getMineZ()}));
    }

    @Override
    public boolean drainInput(boolean simulate) {
        long resultSteam = this.steamTank.getFluidInTank(0).getAmount() - (long)this.energyPerTick;
        if (!this.isVentingBlocked() && resultSteam >= 0L && resultSteam <= this.steamTank.getTankCapacity(0)) {
            if (!simulate) {
                this.steamTank.drainInternal(this.energyPerTick, false);
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Direction getVentingDirection() {
        return Direction.UP;
    }

    @Override
    public void markVentingComplete() {
        this.needsVenting = false;
    }

    @Override
    public float getVentingDamage() {
        return 0.0f;
    }

    @Override
    @NotNull
    public List<Component> getDataInfo(PortableScannerBehavior.DisplayMode mode) {
        if (mode == PortableScannerBehavior.DisplayMode.SHOW_ALL || mode == PortableScannerBehavior.DisplayMode.SHOW_MACHINE_INFO) {
            int workingArea = IMiner.getWorkingArea(this.getRecipeLogic().getCurrentRadius());
            return Collections.singletonList(Component.m_237110_((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{workingArea, workingArea}));
        }
        return new ArrayList<Component>();
    }

    @Override
    public boolean isNeedsVenting() {
        return this.needsVenting;
    }

    @Override
    public void setNeedsVenting(boolean needsVenting) {
        this.needsVenting = needsVenting;
    }
}

