/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputBoth;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BufferMachine
extends TieredMachine
implements IMachineModifyDrops,
IAutoOutputBoth,
IFancyUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(BufferMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    public static final int TANK_SIZE = 64000;
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacingItems;
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacingFluids;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputItems;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputFluids;
    @Persisted
    protected boolean allowInputFromOutputSideItems;
    @Persisted
    protected boolean allowInputFromOutputSideFluids;
    @Persisted
    protected final NotifiableItemStackHandler inventory;
    @Persisted
    protected final NotifiableFluidTank tank;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription invSubs;
    @Nullable
    protected ISubscription tankSubs;

    public BufferMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier);
        this.inventory = this.createInventory(args);
        this.tank = this.createTank(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public static int getInventorySize(int tier) {
        return (int)Math.pow(tier + 2, 2.0);
    }

    public static int getTankSize(int tier) {
        return tier + 2;
    }

    protected NotifiableItemStackHandler createInventory(Object ... args) {
        return new NotifiableItemStackHandler(this, BufferMachine.getInventorySize(this.tier), IO.BOTH);
    }

    protected NotifiableFluidTank createTank(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, BufferMachine.getTankSize(this.tier), 64000L, IO.BOTH);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
        }
        this.invSubs = this.inventory.addChangedListener(this::updateAutoOutputSubscription);
        this.tankSubs = this.tank.addChangedListener(this::updateAutoOutputSubscription);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.invSubs != null) {
            this.invSubs.unsubscribe();
            this.invSubs = null;
        }
        if (this.tankSubs != null) {
            this.tankSubs.unsubscribe();
            this.tankSubs = null;
        }
    }

    @Override
    public void setAutoOutputFluids(boolean allow) {
        this.autoOutputFluids = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void setOutputFacingFluids(@Nullable Direction outputFacing) {
        this.outputFacingFluids = outputFacing;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void setAutoOutputItems(boolean allow) {
        this.autoOutputItems = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void setOutputFacingItems(@Nullable Direction outputFacing) {
        this.outputFacingItems = outputFacing;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacingItems = this.getOutputFacingItems();
        Direction outputFacingFluids = this.getOutputFacingFluids();
        if (this.isAutoOutputItems() && !this.inventory.isEmpty() && outputFacingItems != null && ItemTransferHelper.getItemTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(outputFacingItems), (Direction)outputFacingItems.m_122424_()) != null || this.isAutoOutputFluids() && !this.tank.isEmpty() && outputFacingFluids != null && FluidTransferHelper.getFluidTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(outputFacingFluids), (Direction)outputFacingFluids.m_122424_()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::autoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void autoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputFluids() && this.getOutputFacingFluids() != null) {
                this.tank.exportToNearby(this.getOutputFacingFluids());
            }
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.inventory.exportToNearby(this.getOutputFacingItems());
            }
        }
        this.updateAutoOutputSubscription();
    }

    @Override
    public Widget createUIWidget() {
        int y;
        int invTier = BufferMachine.getTankSize(this.tier);
        WidgetGroup group = new WidgetGroup(0, 0, 18 * (invTier + 1) + 16, 18 * invTier + 16);
        WidgetGroup container = new WidgetGroup(4, 4, 18 * (invTier + 1) + 8, 18 * invTier + 8);
        int index = 0;
        for (y = 0; y < invTier; ++y) {
            for (int x = 0; x < invTier; ++x) {
                container.addWidget((Widget)new SlotWidget((IItemTransfer)this.getInventory().storage, index++, 4 + x * 18, 4 + y * 18, true, true).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
            }
        }
        index = 0;
        for (y = 0; y < invTier; ++y) {
            container.addWidget((Widget)new TankWidget((IFluidStorage)this.tank.getStorages()[index++], 4 + invTier * 18, 4 + y * 18, true, true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Override
    public ResourceTexture sideTips(Player player, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.SCREWDRIVER) && (side == this.getOutputFacingItems() || side == this.getOutputFacingFluids())) {
            return GuiTextures.TOOL_ALLOW_INPUT;
        }
        return super.sideTips(player, toolTypes, side);
    }

    @Override
    public void onDrops(List<ItemStack> drops, Player entity) {
        BufferMachine.clearInventory(drops, (IItemTransfer)this.inventory.storage);
    }

    @Override
    public Direction getOutputFacingItems() {
        return this.outputFacingItems;
    }

    @Override
    public Direction getOutputFacingFluids() {
        return this.outputFacingFluids;
    }

    @Override
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    @Override
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSideItems;
    }

    @Override
    public void setAllowInputFromOutputSideItems(boolean allowInputFromOutputSideItems) {
        this.allowInputFromOutputSideItems = allowInputFromOutputSideItems;
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return this.allowInputFromOutputSideFluids;
    }

    @Override
    public void setAllowInputFromOutputSideFluids(boolean allowInputFromOutputSideFluids) {
        this.allowInputFromOutputSideFluids = allowInputFromOutputSideFluids;
    }

    public NotifiableItemStackHandler getInventory() {
        return this.inventory;
    }

    public NotifiableFluidTank getTank() {
        return this.tank;
    }
}

