/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CreativeComputationProviderMachine
extends MetaMachine
implements IUIMachine,
IOpticalComputationProvider {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CreativeComputationProviderMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private int maxCWUt;
    private int lastRequestedCWUt;
    private int requestedCWUPerSec;
    @Persisted
    private boolean active;
    @Nullable
    private TickableSubscription computationSubs;

    public CreativeComputationProviderMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.updateComputationSubscription();
    }

    protected void updateComputationSubscription() {
        if (this.active) {
            this.computationSubs = this.subscribeServerTick(this::updateComputationTick);
        } else if (this.computationSubs != null) {
            this.computationSubs.unsubscribe();
            this.computationSubs = null;
            this.lastRequestedCWUt = 0;
            this.requestedCWUPerSec = 0;
        }
    }

    protected void updateComputationTick() {
        if (this.getOffsetTimer() % 20L == 0L) {
            this.lastRequestedCWUt = this.requestedCWUPerSec / 20;
            this.requestedCWUPerSec = 0;
        }
    }

    @Override
    public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        int requestedCWUt;
        seen.add(this);
        int n = requestedCWUt = this.active ? Math.min(cwut, this.maxCWUt) : 0;
        if (!simulate) {
            this.requestedCWUPerSec += requestedCWUt;
        }
        return requestedCWUt;
    }

    @Override
    public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.active ? this.maxCWUt : 0;
    }

    @Override
    public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return true;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.updateComputationSubscription();
    }

    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(140, 95, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new LabelWidget(7, 7, "CWUt")).widget((Widget)new TextFieldWidget(9, 20, 122, 16, () -> String.valueOf(this.maxCWUt), value -> {
            this.maxCWUt = Integer.parseInt(value);
        }).setNumbersOnly(0, Integer.MAX_VALUE)).widget((Widget)new LabelWidget(7, 42, "gtceu.creative.computation.average")).widget((Widget)new LabelWidget(7, 54, () -> String.valueOf(this.lastRequestedCWUt))).widget((Widget)new SwitchWidget(9, 66, 122, 20, (clickData, value) -> this.setActive((boolean)value)).setSupplier(this::isActive).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.off")}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.on")})));
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public boolean isActive() {
        return this.active;
    }
}

