/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomFluidWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidActionResult;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class QuantumTankMachine
extends TieredMachine
implements IAutoOutputFluid,
IInteractedMachine,
IControllable,
IDropSaveMachine,
IFancyUIMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(QuantumTankMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacingFluids;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputFluids;
    @Persisted
    protected boolean allowInputFromOutputSideFluids;
    private final long maxStoredFluids;
    @Persisted
    @DropSaved
    protected final NotifiableFluidTank cache;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription exportFluidSubs;
    @Persisted
    @DescSynced
    @DropSaved
    protected FluidStack stored = FluidStack.empty();
    @Persisted
    private boolean isVoiding;

    public QuantumTankMachine(IMachineBlockEntity holder, int tier, long maxStoredFluids, Object ... args) {
        super(holder, tier);
        this.outputFacingFluids = this.getFrontFacing().m_122424_();
        this.maxStoredFluids = maxStoredFluids;
        this.cache = this.createCacheFluidHandler(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createCacheFluidHandler(Object ... args) {
        return new NotifiableFluidTank(this, 1, this.maxStoredFluids, IO.BOTH){

            @Override
            public long fill(FluidStack resource, boolean simulate, boolean notifyChanges) {
                return this.handleVoiding(super.fill(resource, simulate, notifyChanges), resource);
            }

            @Override
            public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
                return this.handleVoiding(super.fill(tank, resource, simulate, notifyChanges), resource);
            }

            @Override
            public long fill(FluidStack resource, boolean simulate) {
                return this.handleVoiding(super.fill(resource, simulate), resource);
            }

            private long handleVoiding(long filled, FluidStack resource) {
                if (filled < resource.getAmount() && QuantumTankMachine.this.isVoiding && this.isFluidValid(0, resource)) {
                    return resource.getAmount();
                }
                return filled;
            }
        };
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.stored = this.cache.getFluidInTank(0);
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
        }
        this.exportFluidSubs = this.cache.addChangedListener(this::onFluidChanged);
    }

    private void onFluidChanged() {
        if (!this.isRemote()) {
            this.stored = this.cache.getFluidInTank(0);
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.exportFluidSubs != null) {
            this.exportFluidSubs.unsubscribe();
            this.exportFluidSubs = null;
        }
    }

    @Override
    public boolean savePickClone() {
        return false;
    }

    @Override
    public void setAutoOutputFluids(boolean allow) {
        this.autoOutputFluids = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void setOutputFacingFluids(@Nullable Direction outputFacing) {
        this.outputFacingFluids = outputFacing;
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isAutoOutputFluids();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.setAutoOutputFluids(isWorkingAllowed);
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacing = this.getOutputFacingFluids();
        if (this.isAutoOutputFluids() && !this.cache.isEmpty() && outputFacing != null && FluidTransferHelper.getFluidTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(outputFacing), (Direction)outputFacing.m_122424_()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputFluids() && this.getOutputFacingFluids() != null) {
                this.cache.exportToNearby(this.getOutputFacingFluids());
            }
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        if (facing == this.outputFacingFluids) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack currentStack = player.m_21205_();
        if (hit.m_82434_() == this.getFrontFacing() && !currentStack.m_41619_()) {
            IFluidTransfer handler = FluidTransferHelper.getFluidTransfer((Player)player, (InteractionHand)InteractionHand.MAIN_HAND);
            FluidStorage fluidTank = this.cache.getStorages()[0];
            if (handler != null && !this.isRemote()) {
                FluidActionResult result;
                if (this.cache.getStorages()[0].getFluidAmount() > 0L) {
                    FluidStack initialFluid = fluidTank.getFluid();
                    FluidActionResult result2 = FluidTransferHelper.tryFillContainer((ItemStack)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)false);
                    if (result2.isSuccess()) {
                        ItemStack remainingStack = FluidTransferHelper.tryFillContainer((ItemStack)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)true).getResult();
                        currentStack.m_41774_(1);
                        SoundEvent soundevent = FluidHelper.getFillSound((FluidStack)initialFluid);
                        if (soundevent != null) {
                            player.m_9236_().m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        if (!remainingStack.m_41619_() && !player.m_36356_(remainingStack)) {
                            Block.m_49840_((Level)player.m_9236_(), (BlockPos)player.m_20097_(), (ItemStack)remainingStack);
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
                if ((result = FluidTransferHelper.tryEmptyContainer((ItemStack)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess()) {
                    ItemStack remainingStack = FluidTransferHelper.tryEmptyContainer((ItemStack)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)true).getResult();
                    currentStack.m_41774_(1);
                    SoundEvent soundevent = FluidHelper.getEmptySound((FluidStack)fluidTank.getFluid());
                    if (soundevent != null) {
                        player.m_9236_().m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    if (!remainingStack.m_41619_() && !player.m_150109_().m_36054_(remainingStack)) {
                        Block.m_49840_((Level)player.m_9236_(), (BlockPos)player.m_20097_(), (ItemStack)remainingStack);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return IInteractedMachine.super.onUse(state, world, pos, player, hand, hit);
    }

    @Override
    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!playerIn.m_6144_() && !this.isRemote()) {
            ItemStack tool = playerIn.m_21120_(hand);
            if (tool.m_41773_() >= tool.m_41776_()) {
                return InteractionResult.PASS;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return InteractionResult.PASS;
            }
            if (gridSide != this.getOutputFacingFluids()) {
                this.setOutputFacingFluids(gridSide);
            } else {
                this.setOutputFacingFluids(null);
            }
            return InteractionResult.CONSUME;
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!this.isRemote()) {
            if (gridSide == this.getOutputFacingFluids()) {
                if (this.isAllowInputFromOutputSideFluids()) {
                    this.setAllowInputFromOutputSideFluids(false);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.basic.input_from_output_side.disallow").m_7220_((Component)Component.m_237115_((String)"gtceu.creative.tank.fluid")));
                } else {
                    this.setAllowInputFromOutputSideFluids(true);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.basic.input_from_output_side.allow").m_7220_((Component)Component.m_237115_((String)"gtceu.creative.tank.fluid")));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.onScrewdriverClick(playerIn, hand, gridSide, hitResult);
    }

    public boolean isLocked() {
        return this.cache.isLocked();
    }

    protected void setLocked(boolean locked) {
        if (!this.stored.isEmpty() && locked) {
            FluidStack copied = this.stored.copy();
            copied.setAmount(this.cache.getLockedFluid().getCapacity());
            this.cache.setLocked(true, copied);
        } else if (!locked) {
            this.cache.setLocked(false);
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 90, 63);
        group.addWidget((Widget)new ImageWidget(4, 4, 82, 55, (IGuiTexture)GuiTextures.DISPLAY)).addWidget((Widget)new LabelWidget(8, 8, "gtceu.gui.fluid_amount")).addWidget((Widget)new LabelWidget(8, 18, () -> String.valueOf(this.cache.getFluidInTank(0).getAmount() / (FluidHelper.getBucket() / 1000L))).setTextColor(-1).setDropShadow(true)).addWidget((Widget)new TankWidget((IFluidStorage)this.cache.getStorages()[0], 68, 23, true, true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT)).addWidget((Widget)new PhantomFluidWidget((IFluidTransfer)this.cache.getLockedFluid(), 0, 68, 41, 18, 18, () -> this.cache.getLockedFluid().getFluid(), fluid -> this.cache.getLockedFluid().setFluid(fluid)).setShowAmount(false).setBackground((IGuiTexture)ColorPattern.T_GRAY.rectTexture())).addWidget((Widget)new ToggleButtonWidget(4, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_FLUID_OUTPUT, this::isAutoOutputFluids, this::setAutoOutputFluids).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_auto_output.tooltip")).addWidget((Widget)new ToggleButtonWidget(22, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_LOCK, this::isLocked, this::setLocked).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_lock.tooltip")).addWidget((Widget)new ToggleButtonWidget(40, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_VOID, this::isVoiding, this::setVoiding).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_voiding_partial.tooltip"));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    @Override
    public ResourceTexture sideTips(Player player, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (!(player.m_6144_() || this.hasFrontFacing() && side == this.getFrontFacing())) {
                return GuiTextures.TOOL_IO_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SCREWDRIVER) && side == this.getOutputFacingFluids()) {
            return GuiTextures.TOOL_ALLOW_INPUT;
        }
        return super.sideTips(player, toolTypes, side);
    }

    @Override
    public Direction getOutputFacingFluids() {
        return this.outputFacingFluids;
    }

    @Override
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return this.allowInputFromOutputSideFluids;
    }

    @Override
    public void setAllowInputFromOutputSideFluids(boolean allowInputFromOutputSideFluids) {
        this.allowInputFromOutputSideFluids = allowInputFromOutputSideFluids;
    }

    public long getMaxStoredFluids() {
        return this.maxStoredFluids;
    }

    public NotifiableFluidTank getCache() {
        return this.cache;
    }

    public FluidStack getStored() {
        return this.stored;
    }

    public boolean isVoiding() {
        return this.isVoiding;
    }

    public void setVoiding(boolean isVoiding) {
        this.isVoiding = isVoiding;
    }
}

