/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.data.DimensionMarker;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.io.Serializable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class DimensionCondition
extends RecipeCondition {
    public static final DimensionCondition INSTANCE = new DimensionCondition();
    private ResourceLocation dimension = new ResourceLocation("dummy");

    public DimensionCondition(ResourceLocation dimension) {
        this.dimension = dimension;
    }

    @Override
    public String getType() {
        return "dimension";
    }

    @Override
    public boolean isOr() {
        return true;
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.dimension.tooltip", (Object[])new Object[]{this.dimension});
    }

    public SlotWidget setupDimensionMarkers(int xOffset, int yOffset) {
        DimensionMarker dimMarker = GTRegistries.DIMENSION_MARKERS.getOrDefault(this.dimension, new DimensionMarker(99, () -> Blocks.f_50375_, this.dimension.toString()));
        ItemStack icon = dimMarker.getIcon();
        ItemStackTransfer transfer = new ItemStackTransfer(1);
        SlotWidget dimSlot = new SlotWidget((IItemTransfer)transfer, 0, xOffset, yOffset, false, false).setIngredientIO(IngredientIO.INPUT);
        transfer.setStackInSlot(0, icon);
        if (ConfigHolder.INSTANCE.compat.showDimensionTier) {
            dimSlot.setOverlay((IGuiTexture)new TextTexture("T" + (Serializable)(dimMarker.tier >= 99 ? "?" : Integer.valueOf(dimMarker.tier))).scale(0.75f).transform(-3.0f, 5.0f));
        }
        return dimSlot;
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    @Override
    public boolean test(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        Level level = recipeLogic.machine.self().getLevel();
        return level != null && this.dimension.equals((Object)level.m_46472_().m_135782_());
    }

    @Override
    public RecipeCondition createTemplate() {
        return new DimensionCondition();
    }

    @Override
    @NotNull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("dim", this.dimension.toString());
        return config;
    }

    @Override
    public RecipeCondition deserialize(@NotNull JsonObject config) {
        super.deserialize(config);
        this.dimension = new ResourceLocation(GsonHelper.m_13851_((JsonObject)config, (String)"dim", (String)"dummy"));
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.dimension = new ResourceLocation(buf.m_130277_());
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130070_(this.dimension.toString());
    }

    public DimensionCondition() {
    }
}

