/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.data.GTMedicalConditions;
import com.gregtechceu.gtceu.config.ConfigHolder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EnvironmentalHazardCondition
extends RecipeCondition {
    public static final EnvironmentalHazardCondition INSTANCE = new EnvironmentalHazardCondition();
    private MedicalCondition condition = GTMedicalConditions.CARBON_MONOXIDE_POISONING;

    @Override
    public String getType() {
        return "environmental_hazard";
    }

    @Override
    public Component getTooltips() {
        return this.isReverse ? Component.m_237110_((String)"gtceu.recipe.environmental_hazard.reverse", (Object[])new Object[]{Component.m_237115_((String)("gtceu.medical_condition." + this.condition.name))}) : Component.m_237110_((String)"gtceu.recipe.environmental_hazard", (Object[])new Object[]{Component.m_237115_((String)("gtceu.medical_condition." + this.condition.name))});
    }

    @Override
    public boolean test(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        if (!ConfigHolder.INSTANCE.gameplay.hazardsEnabled) {
            return true;
        }
        Level level = recipeLogic.getMachine().getLevel();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        EnvironmentalHazardSavedData savedData = EnvironmentalHazardSavedData.getOrCreate(serverLevel);
        EnvironmentalHazardSavedData.HazardZone zone = savedData.getZoneByContainedPos(recipeLogic.getMachine().getPos());
        return zone != null && zone.strength() > 0.0f;
    }

    @Override
    @NotNull
    public JsonObject serialize() {
        JsonObject value = super.serialize();
        value.addProperty("condition", this.condition.name);
        return value;
    }

    @Override
    public RecipeCondition deserialize(@NotNull JsonObject config) {
        super.deserialize(config);
        this.condition = MedicalCondition.CONDITIONS.get(GsonHelper.m_13906_((JsonObject)config, (String)"condition"));
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130070_(this.condition.name);
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.condition = MedicalCondition.CONDITIONS.get(buf.m_130277_());
        return this;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new EnvironmentalHazardCondition();
    }

    public EnvironmentalHazardCondition() {
    }

    public EnvironmentalHazardCondition(MedicalCondition condition) {
        this.condition = condition;
    }

    public MedicalCondition getCondition() {
        return this.condition;
    }
}

