/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.unification.material;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.gregtechceu.gtceu.common.unification.material.MaterialRegistryManager;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class MaterialRegistryImpl
extends MaterialRegistry {
    private static int networkIdCounter;
    private final int networkId = networkIdCounter++;
    private final String modid;
    private boolean isRegistryClosed = false;
    private Material fallbackMaterial = null;

    protected MaterialRegistryImpl(@NotNull String modid) {
        super(modid);
        this.modid = modid;
    }

    @Override
    public void register(Material material) {
        this.register(material.getName(), material);
    }

    @Override
    public void register(@NotNull String key, @NotNull Material value) {
        if (this.isRegistryClosed) {
            GTCEu.LOGGER.error("Materials cannot be registered in the PostMaterialEvent (or after)! Must be added in the MaterialEvent. Skipping material {}...", (Object)key);
            return;
        }
        super.register(key, value);
    }

    @Override
    @NotNull
    public Collection<Material> getAllMaterials() {
        return Collections.unmodifiableCollection(this.registry.values());
    }

    @Override
    public void setFallbackMaterial(@NotNull Material material) {
        this.fallbackMaterial = material;
    }

    @Override
    @NotNull
    public Material getFallbackMaterial() {
        if (this.fallbackMaterial == null) {
            this.fallbackMaterial = MaterialRegistryManager.getInstance().getDefaultFallback();
        }
        return this.fallbackMaterial;
    }

    @Override
    public int getNetworkId() {
        return this.networkId;
    }

    @Override
    @NotNull
    public String getModid() {
        return this.modid;
    }

    public void closeRegistry() {
        this.isRegistryClosed = true;
    }
}

