/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorage;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.forge.GTClientFluidTypeExtensions;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.BlockBehaviourAccessor;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;

public class MixinHelpers {
    private static final VanillaBlockLoot BLOCK_LOOT = new VanillaBlockLoot();

    public static <T> void generateGTDynamicTags(Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagMap, Registry<T> registry) {
        if (registry == BuiltInRegistries.f_257033_) {
            ChemicalHelper.UNIFICATION_ENTRY_ITEM.forEach((entry, itemLikes) -> {
                if (itemLikes.isEmpty()) {
                    return;
                }
                Material material = entry.material;
                if (material != null) {
                    TagKey<Item>[] materialTags;
                    for (TagKey<Item> materialTag : materialTags = entry.tagPrefix.getAllItemTags(material)) {
                        ArrayList tags = new ArrayList();
                        itemLikes.forEach(item -> tags.add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)((ItemLike)item.get()).m_5456_())), "GTCEu Custom Tags")));
                        tagMap.computeIfAbsent(materialTag.f_203868_(), path -> new ArrayList()).addAll(tags);
                    }
                }
            });
            GTItems.TOOL_ITEMS.rowMap().forEach((material, map) -> map.forEach((type, item) -> {
                if (item != null) {
                    TagLoader.EntryWithSource entry = new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)item.getId()), "GTCEu Custom Tags");
                    for (TagKey<Item> tag : type.itemTags) {
                        tagMap.computeIfAbsent(tag.f_203868_(), path -> new ArrayList()).add(entry);
                    }
                }
            }));
        } else if (registry == BuiltInRegistries.f_256975_) {
            GTBlocks.MATERIAL_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockTags(tagMap, prefix, map));
            GTBlocks.CABLE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockTags(tagMap, prefix, map));
            GTBlocks.FLUID_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockTags(tagMap, prefix, map));
            GTBlocks.ITEM_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockTags(tagMap, prefix, map));
            GTRegistries.MACHINES.forEach(machine -> {
                ResourceLocation id = machine.getId();
                tagMap.computeIfAbsent(GTToolType.WRENCH.harvestTags.get(0).f_203868_(), path -> new ArrayList()).add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)id), "GTCEu Custom Tags"));
                if (!ConfigHolder.INSTANCE.machines.requireGTToolsForBlocks) {
                    tagMap.computeIfAbsent(BlockTags.f_144282_.f_203868_(), path -> new ArrayList()).add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)id), "GTCEu Custom Tags"));
                }
            });
            GTBlocks.ALL_FUSION_CASINGS.forEach((casingType, block) -> {
                ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)((Block)block.get()));
                tagMap.computeIfAbsent(CustomTags.TOOL_TIERS[casingType.getHarvestLevel()].f_203868_(), path -> new ArrayList()).add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)blockId), "GTCEu Custom Tags"));
            });
        } else if (registry == BuiltInRegistries.f_257020_) {
            for (Material material2 : GTCEuAPI.materialManager.getRegisteredMaterials()) {
                if (!material2.hasProperty(PropertyKey.FLUID)) continue;
                FluidProperty property = material2.getProperty(PropertyKey.FLUID);
                for (FluidStorageKey key : FluidStorageKey.allKeys()) {
                    Fluid fluid = property.getStorage().get(key);
                    if (fluid == null) continue;
                    ChemicalHelper.FLUID_MATERIAL.put(fluid, material2);
                    ResourceLocation fluidId = BuiltInRegistries.f_257020_.m_7981_((Object)fluid);
                    tagMap.computeIfAbsent(TagUtil.createFluidTag(fluidId.m_135815_()).f_203868_(), path -> new ArrayList()).add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)fluidId), "GTCEu Custom Tags"));
                }
            }
        }
    }

    public static void addMaterialBlockTags(Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagMap, TagPrefix prefix, Map<Material, ? extends BlockEntry<? extends Block>> map) {
        if (!prefix.miningToolTag().isEmpty()) {
            map.forEach((material, block) -> {
                tagMap.computeIfAbsent(CustomTags.TOOL_TIERS[material.getBlockHarvestLevel()].f_203868_(), path -> new ArrayList()).add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)block.getId()), "GTCEu Custom Tags"));
                TagLoader.EntryWithSource entry = new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)block.getId()), "GTCEu Custom Tags");
                if (material.hasProperty(PropertyKey.WOOD)) {
                    tagMap.computeIfAbsent(BlockTags.f_144280_.f_203868_(), path -> new ArrayList()).add(entry);
                } else {
                    for (TagKey<Block> tag : prefix.miningToolTag()) {
                        tagMap.computeIfAbsent(tag.f_203868_(), path -> new ArrayList()).add(entry);
                    }
                    if (!ConfigHolder.INSTANCE.machines.requireGTToolsForBlocks) {
                        tagMap.computeIfAbsent(BlockTags.f_144282_.f_203868_(), path -> new ArrayList()).add(entry);
                    }
                }
            });
        }
        map.forEach((material, block) -> {
            for (TagKey<Block> blockTag : prefix.getAllBlockTags((Material)material)) {
                tagMap.computeIfAbsent(blockTag.f_203868_(), path -> new ArrayList()).add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)block.getId()), "GTCEu Custom Tags"));
            }
        });
    }

    public static void generateGTDynamicLoot(Map<ResourceLocation, LootTable> lootTables) {
        GTBlocks.MATERIAL_BLOCKS.rowMap().forEach((prefix, map) -> {
            if (TagPrefix.ORES.containsKey(prefix)) {
                TagPrefix.OreType type = TagPrefix.ORES.get(prefix);
                map.forEach((material, blockEntry) -> {
                    ItemStack dropItem;
                    ResourceLocation lootTableId = new ResourceLocation(blockEntry.getId().m_135827_(), "blocks/" + blockEntry.getId().m_135815_());
                    Block block = (Block)blockEntry.get();
                    if (!type.shouldDropAsItem() && !ConfigHolder.INSTANCE.worldgen.allUniqueStoneTypes) {
                        TagPrefix orePrefix = type.isDoubleDrops() ? TagPrefix.oreNetherrack : TagPrefix.ore;
                        block = ChemicalHelper.getBlock(orePrefix, material);
                    }
                    if ((dropItem = ChemicalHelper.get(TagPrefix.rawOre, material)).m_41619_()) {
                        dropItem = ChemicalHelper.get(TagPrefix.gem, material);
                    }
                    if (dropItem.m_41619_()) {
                        dropItem = ChemicalHelper.get(TagPrefix.dust, material);
                    }
                    int oreMultiplier = type.isDoubleDrops() ? 2 : 1;
                    LootTable.Builder builder = BlockLootSubProvider.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)BLOCK_LOOT.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)dropItem.m_41720_()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)oreMultiplier))))));
                    Supplier<Material> outputDustMat = type.material();
                    LootPool.Builder pool = LootPool.m_79043_();
                    boolean isEmpty = true;
                    for (MaterialStack secondaryMaterial : prefix.secondaryMaterials()) {
                        if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                        ItemStack dustStack = ChemicalHelper.getGem(secondaryMaterial);
                        pool.m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)dustStack.m_41720_()).m_79080_(BlockLootSubProvider.f_244217_)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)).m_79078_((LootItemFunction.Builder)LimitCount.m_165215_((IntRange)IntRange.m_165011_((int)0, (int)2))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()));
                        isEmpty = false;
                    }
                    if (!isEmpty) {
                        builder.m_79161_(pool);
                    }
                    lootTables.put(lootTableId, builder.m_79165_(LootContextParamSets.f_81421_).m_79167_());
                    ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
                });
            } else {
                MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map);
            }
        });
        GTBlocks.CABLE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map));
        GTBlocks.FLUID_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map));
        GTBlocks.ITEM_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map));
        GTBlocks.SURFACE_ROCK_BLOCKS.forEach((material, blockEntry) -> {
            ResourceLocation lootTableId = new ResourceLocation(blockEntry.getId().m_135827_(), "blocks/" + blockEntry.getId().m_135815_());
            LootTable.Builder builder = BLOCK_LOOT.m_245765_((ItemLike)ChemicalHelper.get(TagPrefix.dustTiny, material).m_41720_(), (NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f)).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_));
            lootTables.put(lootTableId, builder.m_79165_(LootContextParamSets.f_81421_).m_79167_());
            ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
        });
        GTRegistries.MACHINES.forEach(machine -> {
            Block block = machine.getBlock();
            ResourceLocation id = machine.getId();
            ResourceLocation lootTableId = new ResourceLocation(id.m_135827_(), "blocks/" + id.m_135815_());
            ((BlockBehaviourAccessor)block).setDrops(lootTableId);
            lootTables.put(lootTableId, BLOCK_LOOT.m_247033_((ItemLike)block).m_79165_(LootContextParamSets.f_81421_).m_79167_());
        });
    }

    public static void addMaterialBlockLootTables(Map<ResourceLocation, LootTable> lootTables, TagPrefix prefix, Map<Material, ? extends BlockEntry<? extends Block>> map) {
        map.forEach((material, blockEntry) -> {
            ResourceLocation lootTableId = new ResourceLocation(blockEntry.getId().m_135827_(), "blocks/" + blockEntry.getId().m_135815_());
            ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
            lootTables.put(lootTableId, BLOCK_LOOT.m_247033_((ItemLike)blockEntry.get()).m_79165_(LootContextParamSets.f_81421_).m_79167_());
        });
    }

    public static void addFluidTexture(Material material, FluidStorage.FluidEntry value) {
        IClientFluidTypeExtensions extensions;
        if (value != null && (extensions = IClientFluidTypeExtensions.of((Fluid)value.getFluid().get())) instanceof GTClientFluidTypeExtensions) {
            GTClientFluidTypeExtensions gtExtensions = (GTClientFluidTypeExtensions)extensions;
            if (value.getBuilder() != null) {
                gtExtensions.setFlowingTexture(value.getBuilder().flowing());
                gtExtensions.setStillTexture(value.getBuilder().still());
            }
        }
    }
}

