/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WoodTypeEntry {
    @NotNull
    public final String modid;
    @NotNull
    public final String woodName;
    @NotNull
    public final TagKey<Item> logTag;
    @Nullable
    public final Item log;
    @Nullable
    public final Item strippedLog;
    @Nullable
    public final Item wood;
    @Nullable
    public final Item strippedWood;
    public final boolean removeCharcoalRecipe;
    public final boolean addCharcoalRecipe;
    @NotNull
    public final Item planks;
    @Nullable
    public final String planksRecipeName;
    @Nullable
    public final Item door;
    @Nullable
    public final String doorRecipeName;
    @Nullable
    public final Item trapdoor;
    @Nullable
    public final String trapdoorRecipeName;
    @Nullable
    public final Item slab;
    @Nullable
    public final String slabRecipeName;
    public final boolean addSlabCraftingRecipe;
    public final Item fence;
    @Nullable
    public final String fenceRecipeName;
    @Nullable
    public final Item fenceGate;
    @Nullable
    public final String fenceGateRecipeName;
    @Nullable
    public final Item stairs;
    @Nullable
    public final String stairsRecipeName;
    public final boolean addStairsCraftingRecipe;
    @Nullable
    public final Item boat;
    @Nullable
    public final String boatRecipeName;
    @Nullable
    public final Item chestBoat;
    @Nullable
    public final String chestBoatRecipeName;
    public final Material material;
    public final boolean addLogOreDict;
    public final boolean addPlanksOreDict;
    public final boolean addDoorsOreDict;
    public final boolean addSlabsOreDict;
    public final boolean addFencesOreDict;
    public final boolean addFenceGatesOreDict;
    public final boolean addStairsOreDict;
    public final boolean addPlanksUnificationInfo;
    public final boolean addDoorsUnificationInfo;
    public final boolean addSlabsUnificationInfo;
    public final boolean addFencesUnificationInfo;
    public final boolean addFenceGatesUnificationInfo;
    public final boolean addStairsUnificationInfo;
    public final boolean addBoatsUnificationInfo;
    public final boolean addChestBoatsUnificationInfo;
    public final boolean generateLogToPlankRecipe;

    private WoodTypeEntry(@NotNull String modid, @NotNull String woodName, @NotNull TagKey<Item> logTag, @Nullable Item log, @Nullable Item strippedLog, @Nullable Item wood, @Nullable Item strippedWood, boolean removeCharcoalRecipe, boolean addCharcoalRecipe, @NotNull Item planks, @Nullable String planksRecipeName, @Nullable Item door, @Nullable String doorRecipeName, @Nullable Item trapdoor, @Nullable String trapdoorRecipeName, @Nullable Item slab, @Nullable String slabRecipeName, boolean addSlabCraftingRecipe, @Nullable Item fence, @Nullable String fenceRecipeName, @Nullable Item fenceGate, @Nullable String fenceGateRecipeName, @Nullable Item stairs, @Nullable String stairsRecipeName, boolean addStairsCraftingRecipe, @Nullable Item boat, @Nullable String boatRecipeName, @Nullable Item chestBoat, @Nullable String chestBoatRecipeName, @Nullable Material material, boolean addLogOreDict, boolean addPlanksOreDict, boolean addDoorsOreDict, boolean addSlabsOreDict, boolean addFencesOreDict, boolean addFenceGatesOreDict, boolean addStairsOreDict, boolean addPlanksUnificationInfo, boolean addDoorsUnificationInfo, boolean addSlabsUnificationInfo, boolean addFencesUnificationInfo, boolean addFenceGatesUnificationInfo, boolean addStairsUnificationInfo, boolean addBoatsUnificationInfo, boolean addChestBoatsUnificationInfo, boolean generateLogToPlankRecipe) {
        this.modid = modid;
        this.woodName = woodName;
        this.logTag = logTag;
        this.log = log;
        this.strippedLog = strippedLog;
        this.wood = wood;
        this.strippedWood = strippedWood;
        this.removeCharcoalRecipe = removeCharcoalRecipe;
        this.addCharcoalRecipe = addCharcoalRecipe;
        this.planks = planks;
        this.planksRecipeName = planksRecipeName;
        this.door = door;
        this.doorRecipeName = doorRecipeName;
        this.trapdoor = trapdoor;
        this.trapdoorRecipeName = trapdoorRecipeName;
        this.slab = slab;
        this.slabRecipeName = slabRecipeName;
        this.addSlabCraftingRecipe = addSlabCraftingRecipe;
        this.fence = fence;
        this.fenceRecipeName = fenceRecipeName;
        this.fenceGate = fenceGate;
        this.fenceGateRecipeName = fenceGateRecipeName;
        this.stairs = stairs;
        this.stairsRecipeName = stairsRecipeName;
        this.addStairsCraftingRecipe = addStairsCraftingRecipe;
        this.boat = boat;
        this.boatRecipeName = boatRecipeName;
        this.chestBoat = chestBoat;
        this.chestBoatRecipeName = chestBoatRecipeName;
        this.material = material != null ? material : GTMaterials.Wood;
        this.addLogOreDict = addLogOreDict;
        this.addPlanksOreDict = addPlanksOreDict;
        this.addDoorsOreDict = addDoorsOreDict;
        this.addSlabsOreDict = addSlabsOreDict;
        this.addFencesOreDict = addFencesOreDict;
        this.addFenceGatesOreDict = addFenceGatesOreDict;
        this.addStairsOreDict = addStairsOreDict;
        this.addPlanksUnificationInfo = addPlanksUnificationInfo;
        this.addDoorsUnificationInfo = addDoorsUnificationInfo;
        this.addSlabsUnificationInfo = addSlabsUnificationInfo;
        this.addFencesUnificationInfo = addFencesUnificationInfo;
        this.addFenceGatesUnificationInfo = addFenceGatesUnificationInfo;
        this.addStairsUnificationInfo = addStairsUnificationInfo;
        this.addBoatsUnificationInfo = addBoatsUnificationInfo;
        this.addChestBoatsUnificationInfo = addChestBoatsUnificationInfo;
        this.generateLogToPlankRecipe = generateLogToPlankRecipe;
    }

    @NotNull
    public TagKey<Item> getStick() {
        if (this.material == GTMaterials.Wood) {
            return Tags.Items.RODS_WOODEN;
        }
        return ChemicalHelper.getTag(TagPrefix.rod, this.material);
    }

    public Item[] getLogs() {
        return new Item[]{this.log, this.wood, this.strippedWood, this.strippedLog};
    }

    public static class Builder {
        private final String modid;
        private final String woodName;
        private TagKey<Item> logTag = null;
        private Item log = null;
        private Item strippedLog = null;
        private Item wood = null;
        private Item strippedWood = null;
        private boolean removeCharcoalRecipe;
        private boolean addCharcoalRecipe;
        private Item planks = null;
        private String planksRecipeName;
        private Item door = null;
        private String doorRecipeName;
        private Item trapdoor = null;
        private String trapdoorRecipeName;
        private Item slab = null;
        private String slabRecipeName;
        private boolean addSlabsCraftingRecipe;
        private Item fence = null;
        private String fenceRecipeName;
        private Item fenceGate = null;
        private String fenceGateRecipeName;
        private Item stairs = null;
        private String stairsRecipeName;
        private boolean addStairsCraftingRecipe;
        private Item boat = null;
        private String boatRecipeName;
        private Item chestBoat = null;
        private String chestBoatRecipeName;
        @Nullable
        private Material material = null;
        private boolean addLogOreDict;
        private boolean addPlanksOreDict;
        private boolean addDoorsOreDict;
        private boolean addSlabsOreDict;
        private boolean addFencesOreDict;
        private boolean addFenceGatesOreDict;
        private boolean addStairsOreDict;
        private boolean addPlanksUnificationInfo;
        private boolean addDoorsUnificationInfo;
        private boolean addSlabsUnificationInfo;
        private boolean addFencesUnificationInfo;
        private boolean addFenceGatesUnificationInfo;
        private boolean addStairsUnificationInfo;
        private boolean addBoatsUnificationInfo;
        private boolean addChestBoatsUnificationInfo;
        private boolean generateLogToPlankRecipe = true;

        public Builder(@NotNull String modid, @NotNull String woodName) {
            Preconditions.checkArgument((!modid.isEmpty() ? 1 : 0) != 0, (Object)"Modid cannot be empty.");
            Preconditions.checkArgument((!woodName.isEmpty() ? 1 : 0) != 0, (Object)"Wood name cannot be empty.");
            this.modid = modid;
            this.woodName = woodName;
        }

        public Builder logTag(@NotNull TagKey<Item> logTag) {
            this.logTag = logTag;
            return this;
        }

        public Builder log(@NotNull Item log) {
            this.log = log;
            return this;
        }

        public Builder strippedLog(@NotNull Item strippedLog) {
            this.strippedLog = strippedLog;
            return this;
        }

        public Builder wood(@NotNull Item wood) {
            this.wood = wood;
            return this;
        }

        public Builder strippedWood(@NotNull Item strippedWood) {
            this.strippedWood = strippedWood;
            return this;
        }

        public Builder removeCharcoalRecipe() {
            this.removeCharcoalRecipe = true;
            return this;
        }

        public Builder addCharcoalRecipe() {
            this.addCharcoalRecipe = true;
            return this;
        }

        public Builder planks(@NotNull Item planks, @Nullable String planksRecipeName) {
            this.planks = planks;
            this.planksRecipeName = planksRecipeName;
            return this;
        }

        public Builder door(@NotNull Item door, @Nullable String doorRecipeName) {
            this.door = door;
            this.doorRecipeName = doorRecipeName;
            return this;
        }

        public Builder trapdoor(@NotNull Item trapdoor, @Nullable String trapdoorRecipeName) {
            this.trapdoor = trapdoor;
            this.trapdoorRecipeName = trapdoorRecipeName;
            return this;
        }

        public Builder slab(@NotNull Item slab, @Nullable String slabRecipeName) {
            this.slab = slab;
            this.slabRecipeName = slabRecipeName;
            return this;
        }

        public Builder addSlabRecipe() {
            this.addSlabsCraftingRecipe = true;
            return this;
        }

        public Builder fence(@NotNull Item fence, @Nullable String fenceRecipeName) {
            this.fence = fence;
            this.fenceRecipeName = fenceRecipeName;
            return this;
        }

        public Builder fenceGate(@NotNull Item fenceGate, @Nullable String fenceGateRecipeName) {
            this.fenceGate = fenceGate;
            this.fenceGateRecipeName = fenceGateRecipeName;
            return this;
        }

        public Builder stairs(@NotNull Item stairs, @Nullable String stairsRecipeName) {
            this.stairs = stairs;
            this.stairsRecipeName = stairsRecipeName;
            return this;
        }

        public Builder addStairsRecipe() {
            this.addStairsCraftingRecipe = true;
            return this;
        }

        public Builder boat(@NotNull Item boat, @Nullable String boatRecipeName) {
            this.boat = boat;
            this.boatRecipeName = boatRecipeName;
            return this;
        }

        public Builder chestBoat(@NotNull Item chestBoat, @Nullable String chestBoatRecipeName) {
            this.chestBoat = chestBoat;
            this.chestBoatRecipeName = chestBoatRecipeName;
            return this;
        }

        public Builder material(@NotNull Material material) {
            this.material = material;
            return this;
        }

        public Builder registerAllTags() {
            return this.registerTag(true, true, true, true, true, true, true);
        }

        public Builder registerAllUnificationInfo() {
            return this.registerUnificationInfo(true, true, true, true, true, true, true, true);
        }

        public Builder registerTag(boolean log, boolean planks, boolean door, boolean slab, boolean fence, boolean fenceGate, boolean stairs) {
            this.addLogOreDict = log;
            this.addPlanksOreDict = planks;
            this.addDoorsOreDict = door;
            this.addSlabsOreDict = slab;
            this.addFencesOreDict = fence;
            this.addFenceGatesOreDict = fenceGate;
            this.addStairsOreDict = stairs;
            return this;
        }

        public Builder registerUnificationInfo(boolean planks, boolean door, boolean slab, boolean fence, boolean fenceGate, boolean stairs, boolean boat, boolean chestBoat) {
            this.addPlanksUnificationInfo = planks;
            this.addDoorsUnificationInfo = door;
            this.addSlabsUnificationInfo = slab;
            this.addFencesUnificationInfo = fence;
            this.addFenceGatesUnificationInfo = fenceGate;
            this.addStairsUnificationInfo = stairs;
            this.addBoatsUnificationInfo = boat;
            this.addChestBoatsUnificationInfo = chestBoat;
            return this;
        }

        public Builder generateLogToPlankRecipe(boolean enabled) {
            this.generateLogToPlankRecipe = enabled;
            return this;
        }

        @NotNull
        public WoodTypeEntry build() {
            Preconditions.checkArgument((this.planks != null ? 1 : 0) != 0, (Object)"Planks cannot be empty.");
            if (this.logTag == null) {
                this.logTag = TagUtil.optionalTag(BuiltInRegistries.f_257033_, new ResourceLocation(this.modid, this.woodName + "_logs"));
            }
            return new WoodTypeEntry(this.modid, this.woodName, this.logTag, this.log, this.strippedLog, this.wood, this.strippedWood, this.removeCharcoalRecipe, this.addCharcoalRecipe, this.planks, this.planksRecipeName, this.door, this.doorRecipeName, this.trapdoor, this.trapdoorRecipeName, this.slab, this.slabRecipeName, this.addSlabsCraftingRecipe, this.fence, this.fenceRecipeName, this.fenceGate, this.fenceGateRecipeName, this.stairs, this.stairsRecipeName, this.addStairsCraftingRecipe, this.boat, this.boatRecipeName, this.chestBoat, this.chestBoatRecipeName, this.material, this.addLogOreDict, this.addPlanksOreDict, this.addDoorsOreDict, this.addSlabsOreDict, this.addFencesOreDict, this.addFenceGatesOreDict, this.addStairsOreDict, this.addPlanksUnificationInfo, this.addDoorsUnificationInfo, this.addSlabsUnificationInfo, this.addFencesUnificationInfo, this.addFenceGatesUnificationInfo, this.addStairsUnificationInfo, this.addBoatsUnificationInfo, this.addChestBoatsUnificationInfo, this.generateLogToPlankRecipe);
        }
    }
}

