/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.configurable;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class RecipeAddition {
    public static void init(Consumer<FinishedRecipe> provider) {
        RecipeAddition.hardMiscRecipes(provider);
        RecipeAddition.hardRedstoneRecipes(provider);
        RecipeAddition.disableManualCompression(provider);
        RecipeAddition.hardToolArmorRecipes(provider);
        RecipeAddition.harderRods(provider);
        RecipeAddition.harderBrickRecipes(provider);
        RecipeAddition.steelSteamMultiblocks(provider);
        if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
            RecipeAddition.hardWoodRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.hardIronRecipes) {
            RecipeAddition.hardIronRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.hardGlassRecipes) {
            RecipeAddition.hardGlassRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.nerfPaperCrafting) {
            RecipeAddition.nerfPaperCrafting(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.hardAdvancedIronRecipes) {
            RecipeAddition.hardAdvancedIronRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.flintAndSteelRequireSteel) {
            RecipeAddition.flintAndSteelRequireSteel(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
            RecipeAddition.removeVanillaBlockRecipes(provider);
        }
    }

    private static void steelSteamMultiblocks(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.machines.steelSteamMultiblocks) {
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_oven", GTMachines.STEAM_OVEN.asStack(), "CGC", "FMF", "CGC", Character.valueOf('F'), GTBlocks.FIREBOX_STEEL.asStack(), Character.valueOf('C'), GTBlocks.CASING_STEEL_SOLID.asStack(), Character.valueOf('M'), ((MachineDefinition)GTMachines.STEAM_FURNACE.right()).asStack(), Character.valueOf('G'), new UnificationEntry(TagPrefix.gear, GTMaterials.Invar));
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_grinder", GTMachines.STEAM_GRINDER.asStack(), "CGC", "CFC", "CGC", Character.valueOf('G'), new UnificationEntry(TagPrefix.gear, GTMaterials.Potin), Character.valueOf('F'), ((MachineDefinition)GTMachines.STEAM_MACERATOR.right()).asStack(), Character.valueOf('C'), GTBlocks.CASING_STEEL_SOLID.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_hatch", GTMachines.STEAM_HATCH.asStack(), "BPB", "BTB", "BPB", Character.valueOf('B'), new UnificationEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('P'), new UnificationEntry(TagPrefix.pipeNormalFluid, GTMaterials.Steel), Character.valueOf('T'), GTMachines.STEEL_DRUM.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_input_bus", GTMachines.STEAM_IMPORT_BUS.asStack(), "C", "H", Character.valueOf('H'), GTBlocks.STEEL_HULL.asStack(), Character.valueOf('C'), CustomTags.WOODEN_CHESTS);
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_output_bus", GTMachines.STEAM_EXPORT_BUS.asStack(), "H", "C", Character.valueOf('H'), GTBlocks.STEEL_HULL.asStack(), Character.valueOf('C'), CustomTags.WOODEN_CHESTS);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_oven", GTMachines.STEAM_OVEN.asStack(), "CGC", "FMF", "CGC", Character.valueOf('F'), GTBlocks.FIREBOX_BRONZE.asStack(), Character.valueOf('C'), GTBlocks.CASING_BRONZE_BRICKS.asStack(), Character.valueOf('M'), ((MachineDefinition)GTMachines.STEAM_FURNACE.left()).asStack(), Character.valueOf('G'), new UnificationEntry(TagPrefix.gear, GTMaterials.Invar));
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_grinder", GTMachines.STEAM_GRINDER.asStack(), "CGC", "CFC", "CGC", Character.valueOf('G'), new UnificationEntry(TagPrefix.gear, GTMaterials.Potin), Character.valueOf('F'), ((MachineDefinition)GTMachines.STEAM_MACERATOR.left()).asStack(), Character.valueOf('C'), GTBlocks.CASING_BRONZE_BRICKS.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_hatch", GTMachines.STEAM_HATCH.asStack(), "BPB", "BTB", "BPB", Character.valueOf('B'), new UnificationEntry(TagPrefix.plate, GTMaterials.Bronze), Character.valueOf('P'), new UnificationEntry(TagPrefix.pipeNormalFluid, GTMaterials.Bronze), Character.valueOf('T'), GTMachines.BRONZE_DRUM.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_input_bus", GTMachines.STEAM_IMPORT_BUS.asStack(), "C", "H", Character.valueOf('H'), GTBlocks.BRONZE_HULL.asStack(), Character.valueOf('C'), CustomTags.WOODEN_CHESTS);
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_output_bus", GTMachines.STEAM_EXPORT_BUS.asStack(), "H", "C", Character.valueOf('H'), GTBlocks.BRONZE_HULL.asStack(), Character.valueOf('C'), CustomTags.WOODEN_CHESTS);
        }
    }

    private static void disableManualCompression(Consumer<FinishedRecipe> provider) {
        if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
            VanillaRecipeHelper.addShapelessRecipe(provider, "nether_quartz_block_to_nether_quartz", new ItemStack((ItemLike)Items.f_42692_, 4), Blocks.f_50333_);
        }
    }

    private static void harderBrickRecipes(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.harderBrickRecipes) {
            VanillaRecipeHelper.addShapedRecipe(provider, "brick_from_water", new ItemStack((ItemLike)Blocks.f_50076_, 2), "BBB", "BWB", "BBB", Character.valueOf('B'), new ItemStack((ItemLike)Items.f_42460_), Character.valueOf('W'), new ItemStack((ItemLike)Items.f_42447_));
            VanillaRecipeHelper.addShapedRecipe(provider, "bucket_of_concrete", new ItemStack((ItemLike)GTMaterials.Concrete.getBucket()), "CBS", "CWQ", " L ", Character.valueOf('C'), new UnificationEntry(TagPrefix.dust, GTMaterials.Calcite), Character.valueOf('S'), new UnificationEntry(TagPrefix.dust, GTMaterials.Stone), Character.valueOf('W'), new ItemStack((ItemLike)Items.f_42447_), Character.valueOf('Q'), new UnificationEntry(TagPrefix.dust, GTMaterials.QuartzSand), Character.valueOf('L'), new UnificationEntry(TagPrefix.dust, GTMaterials.Clay), Character.valueOf('B'), new ItemStack((ItemLike)Items.f_42446_));
            VanillaRecipeHelper.addShapedRecipe(provider, "casing_primitive_bricks", GTBlocks.CASING_PRIMITIVE_BRICKS.asStack(), "BGB", "BCB", "BGB", Character.valueOf('B'), GTItems.FIRECLAY_BRICK.asStack(), Character.valueOf('G'), new UnificationEntry(TagPrefix.dust, GTMaterials.Gypsum), Character.valueOf('C'), new ItemStack((ItemLike)GTMaterials.Concrete.getBucket()));
            VanillaRecipeHelper.addShapelessRecipe(provider, "compressed_clay", GTItems.COMPRESSED_CLAY.asStack(), GTItems.WOODEN_FORM_BRICK.asStack(), new ItemStack((ItemLike)Items.f_42461_));
            VanillaRecipeHelper.addSmeltingRecipe(provider, "brick_from_compressed_clay", GTItems.COMPRESSED_CLAY.asStack(), new ItemStack((ItemLike)Items.f_42460_), 0.3f);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, "casing_primitive_bricks", GTBlocks.CASING_PRIMITIVE_BRICKS.asStack(), "XX", "XX", Character.valueOf('X'), GTItems.FIRECLAY_BRICK);
        }
    }

    private static void hardWoodRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "ladder", new ItemStack((ItemLike)Blocks.f_50155_, 2), "SrS", "SRS", "ShS", Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('R'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood));
        VanillaRecipeHelper.addShapedRecipe(provider, "bowl", new ItemStack((ItemLike)Items.f_42399_), "k", "X", Character.valueOf('X'), ItemTags.f_13168_);
        VanillaRecipeHelper.addShapedRecipe(provider, "chest", new ItemStack((ItemLike)Blocks.f_50087_), "LPL", "PFP", "LPL", Character.valueOf('L'), ItemTags.f_13182_, Character.valueOf('P'), ItemTags.f_13168_, Character.valueOf('F'), new ItemStack((ItemLike)Items.f_42484_));
        VanillaRecipeHelper.addShapedRecipe(provider, "barrel", new ItemStack((ItemLike)Blocks.f_50618_), "PSP", "PsP", "PSP", Character.valueOf('P'), ItemTags.f_13168_, Character.valueOf('S'), ItemTags.f_13175_);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("barrel", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13168_, 7).outputItems(new ItemStack((ItemLike)Blocks.f_50618_)).duration(100).EUt(4L).save(provider);
    }

    private static void hardIronRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "cauldron", new ItemStack((ItemLike)Items.f_42544_), "X X", "XhX", "XXX", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "hopper", new ItemStack((ItemLike)Blocks.f_50332_), "XCX", "XGX", "wXh", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('C'), CustomTags.WOODEN_CHESTS, Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_bars", new ItemStack((ItemLike)Blocks.f_50183_, 8), " h ", "XXX", "XXX", Character.valueOf('X'), new UnificationEntry(TagPrefix.rod, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_bucket", new ItemStack((ItemLike)Items.f_42446_), "XhX", " X ", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron));
    }

    private static void hardRedstoneRecipes(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.hardRedstoneRecipes) {
            VanillaRecipeHelper.addShapedRecipe(provider, "dispenser", new ItemStack((ItemLike)Blocks.f_50061_), "CRC", "STS", "GAG", Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('A'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dispenser", new Object[0]).duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.f_13166_, 2).inputItems(TagPrefix.ring, GTMaterials.Iron).inputItems(TagPrefix.spring, GTMaterials.Iron, 2).inputItems(TagPrefix.gearSmall, GTMaterials.Iron, 2).inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(new ItemStack((ItemLike)Items.f_42401_)).outputItems(new ItemStack((ItemLike)Blocks.f_50061_)).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "sticky_piston", new ItemStack((ItemLike)Blocks.f_50032_), "h", "R", "P", Character.valueOf('R'), new ItemStack((ItemLike)Items.f_42518_), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50039_));
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_iron", new ItemStack((ItemLike)Blocks.f_50039_), "WWW", "GFG", "CRC", Character.valueOf('W'), ItemTags.f_13168_, Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new UnificationEntry(TagPrefix.plate, GTMaterials.RedAlloy), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('F'), ItemTags.f_13176_);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_iron", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Iron).inputItems(TagPrefix.gearSmall, GTMaterials.Iron).inputItems((TagKey<Item>)ItemTags.f_13175_).inputItems((TagKey<Item>)ItemTags.f_13166_).inputFluids(GTMaterials.RedAlloy.getFluid(144L)).outputItems(new ItemStack((ItemLike)Blocks.f_50039_)).duration(240).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_steel", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Steel).inputItems(TagPrefix.gearSmall, GTMaterials.Steel).inputItems((TagKey<Item>)ItemTags.f_13175_, 2).inputItems((TagKey<Item>)ItemTags.f_13166_, 2).inputFluids(GTMaterials.RedAlloy.getFluid(288L)).outputItems(new ItemStack((ItemLike)Blocks.f_50039_, 2)).duration(240).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_aluminium", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Aluminium).inputItems(TagPrefix.gearSmall, GTMaterials.Aluminium).inputItems((TagKey<Item>)ItemTags.f_13175_, 4).inputItems((TagKey<Item>)ItemTags.f_13166_, 4).inputFluids(GTMaterials.RedAlloy.getFluid(432L)).outputItems(new ItemStack((ItemLike)Blocks.f_50039_, 4)).duration(240).EUt(GTValues.VA[1]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_stainless_steel", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.StainlessSteel).inputItems(TagPrefix.gearSmall, GTMaterials.StainlessSteel).inputItems((TagKey<Item>)ItemTags.f_13175_, 8).inputItems((TagKey<Item>)ItemTags.f_13166_, 8).inputFluids(GTMaterials.RedAlloy.getFluid(576L)).outputItems(new ItemStack((ItemLike)Blocks.f_50039_, 8)).duration(600).EUt(GTValues.VA[1]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_titanium", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Titanium).inputItems(TagPrefix.gearSmall, GTMaterials.Titanium).inputItems((TagKey<Item>)ItemTags.f_13175_, 16).inputItems((TagKey<Item>)ItemTags.f_13166_, 16).inputFluids(GTMaterials.RedAlloy.getFluid(1152L)).outputItems(new ItemStack((ItemLike)Blocks.f_50039_, 16)).duration(800).EUt(GTValues.VA[1]).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "stone_pressure_plate", new ItemStack((ItemLike)Blocks.f_50165_, 2), "ShS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('L'), new ItemStack((ItemLike)Blocks.f_50404_), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "oak_pressure_plate", new ItemStack((ItemLike)Blocks.f_50167_, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), Blocks.f_50398_.m_5456_(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "birch_pressure_plate", new ItemStack((ItemLike)Blocks.f_50169_, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), Blocks.f_50400_.m_5456_(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "spruce_pressure_plate", new ItemStack((ItemLike)Blocks.f_50168_, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), Blocks.f_50399_.m_5456_(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "jungle_pressure_plate", new ItemStack((ItemLike)Blocks.f_50170_, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), Blocks.f_50401_.m_5456_(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "acacia_pressure_plate", new ItemStack((ItemLike)Blocks.f_50171_, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), Blocks.f_50402_.m_5456_(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "dark_oak_pressure_plate", new ItemStack((ItemLike)Blocks.f_50172_, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), Blocks.f_50403_.m_5456_(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "crimson_pressure_plate", new ItemStack((ItemLike)Blocks.f_50659_, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), Blocks.f_50657_.m_5456_(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "warped_pressure_plate", new ItemStack((ItemLike)Blocks.f_50660_, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), Blocks.f_50658_.m_5456_(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "mangrove_pressure_plate", new ItemStack((ItemLike)Blocks.f_220840_, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), Blocks.f_220851_.m_5456_(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "heavy_weighted_pressure_plate", new ItemStack((ItemLike)Blocks.f_50326_), "ShS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('L'), new UnificationEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Steel));
            VanillaRecipeHelper.addShapedRecipe(provider, "light_weighted_pressure_plate", new ItemStack((ItemLike)Blocks.f_50327_), "ShS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('L'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Steel));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("stone_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new ItemStack((ItemLike)Blocks.f_50404_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50165_, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("oak_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new ItemStack((ItemLike)Blocks.f_50398_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50167_, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("birch_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new ItemStack((ItemLike)Blocks.f_50400_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50169_, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("spruce_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new ItemStack((ItemLike)Blocks.f_50399_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50168_, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("jungle_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new ItemStack((ItemLike)Blocks.f_50401_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50170_, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("acacia_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new ItemStack((ItemLike)Blocks.f_50402_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50171_, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dark_oak_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new ItemStack((ItemLike)Blocks.f_50403_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50172_, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crimson_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new ItemStack((ItemLike)Blocks.f_50657_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50659_, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("warped_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new ItemStack((ItemLike)Blocks.f_50658_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50660_, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("mangrove_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new ItemStack((ItemLike)Blocks.f_220851_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_220840_, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("light_weighted_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Gold).outputItems(new ItemStack((ItemLike)Blocks.f_50326_)).duration(200).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("heavy_weighted_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Iron).outputItems(new ItemStack((ItemLike)Blocks.f_50327_)).duration(200).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "stone_button", new ItemStack((ItemLike)Blocks.f_50124_, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50165_));
            VanillaRecipeHelper.addShapedRecipe(provider, "oak_button", new ItemStack((ItemLike)Blocks.f_50251_, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50167_));
            VanillaRecipeHelper.addShapedRecipe(provider, "birch_button", new ItemStack((ItemLike)Blocks.f_50253_, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50169_));
            VanillaRecipeHelper.addShapedRecipe(provider, "spruce_button", new ItemStack((ItemLike)Blocks.f_50252_, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50168_));
            VanillaRecipeHelper.addShapedRecipe(provider, "jungle_button", new ItemStack((ItemLike)Blocks.f_50254_, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50170_));
            VanillaRecipeHelper.addShapedRecipe(provider, "acacia_button", new ItemStack((ItemLike)Blocks.f_50308_, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50171_));
            VanillaRecipeHelper.addShapedRecipe(provider, "dark_oak_button", new ItemStack((ItemLike)Blocks.f_50309_, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50172_));
            VanillaRecipeHelper.addShapedRecipe(provider, "crimson_button", new ItemStack((ItemLike)Blocks.f_50669_, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50659_));
            VanillaRecipeHelper.addShapedRecipe(provider, "warped_button", new ItemStack((ItemLike)Blocks.f_50670_, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50660_));
            VanillaRecipeHelper.addShapedRecipe(provider, "mangrove_button", new ItemStack((ItemLike)Blocks.f_220846_, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_220840_));
            VanillaRecipeHelper.addShapedRecipe(provider, "cherry_button", new ItemStack((ItemLike)Blocks.f_271396_, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_271227_));
            VanillaRecipeHelper.addShapedRecipe(provider, "bamboo_button", new ItemStack((ItemLike)Blocks.f_244625_, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_244183_));
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("stone_button", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50165_)).outputItems(new ItemStack((ItemLike)Blocks.f_50124_, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("oak_button", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50167_)).outputItems(new ItemStack((ItemLike)Blocks.f_50251_, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("birch_button", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50169_)).outputItems(new ItemStack((ItemLike)Blocks.f_50253_, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("spruce_button", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50168_)).outputItems(new ItemStack((ItemLike)Blocks.f_50252_, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("jungle_button", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50170_)).outputItems(new ItemStack((ItemLike)Blocks.f_50254_, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("acacia_button", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50171_)).outputItems(new ItemStack((ItemLike)Blocks.f_50308_, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("dark_oak_button", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50172_)).outputItems(new ItemStack((ItemLike)Blocks.f_50309_, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("crimson_button", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50659_)).outputItems(new ItemStack((ItemLike)Blocks.f_50669_, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("warped_button", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50660_)).outputItems(new ItemStack((ItemLike)Blocks.f_50670_, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("mangrove_button", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_220840_)).outputItems(new ItemStack((ItemLike)Blocks.f_220846_, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "lever", new ItemStack((ItemLike)Blocks.f_50164_), "B", "S", Character.valueOf('B'), new ItemStack((ItemLike)Blocks.f_50124_), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood));
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector", new ItemStack((ItemLike)Blocks.f_50329_), "GGG", "PPP", "SRS", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.NetherQuartz), Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector_certus", new ItemStack((ItemLike)Blocks.f_50329_), "GGG", "PPP", "SRS", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.CertusQuartz), Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector_quartzite", new ItemStack((ItemLike)Blocks.f_50329_), "GGG", "PPP", "SRS", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_, 1), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Quartzite), Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("daylight_detector", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(new ItemStack((ItemLike)Blocks.f_50058_, 3)).inputItems(TagPrefix.ingot, GTMaterials.NetherQuartz, 3).inputItems((TagKey<Item>)ItemTags.f_13168_).outputItems(new ItemStack((ItemLike)Blocks.f_50329_)).duration(200).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("daylight_detector_certus", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(new ItemStack((ItemLike)Blocks.f_50058_, 3)).inputItems(TagPrefix.ingot, GTMaterials.CertusQuartz, 3).inputItems((TagKey<Item>)ItemTags.f_13168_).outputItems(new ItemStack((ItemLike)Blocks.f_50329_)).duration(200).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("daylight_detector_quartzite", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(new ItemStack((ItemLike)Blocks.f_50058_, 3)).inputItems(TagPrefix.ingot, GTMaterials.Quartzite, 3).inputItems((TagKey<Item>)ItemTags.f_13168_).outputItems(new ItemStack((ItemLike)Blocks.f_50329_)).duration(200).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "redstone_lamp", new ItemStack((ItemLike)Blocks.f_50261_), "PPP", "PGP", "PRP", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50185_), Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50141_), Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "tripwire_hook", new ItemStack((ItemLike)Blocks.f_50266_), "IRI", "SRS", " S ", Character.valueOf('I'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_));
            VanillaRecipeHelper.addShapedRecipe(provider, "dropper", new ItemStack((ItemLike)Blocks.f_50286_), "CRC", "STS", "GAG", Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.springSmall, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('A'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "observer", new ItemStack((ItemLike)Blocks.f_50455_), "RCR", "CQC", "GSG", Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('Q'), new UnificationEntry(TagPrefix.plate, GTMaterials.NetherQuartz), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "observer_certus", new ItemStack((ItemLike)Blocks.f_50455_), "RCR", "CQC", "GSG", Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('Q'), new UnificationEntry(TagPrefix.plate, GTMaterials.CertusQuartz), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "observer_quartzite", new ItemStack((ItemLike)Blocks.f_50455_), "RCR", "CQC", "GSG", Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('Q'), new UnificationEntry(TagPrefix.plate, GTMaterials.Quartzite), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "repeater", new ItemStack((ItemLike)Items.f_42350_), "S S", "TdT", "PRP", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50165_), Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator", new ItemStack((ItemLike)Items.f_42351_), "STS", "TQT", "PdP", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('Q'), new UnificationEntry(TagPrefix.plate, GTMaterials.NetherQuartz), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50165_));
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator_certus", new ItemStack((ItemLike)Items.f_42351_), "STS", "TQT", "PdP", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('Q'), new UnificationEntry(TagPrefix.plate, GTMaterials.CertusQuartz), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50165_));
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator_quartzite", new ItemStack((ItemLike)Items.f_42351_), "STS", "TQT", "PdP", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('Q'), new UnificationEntry(TagPrefix.plate, GTMaterials.Quartzite), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50165_));
            VanillaRecipeHelper.addShapedRecipe(provider, "powered_rail", new ItemStack((ItemLike)Blocks.f_50030_, 6), "SPS", "IWI", "GdG", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.RedAlloy), Character.valueOf('I'), new UnificationEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('G'), new UnificationEntry(TagPrefix.rod, GTMaterials.Gold));
            VanillaRecipeHelper.addShapedRecipe(provider, "detector_rail", new ItemStack((ItemLike)Blocks.f_50031_, 6), "SPS", "IWI", "IdI", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50327_), Character.valueOf('I'), new UnificationEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood));
            VanillaRecipeHelper.addShapedRecipe(provider, "rail", new ItemStack((ItemLike)Blocks.f_50156_, 8), "ShS", "IWI", "IdI", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('I'), new UnificationEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood));
            VanillaRecipeHelper.addShapedRecipe(provider, "activator_rail", new ItemStack((ItemLike)Blocks.f_50285_, 6), "SPS", "IWI", "IdI", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('I'), new UnificationEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), Tags.Items.RODS_WOODEN);
            VanillaRecipeHelper.addShapedRecipe(provider, "redstone_torch", new ItemStack((ItemLike)Blocks.f_50174_), "R", "T", Character.valueOf('R'), new UnificationEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50081_));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("calibrated_sculk_sensor", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_152500_)).inputItems(TagPrefix.ingot, GTMaterials.Amethyst).inputItems(TagPrefix.plate, GTMaterials.Amethyst).outputItems(new ItemStack((ItemLike)Blocks.f_276595_)).duration(200).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("target", new Object[0]).duration(100).EUt(16L).inputItems(Items.f_42451_, 4).inputItems(Items.f_42129_).outputItems(new ItemStack((ItemLike)Blocks.f_50716_)).save(provider);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_bronze", new ItemStack((ItemLike)Blocks.f_50039_, 1), "WWW", "CBC", "CRC", Character.valueOf('W'), ItemTags.f_13168_, Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new UnificationEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new UnificationEntry(TagPrefix.ingot, GTMaterials.Bronze));
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_steel", new ItemStack((ItemLike)Blocks.f_50039_, 2), "WWW", "CBC", "CRC", Character.valueOf('W'), ItemTags.f_13168_, Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new UnificationEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new UnificationEntry(TagPrefix.ingot, GTMaterials.Steel));
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_aluminium", new ItemStack((ItemLike)Blocks.f_50039_, 4), "WWW", "CBC", "CRC", Character.valueOf('W'), ItemTags.f_13168_, Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new UnificationEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new UnificationEntry(TagPrefix.ingot, GTMaterials.Aluminium));
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_titanium", new ItemStack((ItemLike)Blocks.f_50039_, 8), "WWW", "CBC", "CRC", Character.valueOf('W'), ItemTags.f_13168_, Character.valueOf('C'), ItemTags.f_13166_, Character.valueOf('R'), new UnificationEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new UnificationEntry(TagPrefix.ingot, GTMaterials.Titanium));
            VanillaRecipeHelper.addShapedRecipe(provider, "sticky_piston_resin", new ItemStack((ItemLike)Blocks.f_50032_), "h", "R", "P", Character.valueOf('R'), GTItems.STICKY_RESIN.asStack(), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50039_));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_iron", new Object[0]).duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Iron).inputItems((TagKey<Item>)ItemTags.f_13168_, 3).inputItems((TagKey<Item>)ItemTags.f_13166_, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.f_50039_)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_bronze", new Object[0]).duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Bronze).inputItems((TagKey<Item>)ItemTags.f_13168_, 3).inputItems((TagKey<Item>)ItemTags.f_13166_, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.f_50039_)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_steel", new Object[0]).duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Steel).inputItems((TagKey<Item>)ItemTags.f_13168_, 3).inputItems((TagKey<Item>)ItemTags.f_13166_, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.f_50039_, 2)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_aluminium", new Object[0]).duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Aluminium).inputItems((TagKey<Item>)ItemTags.f_13168_, 3).inputItems((TagKey<Item>)ItemTags.f_13166_, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.f_50039_, 4)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_titanium", new Object[0]).duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Titanium).inputItems((TagKey<Item>)ItemTags.f_13168_, 3).inputItems((TagKey<Item>)ItemTags.f_13166_, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.f_50039_, 8)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("light_weighted_pressure_plate", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Gold, 2).outputItems(new ItemStack((ItemLike)Blocks.f_50326_)).circuitMeta(2).duration(100).EUt(4L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("heavy_weighted_pressure_plate", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Iron, 2).outputItems(new ItemStack((ItemLike)Blocks.f_50327_)).circuitMeta(2).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator_certus", new ItemStack((ItemLike)Items.f_42351_), " T ", "TQT", "SSS", Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('Q'), new UnificationEntry(TagPrefix.gem, GTMaterials.CertusQuartz), Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50069_));
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator_quartzite", new ItemStack((ItemLike)Items.f_42351_), " T ", "TQT", "SSS", Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50174_), Character.valueOf('Q'), new UnificationEntry(TagPrefix.gem, GTMaterials.Quartzite), Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50069_));
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector_certus", new ItemStack((ItemLike)Blocks.f_50329_), "GGG", "CCC", "PPP", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_), Character.valueOf('C'), new UnificationEntry(TagPrefix.gem, GTMaterials.CertusQuartz), Character.valueOf('P'), ItemTags.f_13175_);
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector_quartzite", new ItemStack((ItemLike)Blocks.f_50329_), "GGG", "CCC", "PPP", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_), Character.valueOf('C'), new UnificationEntry(TagPrefix.gem, GTMaterials.Quartzite), Character.valueOf('P'), ItemTags.f_13175_);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("note_block", new Object[0]).duration(100).EUt(16L).inputItems((TagKey<Item>)ItemTags.f_13168_, 8).inputItems(TagPrefix.dust, GTMaterials.Redstone).circuitMeta(1).outputItems(new ItemStack((ItemLike)Blocks.f_50065_)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("jukebox", new Object[0]).duration(100).EUt(16L).inputItems((TagKey<Item>)ItemTags.f_13168_, 8).inputItems(TagPrefix.gem, GTMaterials.Diamond).outputItems(new ItemStack((ItemLike)Blocks.f_50131_)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("target", new Object[0]).duration(100).EUt(16L).inputItems(Items.f_42451_, 4).inputItems(Items.f_42129_).outputItems(new ItemStack((ItemLike)Blocks.f_50716_)).save(provider);
        }
    }

    private static void hardToolArmorRecipes(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.hardToolArmorRecipes) {
            RecipeAddition.createShovelRecipe(provider, "iron_shovel", new ItemStack((ItemLike)Items.f_42384_), GTMaterials.Iron);
            RecipeAddition.createPickaxeRecipe(provider, "iron_pickaxe", new ItemStack((ItemLike)Items.f_42385_), GTMaterials.Iron);
            RecipeAddition.createAxeRecipe(provider, "iron_axe", new ItemStack((ItemLike)Items.f_42386_), GTMaterials.Iron);
            RecipeAddition.createSwordRecipe(provider, "iron_sword", new ItemStack((ItemLike)Items.f_42383_), GTMaterials.Iron);
            RecipeAddition.createHoeRecipe(provider, "iron_hoe", new ItemStack((ItemLike)Items.f_42387_), GTMaterials.Iron);
            RecipeAddition.createHelmetRecipe(provider, "iron_helmet", new ItemStack((ItemLike)Items.f_42468_), GTMaterials.Iron);
            RecipeAddition.createChestplateRecipe(provider, "iron_chestplate", new ItemStack((ItemLike)Items.f_42469_), GTMaterials.Iron);
            RecipeAddition.createLeggingsRecipe(provider, "iron_leggings", new ItemStack((ItemLike)Items.f_42470_), GTMaterials.Iron);
            RecipeAddition.createBootsRecipe(provider, "iron_boots", new ItemStack((ItemLike)Items.f_42471_), GTMaterials.Iron);
            RecipeAddition.createShovelRecipe(provider, "golden_shovel", new ItemStack((ItemLike)Items.f_42431_), GTMaterials.Gold);
            RecipeAddition.createPickaxeRecipe(provider, "golden_pickaxe", new ItemStack((ItemLike)Items.f_42432_), GTMaterials.Gold);
            RecipeAddition.createAxeRecipe(provider, "golden_axe", new ItemStack((ItemLike)Items.f_42433_), GTMaterials.Gold);
            RecipeAddition.createSwordRecipe(provider, "golden_sword", new ItemStack((ItemLike)Items.f_42430_), GTMaterials.Gold);
            RecipeAddition.createHoeRecipe(provider, "golden_hoe", new ItemStack((ItemLike)Items.f_42434_), GTMaterials.Gold);
            RecipeAddition.createHelmetRecipe(provider, "golden_helmet", new ItemStack((ItemLike)Items.f_42476_), GTMaterials.Gold);
            RecipeAddition.createChestplateRecipe(provider, "golden_chestplate", new ItemStack((ItemLike)Items.f_42477_), GTMaterials.Gold);
            RecipeAddition.createLeggingsRecipe(provider, "golden_leggings", new ItemStack((ItemLike)Items.f_42478_), GTMaterials.Gold);
            RecipeAddition.createBootsRecipe(provider, "golden_boots", new ItemStack((ItemLike)Items.f_42479_), GTMaterials.Gold);
            RecipeAddition.createShovelRecipe(provider, "diamond_shovel", new ItemStack((ItemLike)Items.f_42389_), GTMaterials.Diamond);
            RecipeAddition.createPickaxeRecipe(provider, "diamond_pickaxe", new ItemStack((ItemLike)Items.f_42390_), GTMaterials.Diamond);
            RecipeAddition.createAxeRecipe(provider, "diamond_axe", new ItemStack((ItemLike)Items.f_42391_), GTMaterials.Diamond);
            RecipeAddition.createSwordRecipe(provider, "diamond_sword", new ItemStack((ItemLike)Items.f_42388_), GTMaterials.Diamond);
            RecipeAddition.createHoeRecipe(provider, "diamond_hoe", new ItemStack((ItemLike)Items.f_42392_), GTMaterials.Diamond);
            RecipeAddition.createHelmetRecipe(provider, "diamond_helmet", new ItemStack((ItemLike)Items.f_42472_), GTMaterials.Diamond);
            RecipeAddition.createChestplateRecipe(provider, "diamond_chestplate", new ItemStack((ItemLike)Items.f_42473_), GTMaterials.Diamond);
            RecipeAddition.createLeggingsRecipe(provider, "diamond_leggings", new ItemStack((ItemLike)Items.f_42474_), GTMaterials.Diamond);
            RecipeAddition.createBootsRecipe(provider, "diamond_boots", new ItemStack((ItemLike)Items.f_42475_), GTMaterials.Diamond);
            VanillaRecipeHelper.addShapedRecipe(provider, "compass", new ItemStack((ItemLike)Items.f_42522_), "SGB", "RPR", "AdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50185_), Character.valueOf('B'), new UnificationEntry(TagPrefix.bolt, GTMaterials.IronMagnetic), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Zinc), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('A'), new UnificationEntry(TagPrefix.bolt, GTMaterials.RedAlloy));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("compass", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Iron).inputItems(TagPrefix.ring, GTMaterials.Zinc).inputItems(TagPrefix.bolt, GTMaterials.RedAlloy).inputItems(TagPrefix.bolt, GTMaterials.IronMagnetic).inputItems(TagPrefix.screw, GTMaterials.Iron, 2).outputItems(new ItemStack((ItemLike)Items.f_42522_)).duration(100).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "fishing_rod", new ItemStack((ItemLike)Items.f_42523_), "  S", " SL", "SxR", Character.valueOf('S'), new UnificationEntry(TagPrefix.rodLong, GTMaterials.Wood), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "clock", new ItemStack((ItemLike)Items.f_42524_), "RPR", "BCB", "dSw", Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Gold), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('B'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Gold), Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42351_), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Gold));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("clock", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Gold).inputItems(TagPrefix.ring, GTMaterials.Gold).inputItems(TagPrefix.bolt, GTMaterials.Gold, 2).inputItems(TagPrefix.screw, GTMaterials.Gold).inputItems(new ItemStack((ItemLike)Items.f_42351_)).outputItems(new ItemStack((ItemLike)Items.f_42524_)).duration(100).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "shears", new ItemStack((ItemLike)Items.f_42574_), "PSP", "hRf", "TdT", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('T'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood));
            VanillaRecipeHelper.addShapedRecipe(provider, "shield", new ItemStack((ItemLike)Items.f_42740_), "BRB", "LPL", "BRB", Character.valueOf('B'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Iron), Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('L'), new UnificationEntry(TagPrefix.rodLong, GTMaterials.Iron), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Wood));
        } else {
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("compass", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Redstone).inputItems(TagPrefix.plate, GTMaterials.Iron, 4).circuitMeta(1).outputItems(new ItemStack((ItemLike)Items.f_42522_)).duration(100).EUt(4L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("clock", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Redstone).inputItems(TagPrefix.plate, GTMaterials.Gold, 4).outputItems(new ItemStack((ItemLike)Items.f_42524_)).duration(100).EUt(4L).save(provider);
        }
    }

    private static void harderRods(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.harderRods) {
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_cobblestone", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13166_).outputItems(TagPrefix.rod, GTMaterials.Stone, 1).outputItems(TagPrefix.dustSmall, GTMaterials.Stone, 2).duration(20).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_stone", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50069_)).outputItems(TagPrefix.rod, GTMaterials.Stone, 1).outputItems(TagPrefix.dustSmall, GTMaterials.Stone, 2).duration(20).EUt(GTValues.VA[0]).save(provider);
        } else {
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_cobblestone", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13166_).outputItems(TagPrefix.rod, GTMaterials.Stone, 2).duration(20).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_stone", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50069_)).outputItems(TagPrefix.rod, GTMaterials.Stone, 2).duration(20).EUt(GTValues.VA[0]).save(provider);
        }
    }

    private static void hardMiscRecipes(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.hardMiscRecipes) {
            VanillaRecipeHelper.addShapedRecipe(provider, "beacon", new ItemStack((ItemLike)Blocks.f_50273_), "GLG", "GSG", "OOO", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_), Character.valueOf('L'), new UnificationEntry(TagPrefix.lens, GTMaterials.NetherStar), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42686_), Character.valueOf('O'), new UnificationEntry(TagPrefix.plate, GTMaterials.Obsidian));
            VanillaRecipeHelper.addShapedRecipe(provider, "lit_pumpkin", new ItemStack((ItemLike)Blocks.f_50144_), "PT", "k ", Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50133_), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50081_));
            VanillaRecipeHelper.addShapedRecipe(provider, "book", new ItemStack((ItemLike)Items.f_42517_), "SPL", "SPG", "SPL", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('P'), new ItemStack((ItemLike)Items.f_42516_), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42454_), Character.valueOf('G'), GTItems.STICKY_RESIN.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "brewing_stand", new ItemStack((ItemLike)Items.f_42543_), "RBR", "ABA", "SCS", Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Aluminium), Character.valueOf('B'), new UnificationEntry(TagPrefix.rod, GTMaterials.Blaze), Character.valueOf('A'), new UnificationEntry(TagPrefix.rod, GTMaterials.Aluminium), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Aluminium), Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42544_));
            VanillaRecipeHelper.addShapedRecipe(provider, "enchanting_table", new ItemStack((ItemLike)Blocks.f_50201_), "DCD", "PBP", "DPD", Character.valueOf('D'), new UnificationEntry(TagPrefix.gem, GTMaterials.Diamond), Character.valueOf('C'), new ItemStack((ItemLike)Blocks.f_50350_), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Obsidian), Character.valueOf('B'), new ItemStack((ItemLike)Blocks.f_50078_));
            VanillaRecipeHelper.addShapedRecipe(provider, "jukebox", new ItemStack((ItemLike)Blocks.f_50131_), "LBL", "NRN", "LGL", Character.valueOf('L'), ItemTags.f_13182_, Character.valueOf('B'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Diamond), Character.valueOf('N'), new ItemStack((ItemLike)Blocks.f_50065_), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('G'), new UnificationEntry(TagPrefix.gear, GTMaterials.Iron));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("jukebox", new Object[0]).inputItems(TagPrefix.bolt, GTMaterials.Diamond).inputItems(TagPrefix.gear, GTMaterials.Iron).inputItems(TagPrefix.ring, GTMaterials.Iron).inputItems(TagPrefix.plate, GTMaterials.Wood, 4).inputItems(new ItemStack((ItemLike)Blocks.f_50065_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50131_)).duration(100).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "note_block", new ItemStack((ItemLike)Blocks.f_50065_), "PPP", "BGB", "PRP", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('B'), new ItemStack((ItemLike)Blocks.f_50183_), Character.valueOf('G'), new UnificationEntry(TagPrefix.gear, GTMaterials.Wood), Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("note_block", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Wood, 4).inputItems(TagPrefix.gear, GTMaterials.Wood).inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(new ItemStack((ItemLike)Blocks.f_50183_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50065_)).duration(100).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "furnace", new ItemStack((ItemLike)Blocks.f_50094_), "CCC", "FFF", "CCC", Character.valueOf('F'), new ItemStack((ItemLike)Items.f_42484_), Character.valueOf('C'), ItemTags.f_13166_);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("furnace", new Object[0]).circuitMeta(8).inputItems((TagKey<Item>)ItemTags.f_13166_, 8).inputItems(new ItemStack((ItemLike)Items.f_42484_)).outputItems(new ItemStack((ItemLike)Blocks.f_50094_)).duration(100).EUt(GTValues.VA[0]).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "crafting_table", new ItemStack((ItemLike)Blocks.f_50091_), "FF", "WW", Character.valueOf('F'), new ItemStack((ItemLike)Items.f_42484_), Character.valueOf('W'), ItemTags.f_13182_);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crafting_table", new Object[0]).duration(80).EUt(6L).inputItems((TagKey<Item>)ItemTags.f_13182_).inputItems(new ItemStack((ItemLike)Items.f_42484_)).outputItems(new ItemStack((ItemLike)Blocks.f_50091_)).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "lead", new ItemStack((ItemLike)Items.f_42655_), "SSS", "SBS", "SSS", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('B'), new ItemStack((ItemLike)Items.f_42518_));
            VanillaRecipeHelper.addShapedRecipe(provider, "bow", new ItemStack((ItemLike)Items.f_42411_), "hLS", "LRS", "fLS", Character.valueOf('L'), new UnificationEntry(TagPrefix.rodLong, GTMaterials.Wood), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "crossbow", new ItemStack((ItemLike)Items.f_42717_), "RIR", "STS", "sRf", Character.valueOf('R'), new UnificationEntry(TagPrefix.rodLong, GTMaterials.Wood), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('T'), new ItemStack((ItemLike)Items.f_42109_), Character.valueOf('I'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "item_frame", new ItemStack((ItemLike)Items.f_42617_), "SRS", "TLT", "TTT", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('T'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42454_));
            VanillaRecipeHelper.addShapedRecipe(provider, "painting", new ItemStack((ItemLike)Items.f_42487_), "SRS", "TCT", "TTT", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('T'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('C'), ItemTags.f_215867_);
            VanillaRecipeHelper.addShapedRecipe(provider, "chest_minecart", new ItemStack((ItemLike)Items.f_42519_), "hIw", " M ", " d ", Character.valueOf('I'), CustomTags.WOODEN_CHESTS, Character.valueOf('M'), new ItemStack((ItemLike)Items.f_42449_));
            VanillaRecipeHelper.addShapedRecipe(provider, "furnace_minecart", new ItemStack((ItemLike)Items.f_42520_), "hIw", " M ", " d ", Character.valueOf('I'), new ItemStack((ItemLike)Blocks.f_50094_), Character.valueOf('M'), new ItemStack((ItemLike)Items.f_42449_));
            VanillaRecipeHelper.addShapedRecipe(provider, "tnt_minecart", new ItemStack((ItemLike)Items.f_42693_), "hIw", " M ", " d ", Character.valueOf('I'), new ItemStack((ItemLike)Blocks.f_50077_), Character.valueOf('M'), new ItemStack((ItemLike)Items.f_42449_));
            VanillaRecipeHelper.addShapedRecipe(provider, "hopper_minecart", new ItemStack((ItemLike)Items.f_42694_), "hIw", " M ", " d ", Character.valueOf('I'), new ItemStack((ItemLike)Blocks.f_50332_), Character.valueOf('M'), new ItemStack((ItemLike)Items.f_42449_));
            VanillaRecipeHelper.addShapedRecipe(provider, "flower_pot", new ItemStack((ItemLike)Items.f_42618_), "BfB", " B ", Character.valueOf('B'), new ItemStack((ItemLike)Items.f_42460_));
            VanillaRecipeHelper.addShapedRecipe(provider, "armor_stand", new ItemStack((ItemLike)Items.f_42650_), "BSB", "hSs", "IPI", Character.valueOf('B'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood), Character.valueOf('I'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('P'), new ItemStack((ItemLike)Blocks.f_50165_));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("armor_stand", new Object[0]).inputItems(Blocks.f_50165_.m_5456_()).inputItems(TagPrefix.plate, GTMaterials.Iron, 2).inputItems(TagPrefix.rod, GTMaterials.Wood, 2).outputItems(Items.f_42650_).duration(100).EUt(GTValues.VA[0]).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "trapped_chest", new ItemStack((ItemLike)Blocks.f_50325_), " H ", "SCS", " d ", Character.valueOf('H'), new ItemStack((ItemLike)Blocks.f_50266_), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('C'), new ItemStack((ItemLike)Blocks.f_50087_));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("ender_chest", new Object[0]).inputItems(CustomTags.WOODEN_CHESTS).inputItems(TagPrefix.plateDense, GTMaterials.Obsidian, 6).inputItems(TagPrefix.plate, GTMaterials.EnderEye).outputItems(Blocks.f_50265_.m_5456_()).duration(200).EUt(GTValues.VA[2]).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "lantern", new ItemStack((ItemLike)Blocks.f_50681_), "hRf", "RFR", " R ", Character.valueOf('F'), new ItemStack((ItemLike)Blocks.f_50081_), Character.valueOf('R'), new UnificationEntry(TagPrefix.round, GTMaterials.Iron));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lantern", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50081_)).inputItems(TagPrefix.round, GTMaterials.Iron, 4).outputItems(new ItemStack((ItemLike)Blocks.f_50681_)).duration(100).EUt(1L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "soul_lantern", new ItemStack((ItemLike)Blocks.f_50682_), "hRf", "RFR", " R ", Character.valueOf('F'), new ItemStack((ItemLike)Blocks.f_50139_), Character.valueOf('R'), new UnificationEntry(TagPrefix.round, GTMaterials.Iron));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("soul_lantern", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50139_)).inputItems(TagPrefix.round, GTMaterials.Iron, 4).outputItems(new ItemStack((ItemLike)Blocks.f_50682_)).duration(100).EUt(1L).save(provider);
            GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("tinted_glass", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50058_)).inputItems(new ItemStack((ItemLike)Items.f_151049_, 4)).outputItems(new ItemStack((ItemLike)Blocks.f_152498_, 2)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "stonecutter", new ItemStack((ItemLike)Blocks.f_50679_), "f d", "SBS", "XXX", Character.valueOf('X'), new ItemStack((ItemLike)Blocks.f_50404_), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Wood), Character.valueOf('B'), new UnificationEntry(TagPrefix.toolHeadBuzzSaw, GTMaterials.Iron));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("stonecutter", new Object[0]).inputItems(TagPrefix.toolHeadBuzzSaw, GTMaterials.Iron).inputItems(new ItemStack((ItemLike)Blocks.f_50404_)).outputItems(new ItemStack((ItemLike)Blocks.f_50679_)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "cartography_table", new ItemStack((ItemLike)Blocks.f_50621_), "sPd", "WWW", "SLS", Character.valueOf('P'), new ItemStack((ItemLike)Items.f_42516_), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('W'), new UnificationEntry(TagPrefix.plate, GTMaterials.TreatedWood), Character.valueOf('L'), ItemTags.f_13182_);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cartography_table", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42516_)).inputItems((TagKey<Item>)ItemTags.f_13182_).outputItems(new ItemStack((ItemLike)Blocks.f_50621_)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "fletching_table", new ItemStack((ItemLike)Blocks.f_50622_), "sPd", "WWW", "SLS", Character.valueOf('P'), new ItemStack((ItemLike)Items.f_42402_), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('W'), new UnificationEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('L'), ItemTags.f_13182_);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fletching_table", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42402_)).inputItems((TagKey<Item>)ItemTags.f_13182_).outputItems(new ItemStack((ItemLike)Blocks.f_50622_)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "smithing_table", new ItemStack((ItemLike)Blocks.f_50625_), "h d", "WWW", "SLS", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.WroughtIron), Character.valueOf('W'), new UnificationEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('L'), ItemTags.f_13182_);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("smithing_table", new Object[0]).inputItems(TagPrefix.screw, GTMaterials.WroughtIron, 2).inputItems((TagKey<Item>)ItemTags.f_13182_).inputItems(TagPrefix.plate, GTMaterials.Steel, 3).outputItems(new ItemStack((ItemLike)Blocks.f_50625_)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "grindstone", new ItemStack((ItemLike)Blocks.f_50623_), "hBd", "IXI", "WfW", Character.valueOf('X'), new ItemStack((ItemLike)Blocks.f_50404_), Character.valueOf('B'), new UnificationEntry(TagPrefix.toolHeadBuzzSaw, GTMaterials.Iron), Character.valueOf('I'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Iron), Character.valueOf('W'), new UnificationEntry(TagPrefix.rodLong, GTMaterials.Wood));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("grindstone", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50404_)).inputItems(TagPrefix.toolHeadBuzzSaw, GTMaterials.Iron).inputItems(TagPrefix.rodLong, GTMaterials.Wood, 2).outputItems(new ItemStack((ItemLike)Blocks.f_50623_)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "loom", new ItemStack((ItemLike)Blocks.f_50617_), "SSS", "PdP", "XYX", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('X'), new UnificationEntry(TagPrefix.screw, GTMaterials.Wood), Character.valueOf('Y'), ItemTags.f_13168_);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("loom", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42401_, 3)).inputItems(TagPrefix.plate, GTMaterials.Wood, 2).inputItems((TagKey<Item>)ItemTags.f_13168_).outputItems(new ItemStack((ItemLike)Blocks.f_50617_)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "smoker", new ItemStack((ItemLike)Blocks.f_50619_), "wId", "PFP", "XPX", Character.valueOf('I'), new ItemStack((ItemLike)Blocks.f_50183_), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.TreatedWood), Character.valueOf('X'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Iron), Character.valueOf('F'), new ItemStack((ItemLike)Blocks.f_50094_));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("smoker", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50183_)).inputItems((TagKey<Item>)ItemTags.f_13168_, 3).inputItems(new ItemStack((ItemLike)Blocks.f_50094_)).outputItems(new ItemStack((ItemLike)Blocks.f_50619_)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "blast_furnace", new ItemStack((ItemLike)Blocks.f_50620_), "wfd", "PFP", "XPX", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('X'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('F'), new ItemStack((ItemLike)Blocks.f_50094_));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("blast_furnace", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Iron, 3).inputItems(new ItemStack((ItemLike)Blocks.f_50094_)).outputItems(new ItemStack((ItemLike)Blocks.f_50620_)).duration(80).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "composter", new ItemStack((ItemLike)Blocks.f_50715_), "PsP", "P P", "XPX", Character.valueOf('P'), ItemTags.f_13168_, Character.valueOf('X'), new UnificationEntry(TagPrefix.screw, GTMaterials.Wood));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("composter", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13168_, 4).circuitMeta(1).outputItems(new ItemStack((ItemLike)Blocks.f_50715_)).duration(80).EUt(6L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bell", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42398_)).inputItems(TagPrefix.rod, GTMaterials.Stone, 2).inputItems(TagPrefix.bolt, GTMaterials.Iron, 2).inputItems(TagPrefix.plate, GTMaterials.Bronze, 4).outputItems(new ItemStack((ItemLike)Blocks.f_50680_)).duration(200).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("conduit", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42716_)).inputItems(new ItemStack((ItemLike)Items.f_42715_, 8)).outputItems(new ItemStack((ItemLike)Blocks.f_50569_)).duration(200).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "candle", new ItemStack((ItemLike)Blocks.f_152482_), "r", "S", "W", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('W'), new ItemStack((ItemLike)Items.f_42784_));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lodestone", new Object[0]).inputItems(TagPrefix.plateDense, GTMaterials.SteelMagnetic).inputItems(TagPrefix.screw, GTMaterials.Iron, 4).inputItems(TagPrefix.plate, GTMaterials.Stone, 4).outputItems(new ItemStack((ItemLike)Blocks.f_50729_)).duration(200).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("music_disc_5", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_220218_, 9)).outputItems(new ItemStack((ItemLike)Items.f_220217_)).duration(100).EUt(6L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "turtle_helmet", new ItemStack((ItemLike)Items.f_42354_), "SSS", "SrS", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42355_));
            VanillaRecipeHelper.addShapedRecipe(provider, "scaffolding", new ItemStack((ItemLike)Blocks.f_50616_, 3), "BSB", "BWB", "BrB", Character.valueOf('B'), new ItemStack((ItemLike)Items.f_41911_), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_), Character.valueOf('W'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("scaffolding", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_41911_, 6)).inputItems(new ItemStack((ItemLike)Items.f_42401_)).outputItems(new ItemStack((ItemLike)Blocks.f_50616_, 4)).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "beehive", new ItemStack((ItemLike)Blocks.f_50718_, 1), "PsP", "WXW", "PdP", Character.valueOf('P'), ItemTags.f_13168_, Character.valueOf('W'), new UnificationEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('X'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("beehive", new Object[0]).inputItems(TagPrefix.screw, GTMaterials.Wood, 2).inputItems((TagKey<Item>)ItemTags.f_13168_, 5).circuitMeta(2).outputItems(new ItemStack((ItemLike)Blocks.f_50718_)).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "lightning_rod", new ItemStack((ItemLike)Blocks.f_152587_), " B ", "fRh", " R ", Character.valueOf('R'), TagPrefix.rod, GTMaterials.Copper, Character.valueOf('B'), TagPrefix.plateDouble, GTMaterials.Copper);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lightning_rod", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Copper, 2).inputItems(TagPrefix.plateDouble, GTMaterials.Copper).outputItems(new ItemStack((ItemLike)Blocks.f_152587_)).duration(100).EUt(4L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chiseled_bookshelf", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13168_, 6).circuitMeta(4).outputItems(new ItemStack((ItemLike)Blocks.f_244299_)).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "lectern", new ItemStack((ItemLike)Blocks.f_50624_), "SSS", "WBW", "dSs", Character.valueOf('S'), ItemTags.f_13175_, Character.valueOf('W'), new UnificationEntry(TagPrefix.screw, GTMaterials.Wood), Character.valueOf('B'), new ItemStack((ItemLike)Blocks.f_50078_));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lectern", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13168_, 2).inputItems(TagPrefix.screw, GTMaterials.Wood, 2).inputItems(new ItemStack((ItemLike)Blocks.f_50078_)).outputItems(new ItemStack((ItemLike)Blocks.f_50624_)).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "brush", new ItemStack((ItemLike)Items.f_271356_), " F ", "fRr", " S ", Character.valueOf('S'), new UnificationEntry(TagPrefix.rodLong, GTMaterials.Wood), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Copper), Character.valueOf('F'), new ItemStack((ItemLike)Items.f_42402_));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("brush", new Object[0]).inputItems(TagPrefix.rodLong, GTMaterials.Wood).inputItems(TagPrefix.ring, GTMaterials.Copper).inputItems(new ItemStack((ItemLike)Items.f_42402_)).outputItems(new ItemStack((ItemLike)Items.f_271356_)).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "spyglass", new ItemStack((ItemLike)Items.f_151059_), "hGd", "LRS", "fP ", Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42454_), Character.valueOf('G'), new UnificationEntry(TagPrefix.lens, GTMaterials.Glass), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Gold), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Copper));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("spyglass", new Object[0]).inputItems(TagPrefix.lens, GTMaterials.Glass).inputItems(TagPrefix.ring, GTMaterials.Gold).inputItems(TagPrefix.plate, GTMaterials.Copper).inputItems(new ItemStack((ItemLike)Items.f_42454_)).outputItems(new ItemStack((ItemLike)Items.f_151059_)).duration(100).EUt(4L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("recovery_compass", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42522_)).inputItems(TagPrefix.plate, GTMaterials.Echo, 8).inputItems(TagPrefix.rod, GTMaterials.Echo).outputItems(new ItemStack((ItemLike)Items.f_220211_)).duration(400).EUt(30L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "respawn_anchor", new ItemStack((ItemLike)Items.f_42767_), "CCC", "GGG", "CCC", Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42754_), Character.valueOf('G'), new UnificationEntry(TagPrefix.plate, GTMaterials.Glowstone));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("respawn_anchor", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42754_, 6)).inputItems(TagPrefix.plate, GTMaterials.Glowstone, 3).outputItems(new ItemStack((ItemLike)Items.f_42767_)).duration(200).EUt(120L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "chain", new ItemStack((ItemLike)Items.f_42026_), " R ", "wR ", " R ", Character.valueOf('R'), new UnificationEntry(TagPrefix.round, GTMaterials.Iron));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chain", new Object[0]).inputItems(TagPrefix.round, GTMaterials.Iron, 3).outputItems(new ItemStack((ItemLike)Items.f_42026_)).duration(40).EUt(10L).save(provider);
            for (DyeColor color : DyeColor.values()) {
                RecipeAddition.addBedRecipe(provider, color);
            }
        } else {
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crafting_table", new Object[0]).duration(80).EUt(6L).circuitMeta(4).inputItems((TagKey<Item>)ItemTags.f_13168_, 4).outputItems(new ItemStack((ItemLike)Blocks.f_50091_)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("furnace", new Object[0]).circuitMeta(8).inputItems((TagKey<Item>)ItemTags.f_13166_, 8).outputItems(new ItemStack((ItemLike)Blocks.f_50094_)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("enchanting_table", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50080_, 4)).inputItems(TagPrefix.gem, GTMaterials.Diamond, 2).inputItems(new ItemStack((ItemLike)Items.f_42517_)).outputItems(new ItemStack((ItemLike)Blocks.f_50201_)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dispenser", new Object[0]).duration(100).EUt(GTValues.VA[1]).circuitMeta(1).inputItems((TagKey<Item>)ItemTags.f_13166_, 7).inputItems(new ItemStack((ItemLike)Items.f_42411_)).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.f_50061_)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dropper", new Object[0]).duration(100).EUt(GTValues.VA[1]).circuitMeta(2).inputItems((TagKey<Item>)ItemTags.f_13166_, 7).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new ItemStack((ItemLike)Blocks.f_50286_)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("observer_nether_quartz", new Object[0]).duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.f_13166_, 6).inputItems(TagPrefix.dust, GTMaterials.Redstone, 2).inputItems(TagPrefix.plate, GTMaterials.NetherQuartz).outputItems(new ItemStack((ItemLike)Blocks.f_50455_)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("observer_certus_quartz", new Object[0]).duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.f_13166_, 6).inputItems(TagPrefix.dust, GTMaterials.Redstone, 2).inputItems(TagPrefix.plate, GTMaterials.CertusQuartz).outputItems(new ItemStack((ItemLike)Blocks.f_50455_)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("observer_quartzite", new Object[0]).duration(100).EUt(GTValues.VA[1]).inputItems((TagKey<Item>)ItemTags.f_13166_, 6).inputItems(TagPrefix.dust, GTMaterials.Redstone, 2).inputItems(TagPrefix.plate, GTMaterials.Quartzite).outputItems(new ItemStack((ItemLike)Blocks.f_50455_)).save(provider);
        }
    }

    private static void addBedRecipe(Consumer<FinishedRecipe> provider, DyeColor color) {
        String colorName = color.m_41065_();
        VanillaRecipeHelper.addShapedRecipe(provider, colorName + "_bed", new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(colorName + "_bed"))), "WWW", "PPP", "FrF", Character.valueOf('W'), BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(colorName + "_carpet")), Character.valueOf('P'), ItemTags.f_13168_, Character.valueOf('F'), ItemTags.f_13176_);
    }

    private static void hardGlassRecipes(Consumer<FinishedRecipe> provider) {
    }

    private static void nerfPaperCrafting(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "paper_dust", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Paper, 2), "SSS", " m ", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_41909_));
        VanillaRecipeHelper.addShapedRecipe(provider, "sugar", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Sugar, 1), "Sm ", Character.valueOf('S'), new ItemStack((ItemLike)Items.f_41909_));
        VanillaRecipeHelper.addShapedRecipe(provider, "paper", new ItemStack((ItemLike)Items.f_42516_, 2), " r ", "SSS", " B ", Character.valueOf('S'), new UnificationEntry(TagPrefix.dust, GTMaterials.Paper), Character.valueOf('B'), new ItemStack((ItemLike)Items.f_42447_));
    }

    private static void hardAdvancedIronRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_door", new ItemStack((ItemLike)Items.f_42341_), "PTh", "PRS", "PPd", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('T'), new ItemStack((ItemLike)Blocks.f_50183_), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Steel), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Steel));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("iron_door", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Iron, 4).inputItems(new ItemStack((ItemLike)Blocks.f_50183_)).inputFluids(GTMaterials.Steel.getFluid(16L)).outputItems(new ItemStack((ItemLike)Items.f_42341_)).duration(400).EUt(GTValues.VA[0]).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "anvil", new ItemStack((ItemLike)Blocks.f_50322_), "BBB", "SBS", "PBP", Character.valueOf('B'), new UnificationEntry(TagPrefix.block, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_trapdoor", new ItemStack((ItemLike)Blocks.f_50376_), "SPS", "PTP", "sPd", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('T'), ItemTags.f_13178_);
        VanillaRecipeHelper.addShapedRecipe(provider, "minecart_iron", new ItemStack((ItemLike)Items.f_42449_), " h ", "PwP", "WPW", Character.valueOf('W'), GTItems.IRON_MINECART_WHEELS.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "minecart_steel", new ItemStack((ItemLike)Items.f_42449_), " h ", "PwP", "WPW", Character.valueOf('W'), GTItems.STEEL_MINECART_WHEELS.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Steel));
    }

    private static void flintAndSteelRequireSteel(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "flint_and_steel", new ItemStack((ItemLike)Items.f_42409_), "G", "F", "S", Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Steel), Character.valueOf('F'), new ItemStack((ItemLike)Items.f_42484_), Character.valueOf('S'), new UnificationEntry(TagPrefix.springSmall, GTMaterials.Steel));
    }

    private static void removeVanillaBlockRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "stone_slab_saw", new ItemStack((ItemLike)Blocks.f_50404_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50069_));
        VanillaRecipeHelper.addShapedRecipe(provider, "smooth_stone_slab_saw", new ItemStack((ItemLike)Blocks.f_50405_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50470_));
        VanillaRecipeHelper.addShapedRecipe(provider, "andesite_slab_saw", new ItemStack((ItemLike)Blocks.f_50600_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50334_));
        VanillaRecipeHelper.addShapedRecipe(provider, "granite_slab_saw", new ItemStack((ItemLike)Blocks.f_50651_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50122_));
        VanillaRecipeHelper.addShapedRecipe(provider, "diorite_slab_saw", new ItemStack((ItemLike)Blocks.f_50603_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50228_));
        VanillaRecipeHelper.addShapedRecipe(provider, "polished_andesite_slab_saw", new ItemStack((ItemLike)Blocks.f_50602_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50387_));
        VanillaRecipeHelper.addShapedRecipe(provider, "polished_granite_slab_saw", new ItemStack((ItemLike)Blocks.f_50643_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50175_));
        VanillaRecipeHelper.addShapedRecipe(provider, "polished_diorite_slab_saw", new ItemStack((ItemLike)Blocks.f_50646_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50281_));
        VanillaRecipeHelper.addShapedRecipe(provider, "sandstone_slab_saw", new ItemStack((ItemLike)Blocks.f_50406_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50062_));
        VanillaRecipeHelper.addShapedRecipe(provider, "smooth_sandstone_slab_saw", new ItemStack((ItemLike)Blocks.f_50649_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50471_));
        VanillaRecipeHelper.addShapedRecipe(provider, "red_sandstone_slab_saw", new ItemStack((ItemLike)Blocks.f_50467_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50394_));
        VanillaRecipeHelper.addShapedRecipe(provider, "smooth_red_sandstone_slab_saw", new ItemStack((ItemLike)Blocks.f_50644_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50473_));
        VanillaRecipeHelper.addShapedRecipe(provider, "cobblestone_slab_saw", new ItemStack((ItemLike)Blocks.f_50409_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50652_));
        VanillaRecipeHelper.addShapedRecipe(provider, "blackstone_slab_saw", new ItemStack((ItemLike)Blocks.f_50733_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50730_));
        VanillaRecipeHelper.addShapedRecipe(provider, "polished_blackstone_slab_saw", new ItemStack((ItemLike)Blocks.f_50708_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50734_));
        VanillaRecipeHelper.addShapedRecipe(provider, "polished_blackstone_brick_slab_saw", new ItemStack((ItemLike)Blocks.f_50738_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50735_));
        VanillaRecipeHelper.addShapedRecipe(provider, "brick_slab_saw", new ItemStack((ItemLike)Blocks.f_50410_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50076_));
        VanillaRecipeHelper.addShapedRecipe(provider, "mud_brick_slab_saw", new ItemStack((ItemLike)Blocks.f_220849_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_220844_));
        VanillaRecipeHelper.addShapedRecipe(provider, "stone_brick_slab_saw", new ItemStack((ItemLike)Blocks.f_50411_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50222_));
        VanillaRecipeHelper.addShapedRecipe(provider, "nether_brick_slab_saw", new ItemStack((ItemLike)Blocks.f_50412_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50197_));
        VanillaRecipeHelper.addShapedRecipe(provider, "red_nether_brick_slab_saw", new ItemStack((ItemLike)Blocks.f_50601_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50452_));
        VanillaRecipeHelper.addShapedRecipe(provider, "quartz_slab_saw", new ItemStack((ItemLike)Blocks.f_50413_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50333_));
        VanillaRecipeHelper.addShapedRecipe(provider, "smooth_quartz_slab_saw", new ItemStack((ItemLike)Blocks.f_50650_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50472_));
        VanillaRecipeHelper.addShapedRecipe(provider, "cut_copper_slab_saw", new ItemStack((ItemLike)Blocks.f_152570_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_152510_));
        VanillaRecipeHelper.addShapedRecipe(provider, "exposed_cut_copper_slab_saw", new ItemStack((ItemLike)Blocks.f_152569_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_152509_));
        VanillaRecipeHelper.addShapedRecipe(provider, "oxidized_cut_copper_slab_saw", new ItemStack((ItemLike)Blocks.f_152567_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_152507_));
        VanillaRecipeHelper.addShapedRecipe(provider, "weathered_cut_copper_slab_saw", new ItemStack((ItemLike)Blocks.f_152568_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_152508_));
        VanillaRecipeHelper.addShapedRecipe(provider, "waxed_cut_copper_slab_saw", new ItemStack((ItemLike)Blocks.f_152586_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_152578_));
        VanillaRecipeHelper.addShapedRecipe(provider, "waxed_exposed_cut_copper_slab_saw", new ItemStack((ItemLike)Blocks.f_152585_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_152577_));
        VanillaRecipeHelper.addShapedRecipe(provider, "waxed_oxidized_cut_copper_slab_saw", new ItemStack((ItemLike)Blocks.f_152583_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_152575_));
        VanillaRecipeHelper.addShapedRecipe(provider, "waxed_weathered_cut_copper_slab_saw", new ItemStack((ItemLike)Blocks.f_152584_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_152576_));
        VanillaRecipeHelper.addShapedRecipe(provider, "purpur_slab_saw", new ItemStack((ItemLike)Blocks.f_50469_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50492_));
        VanillaRecipeHelper.addShapedRecipe(provider, "end_stone_brick_slab_saw", new ItemStack((ItemLike)Blocks.f_50648_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50443_));
        VanillaRecipeHelper.addShapedRecipe(provider, "prismarine_slab_saw", new ItemStack((ItemLike)Blocks.f_50383_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50377_));
        VanillaRecipeHelper.addShapedRecipe(provider, "prismarine_brick_slab_saw", new ItemStack((ItemLike)Blocks.f_50384_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50378_));
        VanillaRecipeHelper.addShapedRecipe(provider, "dark_prismarine_slab_saw", new ItemStack((ItemLike)Blocks.f_50385_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50379_));
        VanillaRecipeHelper.addShapedRecipe(provider, "mossy_cobblestone_slab_saw", new ItemStack((ItemLike)Blocks.f_50647_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50079_));
        VanillaRecipeHelper.addShapedRecipe(provider, "mossy_stone_brick_slab_saw", new ItemStack((ItemLike)Blocks.f_50645_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50223_));
        VanillaRecipeHelper.addShapedRecipe(provider, "cut_sandstone_slab_saw", new ItemStack((ItemLike)Blocks.f_50407_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50064_));
        VanillaRecipeHelper.addShapedRecipe(provider, "cut_red_sandstone_slab_saw", new ItemStack((ItemLike)Blocks.f_50468_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50396_));
        VanillaRecipeHelper.addShapedRecipe(provider, "bamboo_mosaic_slab_saw", new ItemStack((ItemLike)Blocks.f_244230_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_244489_));
        GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("bamboo_mosaic_slab", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_243813_)).outputItems(new ItemStack((ItemLike)Items.f_244160_, 2)).duration(200).EUt(GTValues.VA[0]).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "cobbled_deepslate_slab_saw", new ItemStack((ItemLike)Blocks.f_152553_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_152551_));
        VanillaRecipeHelper.addShapedRecipe(provider, "polished_deepslate_slab_saw", new ItemStack((ItemLike)Blocks.f_152557_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_152555_));
        VanillaRecipeHelper.addShapedRecipe(provider, "deepslate_brick_slab_saw", new ItemStack((ItemLike)Blocks.f_152589_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_152591_));
        VanillaRecipeHelper.addShapedRecipe(provider, "deepslate_tile_slab_saw", new ItemStack((ItemLike)Blocks.f_152561_), "sS", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_152559_));
    }

    private static void createShovelRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "hPf", " S ", " S ", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood));
    }

    private static void createPickaxeRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "PII", "hSf", " S ", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('I'), new UnificationEntry(material.equals(GTMaterials.Diamond) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood));
    }

    private static void createAxeRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "PIf", "PS ", "hS ", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('I'), new UnificationEntry(material.equals(GTMaterials.Diamond) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood));
    }

    private static void createSwordRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, " P ", "hPf", " S ", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood));
    }

    private static void createHoeRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "PIf", "hS ", " S ", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('I'), new UnificationEntry(material.equals(GTMaterials.Diamond) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.Wood));
    }

    private static void createHelmetRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "PPP", "PhP", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material));
    }

    private static void createChestplateRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "PhP", "PPP", "PPP", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material));
    }

    private static void createLeggingsRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "PPP", "PhP", "P P", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material));
    }

    private static void createBootsRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "P P", "PhP", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material));
    }
}

