/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecyclingRecipes {
    private static final List<TagPrefix> DUST_ORDER = ImmutableList.of((Object)TagPrefix.dust, (Object)TagPrefix.dustSmall, (Object)TagPrefix.dustTiny);
    private static final List<TagPrefix> INGOT_ORDER = ImmutableList.of((Object)TagPrefix.block, (Object)TagPrefix.ingot, (Object)TagPrefix.nugget);

    public static void init(Consumer<FinishedRecipe> provider) {
        for (Map.Entry<ItemStack, ItemMaterialInfo> entry : ChemicalHelper.getAllItemInfos()) {
            ItemStack itemStack = entry.getKey();
            ItemMaterialInfo materialInfo = entry.getValue();
            ArrayList<MaterialStack> materialStacks = new ArrayList<MaterialStack>((Collection<MaterialStack>)materialInfo.getMaterials());
            RecyclingRecipes.registerRecyclingRecipes(provider, itemStack, materialStacks, false, null);
        }
    }

    public static void registerRecyclingRecipes(Consumer<FinishedRecipe> provider, ItemStack input, List<MaterialStack> components, boolean ignoreArcSmelting, @Nullable TagPrefix prefix) {
        List<MaterialStack> materials = components.stream().filter(stack -> stack.material().hasProperty(PropertyKey.DUST)).filter(stack -> stack.amount() >= 403200L).sorted(Comparator.comparingLong(ms -> -ms.amount())).toList();
        if (materials.isEmpty()) {
            return;
        }
        int voltageMultiplier = RecyclingRecipes.calculateVoltageMultiplier(components);
        if (prefix != TagPrefix.dust) {
            RecyclingRecipes.registerMaceratorRecycling(provider, input, components, voltageMultiplier);
        }
        if (prefix != null) {
            RecyclingRecipes.registerExtractorRecycling(provider, input, components, voltageMultiplier, prefix);
        }
        if (ignoreArcSmelting) {
            return;
        }
        if (components.size() == 1) {
            Material m = components.get(0).material();
            if (!m.hasProperty(PropertyKey.INGOT)) {
                return;
            }
            if (ChemicalHelper.getPrefix((ItemLike)input.m_41720_()) == TagPrefix.ingot && m.getProperty(PropertyKey.INGOT).getArcSmeltingInto() == m) {
                return;
            }
            if (prefix == TagPrefix.dust && m.hasFlag(MaterialFlags.IS_MAGNETIC)) {
                return;
            }
        }
        RecyclingRecipes.registerArcRecycling(provider, input, components, prefix);
    }

    private static void registerMaceratorRecycling(Consumer<FinishedRecipe> provider, ItemStack input, List<MaterialStack> materials, int multiplier) {
        List<ItemStack> outputs = RecyclingRecipes.finalizeOutputs(materials, GTRecipeTypes.MACERATOR_RECIPES.getMaxOutputs(ItemRecipeCapability.CAP), ChemicalHelper::getDust);
        UnificationEntry entry = ChemicalHelper.getUnificationEntry((ItemLike)input.m_41720_());
        TagKey<Item> inputTag = null;
        if (entry != null) {
            inputTag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
        }
        if (outputs.size() == 0) {
            return;
        }
        ResourceLocation itemPath = BuiltInRegistries.f_257033_.m_7981_((Object)input.m_41720_());
        GTRecipeBuilder builder = GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + itemPath.m_135815_(), new Object[0]).outputItems((ItemStack[])outputs.toArray(ItemStack[]::new)).duration(RecyclingRecipes.calculateDuration(outputs)).EUt(2L * (long)multiplier);
        if (inputTag == null) {
            builder.inputItems(input.m_41777_());
        } else {
            builder.inputItems(inputTag);
        }
        builder.save(provider);
    }

    private static void registerExtractorRecycling(Consumer<FinishedRecipe> provider, ItemStack input, List<MaterialStack> materials, int multiplier, @Nullable TagPrefix prefix) {
        ItemStack outputStack;
        UnificationEntry entry = ChemicalHelper.getUnificationEntry((ItemLike)input.m_41720_());
        TagKey<Item> inputTag = null;
        if (entry != null) {
            inputTag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
        }
        if (prefix != null && prefix.secondaryMaterials().isEmpty()) {
            MaterialStack ms2 = ChemicalHelper.getMaterial(input);
            if (ms2 == null || ms2.material() == null) {
                return;
            }
            Material m = ms2.material();
            if (m.hasProperty(PropertyKey.INGOT) && m.getProperty(PropertyKey.INGOT).getMacerateInto() != m) {
                m = m.getProperty(PropertyKey.INGOT).getMacerateInto();
            }
            if (!m.hasProperty(PropertyKey.FLUID) || m.getFluid() == null) {
                return;
            }
            if (prefix == TagPrefix.dust && m.hasProperty(PropertyKey.BLAST)) {
                return;
            }
            ResourceLocation itemPath = BuiltInRegistries.f_257033_.m_7981_((Object)input.m_41720_());
            GTRecipeBuilder builder = GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("extract_" + itemPath.m_135815_(), new Object[0]).outputFluids(m.getFluid((int)(ms2.amount() * 144L / 3628800L))).duration((int)Math.max(1L, ms2.amount() * ms2.material().getMass() / 3628800L)).EUt((long)GTValues.VA[1] * (long)multiplier);
            if (inputTag == null) {
                builder.inputItems(input.m_41777_());
            } else {
                builder.inputItems(inputTag);
            }
            builder.save(provider);
            return;
        }
        MaterialStack fluidMs = materials.stream().filter(ms -> ms.material().hasProperty(PropertyKey.FLUID) && ms.material().getFluid() != null).findFirst().orElse(null);
        if (fluidMs == null) {
            return;
        }
        MaterialStack itemMs = materials.stream().filter(ms -> !ms.material().equals(fluidMs.material())).findFirst().orElse(null);
        long duration = fluidMs.amount() * fluidMs.material().getMass();
        if (itemMs != null) {
            duration += itemMs.amount() * itemMs.material().getMass();
        }
        duration = Math.max(1L, duration / 3628800L);
        ResourceLocation itemPath = BuiltInRegistries.f_257033_.m_7981_((Object)input.m_41720_());
        GTRecipeBuilder extractorBuilder = GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("extract_" + itemPath.m_135815_(), new Object[0]).outputFluids(fluidMs.material().getFluid((int)(fluidMs.amount() * 144L / 3628800L))).duration((int)duration).EUt((long)GTValues.VA[1] * (long)multiplier);
        if (inputTag == null) {
            extractorBuilder.inputItems(input.m_41777_());
        } else {
            extractorBuilder.inputItems(inputTag);
        }
        if (itemMs != null && !(outputStack = ChemicalHelper.getIngotOrDust(itemMs)).m_41619_()) {
            extractorBuilder.outputItems(outputStack);
        }
        extractorBuilder.save(provider);
    }

    private static void registerArcRecycling(Consumer<FinishedRecipe> provider, ItemStack input, List<MaterialStack> materials, @Nullable TagPrefix prefix) {
        UnificationEntry entry = ChemicalHelper.getUnificationEntry((ItemLike)input.m_41720_());
        TagKey<Item> inputTag = null;
        if (entry != null) {
            inputTag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
        }
        MaterialStack ms = ChemicalHelper.getMaterial(input);
        if (prefix == TagPrefix.dust && ms != null && ms.material().hasProperty(PropertyKey.BLAST)) {
            return;
        }
        if (prefix == TagPrefix.block) {
            if (ms != null && !ms.material().hasProperty(PropertyKey.GEM)) {
                ItemStack output = ChemicalHelper.get(TagPrefix.ingot, ms.material().getProperty(PropertyKey.INGOT).getArcSmeltingInto(), 9);
                ResourceLocation itemPath = BuiltInRegistries.f_257033_.m_7981_((Object)input.m_41720_());
                GTRecipeBuilder builder = GTRecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder("arc_" + itemPath.m_135815_(), new Object[0]).outputItems(output).duration(RecyclingRecipes.calculateDuration(Collections.singletonList(output))).EUt(GTValues.VA[1]);
                if (inputTag == null) {
                    builder.inputItems(input.m_41777_());
                } else {
                    builder.inputItems(inputTag);
                }
                builder.save(provider);
            }
            return;
        }
        List<ItemStack> outputs = RecyclingRecipes.finalizeOutputs(materials = RecyclingRecipes.combineStacks(materials.stream().map(RecyclingRecipes::getArcSmeltingResult).filter(Objects::nonNull).collect(Collectors.toList())), GTRecipeTypes.ARC_FURNACE_RECIPES.getMaxOutputs(ItemRecipeCapability.CAP), RecyclingRecipes::getArcIngotOrDust);
        if (outputs.size() == 0) {
            return;
        }
        ResourceLocation itemPath = BuiltInRegistries.f_257033_.m_7981_((Object)input.m_41720_());
        GTRecipeBuilder builder = GTRecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder("arc_" + itemPath.m_135815_(), new Object[0]).outputItems((ItemStack[])outputs.toArray(ItemStack[]::new)).duration(RecyclingRecipes.calculateDuration(outputs)).EUt(GTValues.VA[1]);
        if (inputTag == null) {
            builder.inputItems(input.m_41777_());
        } else {
            builder.inputItems(inputTag);
        }
        builder.save(provider);
    }

    private static MaterialStack getArcSmeltingResult(MaterialStack materialStack) {
        Material arcSmelt;
        Material material = materialStack.material();
        long amount = materialStack.amount();
        if (material.hasFlag(MaterialFlags.EXPLOSIVE)) {
            return new MaterialStack(GTMaterials.Ash, amount / 16L);
        }
        if (material.hasFlag(MaterialFlags.FLAMMABLE)) {
            return new MaterialStack(GTMaterials.Ash, amount / 8L);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            return RecyclingRecipes.getGemArcSmeltResult(materialStack);
        }
        if (material.hasFlag(MaterialFlags.NO_SMELTING)) {
            return null;
        }
        if (material.hasProperty(PropertyKey.INGOT) && (arcSmelt = material.getProperty(PropertyKey.INGOT).getArcSmeltingInto()) != null) {
            return new MaterialStack(arcSmelt, amount);
        }
        return materialStack;
    }

    private static ItemStack getArcIngotOrDust(@NotNull MaterialStack stack) {
        if (stack.material() == GTMaterials.Carbon) {
            return ChemicalHelper.getDust(stack);
        }
        return ChemicalHelper.getIngotOrDust(stack);
    }

    private static MaterialStack getGemArcSmeltResult(MaterialStack materialStack) {
        Material material = materialStack.material();
        long amount = materialStack.amount();
        if (material.getMaterialComponents().stream().anyMatch(stack -> stack.material() == GTMaterials.Oxygen)) {
            return new MaterialStack(GTMaterials.Ash, amount / 8L);
        }
        if (material.getMaterialComponents().stream().anyMatch(stack -> stack.material() == GTMaterials.Carbon)) {
            return new MaterialStack(GTMaterials.Carbon, amount / 8L);
        }
        return new MaterialStack(GTMaterials.DarkAsh, amount / 8L);
    }

    private static int calculateVoltageMultiplier(List<MaterialStack> materials) {
        int highestTemp = 0;
        for (MaterialStack ms : materials) {
            BlastProperty prop;
            Material m = ms.material();
            if (m.hasProperty(PropertyKey.BLAST)) {
                prop = m.getProperty(PropertyKey.BLAST);
                if (prop.getBlastTemperature() <= highestTemp) continue;
                highestTemp = prop.getBlastTemperature();
                continue;
            }
            if (!m.hasFlag(MaterialFlags.IS_MAGNETIC) || !m.hasProperty(PropertyKey.INGOT) || !m.getProperty(PropertyKey.INGOT).getSmeltingInto().hasProperty(PropertyKey.BLAST) || (prop = m.getProperty(PropertyKey.INGOT).getSmeltingInto().getProperty(PropertyKey.BLAST)).getBlastTemperature() <= highestTemp) continue;
            highestTemp = prop.getBlastTemperature();
        }
        if (highestTemp == 0) {
            return 1;
        }
        if (highestTemp < 2000) {
            return 4;
        }
        return 16;
    }

    private static int calculateDuration(List<ItemStack> materials) {
        long duration = 0L;
        for (ItemStack is : materials) {
            MaterialStack ms = ChemicalHelper.getMaterial(is);
            if (ms == null) continue;
            duration += ms.amount() * ms.material().getMass() * (long)is.m_41613_();
        }
        return (int)Math.max(1L, duration / 3628800L);
    }

    private static List<MaterialStack> combineStacks(List<MaterialStack> rawList) {
        HashMap<Material, Long> materialStacksExploded = new HashMap<Material, Long>();
        for (MaterialStack ms : rawList) {
            long amount = materialStacksExploded.getOrDefault(ms.material(), 0L);
            materialStacksExploded.put(ms.material(), ms.amount() + amount);
        }
        return materialStacksExploded.entrySet().stream().map(e -> new MaterialStack((Material)e.getKey(), (Long)e.getValue())).collect(Collectors.toList());
    }

    private static List<ItemStack> finalizeOutputs(List<MaterialStack> materials, int maxOutputs, Function<MaterialStack, ItemStack> toItemStackMapper) {
        ArrayList<Tuple<ItemStack, MaterialStack>> outputs = new ArrayList<Tuple<ItemStack, MaterialStack>>();
        for (MaterialStack materialStack : materials) {
            ItemStack itemStack = toItemStackMapper.apply(materialStack);
            if (itemStack == ItemStack.f_41583_) continue;
            if (itemStack.m_41613_() > 64) {
                UnificationEntry entry = ChemicalHelper.getUnificationEntry((ItemLike)itemStack.m_41720_());
                if (entry == null) continue;
                TagPrefix prefix = entry.tagPrefix;
                if (prefix == TagPrefix.block || prefix == TagPrefix.dust) {
                    RecyclingRecipes.splitStacks(outputs, itemStack, entry);
                    continue;
                }
                ArrayList<Tuple<ItemStack, MaterialStack>> split = new ArrayList<Tuple<ItemStack, MaterialStack>>();
                ArrayList<Tuple<ItemStack, MaterialStack>> shrink = new ArrayList<Tuple<ItemStack, MaterialStack>>();
                RecyclingRecipes.splitStacks(split, itemStack, entry);
                RecyclingRecipes.shrinkStacks(shrink, itemStack, entry);
                if (((MaterialStack)((Tuple)split.get(0)).m_14419_()).amount() > ((MaterialStack)((Tuple)shrink.get(0)).m_14419_()).amount()) {
                    outputs.addAll(split);
                    continue;
                }
                outputs.addAll(shrink);
                continue;
            }
            outputs.add(new Tuple((Object)itemStack, (Object)materialStack));
        }
        outputs.sort(Comparator.comparingLong(e -> -((MaterialStack)e.m_14419_()).amount()));
        HashMap<MaterialStack, ItemStack> temp = new HashMap<MaterialStack, ItemStack>();
        for (Tuple tuple : outputs) {
            boolean isInMap = false;
            for (MaterialStack ms : temp.keySet()) {
                if (ms.material() != ((MaterialStack)tuple.m_14419_()).material()) continue;
                isInMap = true;
                break;
            }
            if (isInMap) continue;
            temp.put((MaterialStack)tuple.m_14419_(), (ItemStack)tuple.m_14418_());
        }
        temp.putAll(outputs.stream().filter(t -> !temp.containsKey(t.m_14419_())).collect(Collectors.toMap(Tuple::m_14419_, Tuple::m_14418_)));
        List list = temp.entrySet().stream().filter(e -> RecyclingRecipes.isAshMaterial((MaterialStack)e.getKey())).sorted(Comparator.comparingLong(e -> -((MaterialStack)e.getKey()).amount())).map(Map.Entry::getValue).collect(Collectors.toList());
        List<ItemStack> list2 = temp.entrySet().stream().sorted(Comparator.comparingLong(e -> -((MaterialStack)e.getKey()).amount())).filter(e -> !RecyclingRecipes.isAshMaterial((MaterialStack)e.getKey())).limit(maxOutputs).map(Map.Entry::getValue).collect(Collectors.toList());
        for (int i = 0; i < list.size() && list2.size() < maxOutputs; ++i) {
            list2.add((ItemStack)list.get(i));
        }
        return list2;
    }

    private static void splitStacks(List<Tuple<ItemStack, MaterialStack>> list, ItemStack originalStack, UnificationEntry entry) {
        int amount;
        for (amount = originalStack.m_41613_(); amount > 64; amount -= 64) {
            list.add((Tuple<ItemStack, MaterialStack>)new Tuple((Object)GTUtil.copyAmount(64, originalStack), (Object)new MaterialStack(entry.material, entry.tagPrefix.getMaterialAmount(entry.material) * 64L)));
        }
        list.add((Tuple<ItemStack, MaterialStack>)new Tuple((Object)GTUtil.copyAmount(amount, originalStack), (Object)new MaterialStack(entry.material, entry.tagPrefix.getMaterialAmount(entry.material) * (long)amount)));
    }

    private static void shrinkStacks(List<Tuple<ItemStack, MaterialStack>> list, ItemStack originalStack, UnificationEntry entry) {
        long singleStackAmount;
        Material material = entry.material;
        long materialAmount = (long)originalStack.m_41613_() * entry.tagPrefix.getMaterialAmount(material);
        List<TagPrefix> chosenList = material.hasProperty(PropertyKey.INGOT) ? INGOT_ORDER : DUST_ORDER;
        HashMap<TagPrefix, MaterialStack> tempList = new HashMap<TagPrefix, MaterialStack>();
        for (TagPrefix prefix : chosenList) {
            if (materialAmount / prefix.getMaterialAmount(material) == 0L) continue;
            long newAmount = materialAmount / prefix.getMaterialAmount(material);
            tempList.put(prefix, new MaterialStack(material, newAmount * prefix.getMaterialAmount(material)));
            materialAmount %= prefix.getMaterialAmount(material);
        }
        if (tempList.containsKey(chosenList.get(0))) {
            TagPrefix prefix = chosenList.get(0);
            MaterialStack ms = (MaterialStack)tempList.get(prefix);
            RecyclingRecipes.splitStacks(list, ChemicalHelper.get(chosenList.get(0), ms.material(), (int)(ms.amount() / prefix.getMaterialAmount(material))), new UnificationEntry(prefix, material));
        }
        TagPrefix mediumPrefix = chosenList.get(1);
        TagPrefix smallestPrefix = chosenList.get(2);
        MaterialStack mediumMS = (MaterialStack)tempList.get(mediumPrefix);
        MaterialStack smallestMS = (MaterialStack)tempList.get(smallestPrefix);
        if (mediumMS != null && smallestMS != null && (singleStackAmount = mediumMS.amount() + smallestMS.amount()) / smallestPrefix.getMaterialAmount(material) <= 64L) {
            list.add((Tuple<ItemStack, MaterialStack>)new Tuple((Object)ChemicalHelper.get(smallestPrefix, material, (int)(singleStackAmount / smallestPrefix.getMaterialAmount(material))), (Object)new MaterialStack(material, singleStackAmount)));
            return;
        }
        if (mediumMS != null) {
            list.add((Tuple<ItemStack, MaterialStack>)new Tuple((Object)ChemicalHelper.get(mediumPrefix, material, (int)(mediumMS.amount() / mediumPrefix.getMaterialAmount(material))), (Object)new MaterialStack(material, mediumMS.amount())));
        }
        if (smallestMS != null) {
            list.add((Tuple<ItemStack, MaterialStack>)new Tuple((Object)ChemicalHelper.get(smallestPrefix, material, (int)(smallestMS.amount() / smallestPrefix.getMaterialAmount(material))), (Object)new MaterialStack(material, smallestMS.amount())));
        }
    }

    private static boolean isAshMaterial(MaterialStack ms) {
        return ms.material() == GTMaterials.Ash || ms.material() == GTMaterials.DarkAsh || ms.material() == GTMaterials.Carbon;
    }
}

