/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.WoodTypeEntry;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;

public class WoodMachineRecipes {
    private static List<WoodTypeEntry> DEFAULT_ENTRIES;

    public static void init(Consumer<FinishedRecipe> provider) {
        WoodMachineRecipes.registerGTWoodRecipes(provider);
        WoodMachineRecipes.registerWoodRecipes(provider);
        WoodMachineRecipes.registerPyrolyseOvenRecipes(provider);
    }

    private static List<WoodTypeEntry> getDefaultEntries() {
        if (DEFAULT_ENTRIES == null) {
            String mcModId = "minecraft";
            DEFAULT_ENTRIES = Arrays.asList(new WoodTypeEntry.Builder("minecraft", "oak").planks(Items.f_42647_, "oak_planks").log(Items.f_41837_).removeCharcoalRecipe().strippedLog(Items.f_41845_).wood(Items.f_41888_).strippedWood(Items.f_41880_).door(Items.f_42342_, "oak_door").trapdoor(Items.f_42056_, "oak_trapdoor").slab(Items.f_41914_, "oak_slab").fence(Items.f_42038_, "oak_fence").fenceGate(Items.f_42030_, "oak_fence_gate").stairs(Items.f_42008_, "oak_stairs").boat(Items.f_42453_, "oak_boat").chestBoat(Items.f_220207_, "oak_chest_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "spruce").planks(Items.f_42700_, "spruce_planks").log(Items.f_41838_).removeCharcoalRecipe().strippedLog(Items.f_41846_).wood(Items.f_41889_).strippedWood(Items.f_41881_).door(Items.f_42343_, "spruce_door").trapdoor(Items.f_42057_, "spruce_trapdoor").slab(Items.f_41915_, "spruce_slab").fence(Items.f_42039_, "spruce_fence").fenceGate(Items.f_42031_, "spruce_fence_gate").stairs(Items.f_42111_, "spruce_stairs").boat(Items.f_42742_, "spruce_boat").chestBoat(Items.f_220208_, "spruce_chest_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "birch").planks(Items.f_42753_, "birch_planks").log(Items.f_41839_).removeCharcoalRecipe().strippedLog(Items.f_41847_).wood(Items.f_41890_).strippedWood(Items.f_41882_).door(Items.f_42344_, "birch_door").trapdoor(Items.f_42058_, "birch_trapdoor").slab(Items.f_41916_, "birch_slab").fence(Items.f_42040_, "birch_fence").fenceGate(Items.f_42032_, "birch_fence_gate").stairs(Items.f_42112_, "birch_stairs").boat(Items.f_42743_, "birch_boat").chestBoat(Items.f_220200_, "birch_chest_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "jungle").planks(Items.f_42794_, "jungle_planks").log(Items.f_41840_).removeCharcoalRecipe().strippedLog(Items.f_41848_).wood(Items.f_41891_).strippedWood(Items.f_41883_).door(Items.f_42345_, "jungle_door").trapdoor(Items.f_42059_, "jungle_trapdoor").slab(Items.f_41917_, "jungle_slab").fence(Items.f_42041_, "jungle_fence").fenceGate(Items.f_42033_, "jungle_fence_gate").stairs(Items.f_42113_, "jungle_stairs").boat(Items.f_42744_, "jungle_boat").chestBoat(Items.f_220201_, "jungle_chest_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "acacia").planks(Items.f_42795_, "acacia_planks").log(Items.f_41841_).removeCharcoalRecipe().strippedLog(Items.f_41849_).wood(Items.f_41892_).strippedWood(Items.f_41884_).door(Items.f_42346_, "acacia_door").trapdoor(Items.f_42060_, "acacia_trapdoor").slab(Items.f_41918_, "acacia_slab").fence(Items.f_42042_, "acacia_fence").fenceGate(Items.f_42034_, "acacia_fence_gate").stairs(Items.f_42202_, "acacia_stairs").boat(Items.f_42745_, "acacia_boat").chestBoat(Items.f_220202_, "acacia_chest_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "dark_oak").planks(Items.f_42796_, "dark_oak_planks").log(Items.f_41842_).removeCharcoalRecipe().strippedLog(Items.f_41850_).wood(Items.f_41893_).strippedWood(Items.f_41885_).door(Items.f_42347_, "dark_oak_door").trapdoor(Items.f_42061_, "dark_oak_trapdoor").slab(Items.f_41919_, "dark_oak_slab").fence(Items.f_42043_, "dark_oak_fence").fenceGate(Items.f_42035_, "dark_oak_fence_gate").stairs(Items.f_42203_, "dark_oak_stairs").boat(Items.f_42746_, "dark_oak_boat").chestBoat(Items.f_220203_, "dark_oak_chest_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "bamboo").planks(Items.f_243694_, "bamboo_planks").logTag(TagUtil.createItemTag("bamboo_blocks", true)).log(Items.f_256933_).removeCharcoalRecipe().strippedLog(Items.f_256923_).door(Items.f_243820_, "bamboo_door").trapdoor(Items.f_244311_, "bamboo_trapdoor").slab(Items.f_243860_, "bamboo_slab").fence(Items.f_244106_, "bamboo_fence").fenceGate(Items.f_244345_, "bamboo_fence_gate").stairs(Items.f_244189_, "bamboo_stairs").boat(Items.f_244624_, "bamboo_raft").chestBoat(Items.f_244260_, "bamboo_chest_raft").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "cherry").planks(Items.f_271154_, "cherry_planks").log(Items.f_271090_).removeCharcoalRecipe().strippedLog(Items.f_271164_).wood(Items.f_271302_).strippedWood(Items.f_271182_).door(Items.f_271459_, "cherry_door").trapdoor(Items.f_271114_, "cherry_trapdoor").slab(Items.f_271349_, "cherry_slab").fence(Items.f_271316_, "cherry_fence").fenceGate(Items.f_271205_, "cherry_fence_gate").stairs(Items.f_271397_, "cherry_stairs").boat(Items.f_271386_, "cherry_boat").chestBoat(Items.f_271490_, "cherry_chest_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "mangrove").planks(Items.f_220174_, "mangrove_planks").log(Items.f_220179_).removeCharcoalRecipe().strippedLog(Items.f_220182_).wood(Items.f_220177_).strippedWood(Items.f_220176_).door(Items.f_220197_, "mangrove_door").trapdoor(Items.f_220198_, "mangrove_trapdoor").slab(Items.f_220183_, "mangrove_slab").fence(Items.f_220188_, "mangrove_fence").fenceGate(Items.f_220206_, "mangrove_fence_gate").stairs(Items.f_220189_, "mangrove_stairs").boat(Items.f_220204_, "mangrove_boat").chestBoat(Items.f_220205_, "mangrove_chest_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "crimson").planks(Items.f_42797_, "crimson_planks").logTag(TagUtil.createItemTag("crimson_stems", true)).log(Items.f_41843_).removeCharcoalRecipe().strippedLog(Items.f_41851_).wood(Items.f_41894_).strippedWood(Items.f_41886_).door(Items.f_42348_, "crimson_door").trapdoor(Items.f_42062_, "crimson_trapdoor").slab(Items.f_41920_, "crimson_slab").fence(Items.f_42044_, "crimson_fence").fenceGate(Items.f_42036_, "crimson_fence_gate").stairs(Items.f_42114_, "crimson_stairs").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "warped").planks(Items.f_42798_, "warped_planks").logTag(TagUtil.createItemTag("warped_stems", true)).log(Items.f_41844_).removeCharcoalRecipe().strippedLog(Items.f_41879_).wood(Items.f_41895_).strippedWood(Items.f_41887_).door(Items.f_42349_, "warped_door").trapdoor(Items.f_42063_, "warped_trapdoor").slab(Items.f_41921_, "warped_slab").fence(Items.f_42045_, "warped_fence").fenceGate(Items.f_42037_, "warped_fence_gate").stairs(Items.f_42115_, "warped_stairs").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("gtceu", "rubber").planks(GTBlocks.RUBBER_PLANK.m_5456_(), null).log(GTBlocks.RUBBER_LOG.m_5456_()).addCharcoalRecipe().strippedLog(GTBlocks.STRIPPED_RUBBER_LOG.m_5456_()).wood(GTBlocks.RUBBER_WOOD.m_5456_()).strippedWood(GTBlocks.STRIPPED_RUBBER_WOOD.m_5456_()).door(GTBlocks.RUBBER_DOOR.m_5456_(), null).trapdoor(GTBlocks.RUBBER_TRAPDOOR.m_5456_(), null).slab(GTBlocks.RUBBER_SLAB.m_5456_(), null).addSlabRecipe().fence(GTBlocks.RUBBER_FENCE.m_5456_(), null).fenceGate(GTBlocks.RUBBER_FENCE_GATE.m_5456_(), null).stairs(GTBlocks.RUBBER_STAIRS.m_5456_(), null).addStairsRecipe().generateLogToPlankRecipe(false).registerAllTags().registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("gtceu", "treated").planks(GTBlocks.TREATED_WOOD_PLANK.m_5456_(), null).door(GTBlocks.TREATED_WOOD_DOOR.m_5456_(), null).trapdoor(GTBlocks.TREATED_WOOD_TRAPDOOR.m_5456_(), null).slab(GTBlocks.TREATED_WOOD_SLAB.m_5456_(), null).addSlabRecipe().fence(GTBlocks.TREATED_WOOD_FENCE.m_5456_(), null).fenceGate(GTBlocks.TREATED_WOOD_FENCE_GATE.m_5456_(), null).stairs(GTBlocks.TREATED_WOOD_STAIRS.m_5456_(), null).addStairsRecipe().material(GTMaterials.TreatedWood).generateLogToPlankRecipe(false).registerAllTags().registerAllUnificationInfo().build());
            return DEFAULT_ENTRIES;
        }
        return DEFAULT_ENTRIES;
    }

    public static void registerUnificationInfo() {
        for (WoodTypeEntry entry : WoodMachineRecipes.getDefaultEntries()) {
            WoodMachineRecipes.registerWoodUnificationInfo(entry);
        }
    }

    private static void registerWoodRecipes(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.nerfWoodCrafting) {
            VanillaRecipeHelper.addShapedRecipe(provider, "stick_saw", new ItemStack((ItemLike)Items.f_42398_, 4), "s", "P", "P", Character.valueOf('P'), ItemTags.f_13168_);
            VanillaRecipeHelper.addShapedRecipe(provider, "stick_normal", new ItemStack((ItemLike)Items.f_42398_, 2), "P", "P", Character.valueOf('P'), ItemTags.f_13168_);
        }
        for (WoodTypeEntry entry : WoodMachineRecipes.getDefaultEntries()) {
            WoodMachineRecipes.registerWoodTypeRecipe(provider, entry);
        }
    }

    public static void registerWoodUnificationInfo(@NotNull WoodTypeEntry entry) {
        for (Item log_ : entry.getLogs()) {
            if (log_ == null || !entry.addLogOreDict) continue;
            ChemicalHelper.registerUnificationItems(TagPrefix.log, entry.material, new ItemLike[]{log_});
        }
        if (entry.addPlanksOreDict) {
            ChemicalHelper.registerUnificationItems(TagPrefix.planks, entry.material, new ItemLike[]{entry.planks});
        }
        if (entry.addPlanksUnificationInfo) {
            ChemicalHelper.registerMaterialInfo((ItemLike)entry.planks, new ItemMaterialInfo(new MaterialStack(entry.material, 3628800L)));
        }
        if (entry.door != null) {
            if (entry.addDoorsOreDict) {
                ChemicalHelper.registerUnificationItems(TagPrefix.door, entry.material, new ItemLike[]{entry.door});
            }
            if (entry.addDoorsUnificationInfo) {
                ChemicalHelper.registerMaterialInfo((ItemLike)entry.door, ConfigHolder.INSTANCE.recipes.hardWoodRecipes ? new ItemMaterialInfo(new MaterialStack(entry.material, 7257600L), new MaterialStack(GTMaterials.Iron, 403200L)) : new ItemMaterialInfo(new MaterialStack(entry.material, 7257600L)));
            }
        }
        if (entry.slab != null) {
            if (entry.addSlabsOreDict) {
                ChemicalHelper.registerUnificationItems(TagPrefix.slab, entry.material, new ItemLike[]{entry.slab});
            }
            if (entry.addSlabsUnificationInfo) {
                ChemicalHelper.registerMaterialInfo((ItemLike)entry.slab, new ItemMaterialInfo(new MaterialStack(entry.material, 1814400L)));
            }
        }
        if (entry.fence != null) {
            if (entry.addFencesOreDict) {
                ChemicalHelper.registerUnificationItems(TagPrefix.fence, entry.material, new ItemLike[]{entry.fence});
            }
            if (entry.addFencesUnificationInfo) {
                ChemicalHelper.registerMaterialInfo((ItemLike)entry.fence, new ItemMaterialInfo(new MaterialStack(entry.material, 3628800L)));
            }
        }
        if (entry.fenceGate != null) {
            if (entry.addFenceGatesOreDict) {
                ChemicalHelper.registerUnificationItems(TagPrefix.fenceGate, entry.material, new ItemLike[]{entry.fenceGate});
            }
            if (entry.addFenceGatesUnificationInfo) {
                ChemicalHelper.registerMaterialInfo((ItemLike)entry.fenceGate, new ItemMaterialInfo(new MaterialStack(entry.material, 10886400L)));
            }
        }
        if (entry.stairs != null) {
            if (entry.addStairsOreDict) {
                ChemicalHelper.registerUnificationItems(TagPrefix.stairs, entry.material, new ItemLike[]{entry.stairs});
            }
            if (entry.addStairsUnificationInfo) {
                ChemicalHelper.registerMaterialInfo((ItemLike)entry.stairs, new ItemMaterialInfo(new MaterialStack(entry.material, 5443200L)));
            }
        }
        if (entry.boat != null && entry.addBoatsUnificationInfo) {
            ChemicalHelper.registerMaterialInfo((ItemLike)entry.boat, new ItemMaterialInfo(new MaterialStack(entry.material, 18144000L)));
        }
    }

    public static void registerWoodTypeRecipe(Consumer<FinishedRecipe> provider, @NotNull WoodTypeEntry entry) {
        boolean hasPlanksRecipe;
        String name = entry.woodName;
        TagKey<Item> logTag = entry.logTag;
        boolean bl = hasPlanksRecipe = entry.planksRecipeName != null;
        if (entry.planks == null) {
            throw new IllegalStateException("Could not find planks form of WoodTypeEntry '" + name + "'.");
        }
        if (entry.generateLogToPlankRecipe) {
            if (ConfigHolder.INSTANCE.recipes.nerfWoodCrafting) {
                VanillaRecipeHelper.addShapelessRecipe(provider, (String)(hasPlanksRecipe ? entry.planksRecipeName : name + "_planks"), new ItemStack((ItemLike)entry.planks, 2), logTag);
            } else if (!hasPlanksRecipe) {
                VanillaRecipeHelper.addShapelessRecipe(provider, name + "_planks", new ItemStack((ItemLike)entry.planks, 4), logTag);
            }
            VanillaRecipeHelper.addShapedRecipe(provider, name + "_planks_saw", new ItemStack((ItemLike)entry.planks, ConfigHolder.INSTANCE.recipes.nerfWoodCrafting ? 4 : 6), "s", "L", Character.valueOf('L'), logTag);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder(name + "_planks", new Object[0]).inputItems(logTag).outputItems(new ItemStack((ItemLike)entry.planks, 6)).outputItems(TagPrefix.dust, GTMaterials.Wood, 2).duration(200).EUt(GTValues.VA[0]).save(provider);
        }
        if (entry.door != null) {
            boolean hasDoorRecipe;
            boolean bl2 = hasDoorRecipe = entry.doorRecipeName != null;
            if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                Object recipeName;
                Object object = recipeName = hasDoorRecipe ? entry.doorRecipeName : name + "_door";
                if (entry.trapdoor != null) {
                    VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeName, new ItemStack((ItemLike)entry.door), "PTd", "PRS", "PPs", Character.valueOf('P'), entry.planks, Character.valueOf('T'), entry.trapdoor, Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
                    GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_door", new Object[0]).inputItems(entry.trapdoor).inputItems(new ItemStack((ItemLike)entry.planks, 4)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(entry.door).duration(400).EUt(4L).save(provider);
                } else {
                    VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeName, new ItemStack((ItemLike)entry.door), "PTd", "PRS", "PPs", Character.valueOf('P'), entry.planks, Character.valueOf('T'), ItemTags.f_13178_, Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
                    GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_door", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13178_).inputItems(new ItemStack((ItemLike)entry.planks, 4)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(entry.door).duration(400).EUt(4L).save(provider);
                }
            } else {
                if (!hasDoorRecipe) {
                    VanillaRecipeHelper.addShapedRecipe(provider, name + "_door", new ItemStack((ItemLike)entry.door, 3), "PP", "PP", "PP", Character.valueOf('P'), entry.planks);
                }
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_door", new Object[0]).inputItems(new ItemStack((ItemLike)entry.planks, 6)).outputItems(new ItemStack((ItemLike)entry.door, 3)).circuitMeta(6).duration(600).EUt(4L).save(provider);
            }
        }
        if (entry.stairs != null) {
            boolean hasStairRecipe;
            boolean bl3 = hasStairRecipe = entry.stairsRecipeName != null;
            if (entry.addStairsCraftingRecipe) {
                VanillaRecipeHelper.addShapedRecipe(provider, (String)(hasStairRecipe ? entry.stairsRecipeName : name + "_stairs"), new ItemStack((ItemLike)entry.stairs, 4), "P  ", "PP ", "PPP", Character.valueOf('P'), entry.planks);
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_stairs", new Object[0]).inputItems(new ItemStack((ItemLike)entry.planks, 6)).outputItems(new ItemStack((ItemLike)entry.stairs, 4)).circuitMeta(7).EUt(1L).duration(100).save(provider);
        }
        if (entry.slab != null) {
            if (entry.addSlabCraftingRecipe && !ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_slab", new ItemStack((ItemLike)entry.slab, 6), "PPP", Character.valueOf('P'), entry.planks);
            }
            VanillaRecipeHelper.addShapedRecipe(provider, name + "_slab_saw", new ItemStack((ItemLike)entry.slab, 2), "sS", Character.valueOf('S'), entry.planks);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder(name + "_slab", new Object[0]).inputItems(entry.planks).outputItems(new ItemStack((ItemLike)entry.slab, 2)).duration(200).EUt(GTValues.VA[0]).save(provider);
        }
        if (entry.fence != null) {
            boolean hasFenceRecipe;
            boolean bl4 = hasFenceRecipe = entry.fenceRecipeName != null;
            if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, (String)(hasFenceRecipe ? entry.fenceRecipeName : name + "_fence"), new ItemStack((ItemLike)entry.fence), "PSP", "PSP", "PSP", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick());
            } else if (!hasFenceRecipe) {
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_fence", new ItemStack((ItemLike)entry.fence, 3), "PSP", "PSP", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick());
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_fence", new Object[0]).inputItems(entry.planks).outputItems(entry.fence).circuitMeta(1).duration(100).EUt(4L).save(provider);
        }
        if (entry.fenceGate != null) {
            boolean hasFenceGateRecipe;
            boolean bl5 = hasFenceGateRecipe = entry.fenceGateRecipeName != null;
            if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, (String)(hasFenceGateRecipe ? entry.fenceGateRecipeName : name + "_fence_gate"), new ItemStack((ItemLike)entry.fenceGate), "F F", "SPS", "SPS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick(), Character.valueOf('F'), Items.f_42484_);
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_fence_gate_screws", new ItemStack((ItemLike)entry.fenceGate, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick(), Character.valueOf('I'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
            } else if (!hasFenceGateRecipe) {
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_fence_gate", new ItemStack((ItemLike)entry.fenceGate), "SPS", "SPS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick());
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_fence_gate", new Object[0]).inputItems(new ItemStack((ItemLike)entry.planks, 2)).inputItems((TagKey<Item>)Tags.Items.RODS_WOODEN, 2).outputItems(entry.fenceGate).circuitMeta(2).duration(100).EUt(4L).save(provider);
        }
        if (entry.boat != null) {
            boolean hasBoatRecipe;
            boolean bl6 = hasBoatRecipe = entry.boatRecipeName != null;
            if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                if (entry.slab != null) {
                    VanillaRecipeHelper.addShapedRecipe(provider, (String)(hasBoatRecipe ? entry.boatRecipeName : name + "_boat"), new ItemStack((ItemLike)entry.boat), "PHP", "PkP", "SSS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.slab, Character.valueOf('H'), ItemTags.f_271138_);
                }
            } else if (!hasBoatRecipe) {
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_boat", new ItemStack((ItemLike)entry.boat), "P P", "PPP", Character.valueOf('P'), entry.planks);
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_boat", new Object[0]).inputItems(new ItemStack((ItemLike)entry.planks, 5)).outputItems(entry.boat).circuitMeta(15).duration(100).EUt(4L).save(provider);
            if (entry.chestBoat != null) {
                boolean hasChestBoatRecipe;
                boolean bl7 = hasChestBoatRecipe = entry.chestBoatRecipeName != null;
                if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                    if (entry.boat != null) {
                        VanillaRecipeHelper.addShapedRecipe(provider, (String)(hasChestBoatRecipe ? entry.chestBoatRecipeName : name + "_chest_boat"), new ItemStack((ItemLike)entry.chestBoat), " B ", "SCS", " w ", Character.valueOf('B'), entry.boat, Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN);
                    }
                } else if (!hasChestBoatRecipe) {
                    VanillaRecipeHelper.addShapelessRecipe(provider, name + "_chest_boat", new ItemStack((ItemLike)entry.chestBoat), entry.boat, Tags.Items.CHESTS);
                }
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_chest_boat", new Object[0]).inputItems(new ItemStack((ItemLike)entry.boat)).inputItems((TagKey<Item>)Tags.Items.CHESTS).outputItems(entry.chestBoat).circuitMeta(16).duration(100).EUt(4L).save(provider);
            }
        }
    }

    private static void registerGTWoodRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "treated_wood_planks", GTBlocks.TREATED_WOOD_PLANK.asStack(8), "PPP", "PBP", "PPP", Character.valueOf('P'), ItemTags.f_13168_, Character.valueOf('B'), FluidUtil.getFilledBucket((net.minecraftforge.fluids.FluidStack)FluidHelperImpl.toFluidStack((FluidStack)GTMaterials.Creosote.getFluid(1000L))));
        VanillaRecipeHelper.addShapedRecipe(provider, "treated_wood_stick", ChemicalHelper.get(TagPrefix.rod, GTMaterials.TreatedWood, ConfigHolder.INSTANCE.recipes.nerfWoodCrafting ? 2 : 4), "L", "L", Character.valueOf('L'), GTBlocks.TREATED_WOOD_PLANK.m_5456_());
        if (ConfigHolder.INSTANCE.recipes.nerfWoodCrafting) {
            VanillaRecipeHelper.addShapedRecipe(provider, "treated_wood_stick_saw", ChemicalHelper.get(TagPrefix.rod, GTMaterials.TreatedWood, 4), "s", "L", "L", Character.valueOf('L'), GTBlocks.TREATED_WOOD_PLANK.m_5456_());
        }
        VanillaRecipeHelper.addShapelessRecipe(provider, "rubber_button", GTBlocks.RUBBER_BUTTON.asStack(), GTBlocks.RUBBER_PLANK.asStack());
        VanillaRecipeHelper.addShapelessRecipe(provider, "treated_wood_button", GTBlocks.TREATED_WOOD_BUTTON.asStack(), GTBlocks.TREATED_WOOD_PLANK.asStack());
        VanillaRecipeHelper.addShapedRecipe(provider, "rubber_pressure_plate", GTBlocks.RUBBER_PRESSURE_PLATE.asStack(), "aa", Character.valueOf('a'), GTBlocks.RUBBER_PLANK.asStack());
        VanillaRecipeHelper.addShapedRecipe(provider, "treated_wood_plate", GTBlocks.TREATED_WOOD_PRESSURE_PLATE.asStack(), "aa", Character.valueOf('a'), GTBlocks.TREATED_WOOD_PLANK.asStack());
        if (ConfigHolder.INSTANCE.recipes.nerfWoodCrafting) {
            VanillaRecipeHelper.addShapelessRecipe(provider, "rubber_planks", GTBlocks.RUBBER_PLANK.asStack(2), GTBlocks.RUBBER_LOG.m_5456_());
        } else {
            VanillaRecipeHelper.addShapelessRecipe(provider, "rubber_planks", GTBlocks.RUBBER_PLANK.asStack(4), GTBlocks.RUBBER_LOG.m_5456_());
        }
        VanillaRecipeHelper.addShapedRecipe(provider, "rubber_planks_saw", GTBlocks.RUBBER_PLANK.asStack(ConfigHolder.INSTANCE.recipes.nerfWoodCrafting ? 4 : 6), "s", "L", Character.valueOf('L'), GTBlocks.RUBBER_LOG.m_5456_());
        GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("rubber_planks", new Object[0]).inputItems(GTBlocks.RUBBER_LOG.m_5456_()).outputItems(GTBlocks.RUBBER_PLANK.asStack(6)).outputItems(TagPrefix.dust, GTMaterials.Wood, 2).duration(200).EUt(GTValues.VA[0]).save(provider);
    }

    public static void hardWoodRecipes(Consumer<ResourceLocation> registry) {
        if (ConfigHolder.INSTANCE.recipes.nerfWoodCrafting) {
            registry.accept(new ResourceLocation("minecraft:stick"));
        }
        for (WoodTypeEntry entry : WoodMachineRecipes.getDefaultEntries()) {
            WoodMachineRecipes.hardWoodTypeRecipes(registry, entry);
        }
    }

    private static void hardWoodTypeRecipes(Consumer<ResourceLocation> registry, @NotNull WoodTypeEntry entry) {
        if (ConfigHolder.INSTANCE.recipes.nerfWoodCrafting && entry.planksRecipeName != null) {
            registry.accept(new ResourceLocation(entry.modid, entry.planksRecipeName));
        }
        if (ConfigHolder.INSTANCE.recipes.harderCharcoalRecipe && entry.removeCharcoalRecipe) {
            registry.accept(new ResourceLocation("charcoal"));
        }
        if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
            if (entry.door != null && entry.doorRecipeName != null) {
                registry.accept(new ResourceLocation(entry.modid, entry.doorRecipeName));
            }
            if (entry.slab != null) {
                if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes && entry.slabRecipeName != null) {
                    registry.accept(new ResourceLocation(entry.modid, entry.slabRecipeName));
                }
                if (entry.boat != null && entry.boatRecipeName != null) {
                    registry.accept(new ResourceLocation(entry.modid, entry.boatRecipeName));
                }
            }
            if (entry.fence != null && entry.fenceRecipeName != null) {
                registry.accept(new ResourceLocation(entry.modid, entry.fenceRecipeName));
            }
            if (entry.fenceGate != null && entry.fenceGateRecipeName != null) {
                registry.accept(new ResourceLocation(entry.modid, entry.fenceGateRecipeName));
            }
        }
    }

    private static void registerPyrolyseOvenRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_charcoal_byproducts", new Object[0]).circuitMeta(4).inputItems((TagKey<Item>)ItemTags.f_13181_, 16).inputFluids(GTMaterials.Nitrogen.getFluid(1000L)).outputItems(Items.f_42414_, 20).outputFluids(GTMaterials.CharcoalByproducts.getFluid(4000L)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_wood_tar", new Object[0]).circuitMeta(9).inputItems((TagKey<Item>)ItemTags.f_13181_, 16).outputItems(Items.f_42414_, 20).outputFluids(GTMaterials.WoodTar.getFluid(1500L)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_wood_tar_nitrogen", new Object[0]).circuitMeta(10).inputItems((TagKey<Item>)ItemTags.f_13181_, 16).inputFluids(GTMaterials.Nitrogen.getFluid(1000L)).outputItems(Items.f_42414_, 20).outputFluids(GTMaterials.WoodTar.getFluid(1500L)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_wood_gas", new Object[0]).circuitMeta(5).inputItems((TagKey<Item>)ItemTags.f_13181_, 16).outputItems(Items.f_42414_, 20).outputFluids(GTMaterials.WoodGas.getFluid(1500L)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_wood_gas_nitrogen", new Object[0]).circuitMeta(6).inputItems((TagKey<Item>)ItemTags.f_13181_, 16).inputFluids(GTMaterials.Nitrogen.getFluid(1000L)).outputItems(Items.f_42414_, 20).outputFluids(GTMaterials.WoodGas.getFluid(1500L)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_wood_vinegar", new Object[0]).circuitMeta(7).inputItems((TagKey<Item>)ItemTags.f_13181_, 16).outputItems(Items.f_42414_, 20).outputFluids(GTMaterials.WoodVinegar.getFluid(3000L)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_wood_vinegar_nitrogen", new Object[0]).circuitMeta(8).inputItems((TagKey<Item>)ItemTags.f_13181_, 16).inputFluids(GTMaterials.Nitrogen.getFluid(1000L)).outputItems(Items.f_42414_, 20).outputFluids(GTMaterials.WoodVinegar.getFluid(3000L)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_creosote", new Object[0]).circuitMeta(1).inputItems((TagKey<Item>)ItemTags.f_13181_, 16).outputItems(Items.f_42414_, 20).outputFluids(GTMaterials.Creosote.getFluid(4000L)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_creosote_nitrogen", new Object[0]).circuitMeta(2).inputItems((TagKey<Item>)ItemTags.f_13181_, 16).inputFluids(GTMaterials.Nitrogen.getFluid(1000L)).outputItems(Items.f_42414_, 20).outputFluids(GTMaterials.Creosote.getFluid(4000L)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_heavy_oil", new Object[0]).circuitMeta(3).inputItems((TagKey<Item>)ItemTags.f_13181_, 16).outputItems(TagPrefix.dust, GTMaterials.Ash, 4).outputFluids(GTMaterials.OilHeavy.getFluid(200L)).duration(320).EUt(192L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_to_coke_creosote", new Object[0]).circuitMeta(1).inputItems(TagPrefix.gem, GTMaterials.Coal, 16).outputItems(TagPrefix.gem, GTMaterials.Coke, 16).outputFluids(GTMaterials.Creosote.getFluid(8000L)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_to_coke_creosote_nitrogen", new Object[0]).circuitMeta(2).inputItems(TagPrefix.gem, GTMaterials.Coal, 16).inputFluids(GTMaterials.Nitrogen.getFluid(1000L)).outputItems(TagPrefix.gem, GTMaterials.Coke, 16).outputFluids(GTMaterials.Creosote.getFluid(8000L)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_block_to_coke_creosote", new Object[0]).circuitMeta(1).inputItems(TagPrefix.block, GTMaterials.Coal, 8).outputItems(TagPrefix.block, GTMaterials.Coke, 8).outputFluids(GTMaterials.Creosote.getFluid(32000L)).duration(2560).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_block_to_coke_creosote_nitrogen", new Object[0]).circuitMeta(2).inputItems(TagPrefix.block, GTMaterials.Coal, 8).inputFluids(GTMaterials.Nitrogen.getFluid(1000L)).outputItems(TagPrefix.block, GTMaterials.Coke, 8).outputFluids(GTMaterials.Creosote.getFluid(32000L)).duration(1280).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("bio_chaff_to_fermented_biomass", new Object[0]).EUt(10L).duration(200).inputItems((Supplier<? extends Item>)GTItems.BIO_CHAFF).circuitMeta(2).inputFluids(GTMaterials.Water.getFluid(1500L)).outputFluids(GTMaterials.FermentedBiomass.getFluid(1500L)).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("bio_chaff_to_biomass", new Object[0]).EUt(10L).duration(900).inputItems((Supplier<? extends Item>)GTItems.BIO_CHAFF, 4).circuitMeta(1).inputFluids(GTMaterials.Water.getFluid(4000L)).outputFluids(GTMaterials.Biomass.getFluid(5000L)).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("sugar_to_charcoal", new Object[0]).circuitMeta(1).inputItems(TagPrefix.dust, GTMaterials.Sugar, 23).outputItems(TagPrefix.dust, GTMaterials.Charcoal, 12).outputFluids(GTMaterials.Water.getFluid(1500L)).duration(320).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("sugar_to_charcoal_nitrogen", new Object[0]).circuitMeta(2).inputItems(TagPrefix.dust, GTMaterials.Sugar, 23).inputFluids(GTMaterials.Nitrogen.getFluid(500L)).outputItems(TagPrefix.dust, GTMaterials.Charcoal, 12).outputFluids(GTMaterials.Water.getFluid(1500L)).duration(160).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_coal_gas", new Object[0]).circuitMeta(20).inputItems((TagKey<Item>)ItemTags.f_13181_, 16).inputFluids(GTMaterials.Steam.getFluid(1000L)).outputItems(Items.f_42414_, 20).outputFluids(GTMaterials.CoalGas.getFluid(2000L)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_to_coal_gas", new Object[0]).circuitMeta(22).inputItems(TagPrefix.gem, GTMaterials.Coal, 16).inputFluids(GTMaterials.Steam.getFluid(1000L)).outputItems(TagPrefix.gem, GTMaterials.Coke, 16).outputFluids(GTMaterials.CoalGas.getFluid(4000L)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_block_to_coal_gas", new Object[0]).circuitMeta(22).inputItems(TagPrefix.block, GTMaterials.Coal, 8).inputFluids(GTMaterials.Steam.getFluid(4000L)).outputItems(TagPrefix.block, GTMaterials.Coke, 8).outputFluids(GTMaterials.CoalGas.getFluid(16000L)).duration(1280).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("charcoal_to_coal_tar", new Object[0]).circuitMeta(8).inputItems(Items.f_42414_, 32).chancedOutput(TagPrefix.dust, GTMaterials.Ash, 5000, 0).outputFluids(GTMaterials.CoalTar.getFluid(1000L)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_to_coal_tar", new Object[0]).circuitMeta(8).inputItems(Items.f_42413_, 12).chancedOutput(TagPrefix.dust, GTMaterials.DarkAsh, 5000, 0).outputFluids(GTMaterials.CoalTar.getFluid(3000L)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coke_to_coal_tar", new Object[0]).circuitMeta(8).inputItems(TagPrefix.gem, GTMaterials.Coke, 8).chancedOutput(TagPrefix.dust, GTMaterials.Ash, 7500, 0).outputFluids(GTMaterials.CoalTar.getFluid(4000L)).duration(320).EUt(96L).save(provider);
    }
}

