/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.gui.widget.list;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.client.TooltipsHandler;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.list.AEListGridWidget;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.slot.AEConfigSlotWidget;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class AEFluidDisplayWidget
extends Widget {
    private final AEListGridWidget gridWidget;
    private final int index;

    public AEFluidDisplayWidget(int x, int y, AEListGridWidget gridWidget, int index) {
        super(new Position(x, y), new Size(18, 18));
        this.gridWidget = gridWidget;
        this.index = index;
    }

    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        GenericStack fluid = this.gridWidget.getAt(this.index);
        GuiTextures.FLUID_SLOT.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
        GuiTextures.NUMBER_BACKGROUND.draw(graphics, mouseX, mouseY, (float)(position.x + 18), (float)position.y, 140, 18);
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (fluid != null) {
            FluidStack fluidStack;
            AEKey aEKey = fluid.what();
            if (aEKey instanceof AEFluidKey) {
                AEFluidKey key = (AEFluidKey)aEKey;
                fluidStack = FluidStack.create((Fluid)key.getFluid(), (long)fluid.amount(), (CompoundTag)key.getTag());
            } else {
                fluidStack = FluidStack.empty();
            }
            FluidStack fluidStack2 = fluidStack;
            DrawerHelper.drawFluidForGui((GuiGraphics)graphics, (FluidStack)fluidStack2, (long)fluid.amount(), (int)stackX, (int)stackY, (int)16, (int)16);
            String amountStr = String.format("x%,d", fluid.amount());
            DrawerHelper.drawText((GuiGraphics)graphics, (String)amountStr, (float)(stackX + 20), (float)(stackY + 5), (float)1.0f, (int)-1);
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            AEConfigSlotWidget.drawSelectionOverlay(graphics, stackX, stackY, 16, 16);
        }
    }

    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        GenericStack fluid;
        if (this.isMouseOverElement(mouseX, mouseY) && (fluid = this.gridWidget.getAt(this.index)) != null) {
            FluidStack fluidStack;
            AEKey aEKey = fluid.what();
            if (aEKey instanceof AEFluidKey) {
                AEFluidKey key = (AEFluidKey)aEKey;
                fluidStack = FluidStack.create((Fluid)key.getFluid(), (long)fluid.amount(), (CompoundTag)key.getTag());
            } else {
                fluidStack = FluidStack.empty();
            }
            FluidStack fluidStack2 = fluidStack;
            ArrayList<Object> tooltips = new ArrayList<Object>();
            tooltips.add(fluidStack2.getDisplayName());
            tooltips.add(Component.m_237113_((String)String.format("%,d ", fluid.amount())).m_130946_(FluidHelper.getUnit()));
            if (!Platform.isForge()) {
                tooltips.add(Component.m_237113_((String)"\u00a76mB:\u00a7r %d mB".formatted(fluidStack2.getAmount() * 1000L / FluidHelper.getBucket())));
            }
            TooltipsHandler.appendFluidTooltips(fluidStack2.getFluid(), fluidStack2.getAmount(), tooltips::add, (TooltipFlag)TooltipFlag.f_256752_);
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltips, Optional.empty(), mouseX, mouseY);
        }
    }
}

