/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.slot;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAEFluidSlot;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlot;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlotList;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportOnlyAEFluidList
extends NotifiableFluidTank
implements IConfigurableSlotList {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ExportOnlyAEFluidList.class, NotifiableFluidTank.MANAGED_FIELD_HOLDER);
    @Persisted
    protected ExportOnlyAEFluidSlot[] inventory;
    private FluidStorage[] fluidStorages;

    public ExportOnlyAEFluidList(MetaMachine machine, int slots) {
        this(machine, slots, ExportOnlyAEFluidSlot::new);
    }

    public ExportOnlyAEFluidList(MetaMachine machine, int slots, Supplier<ExportOnlyAEFluidSlot> slotFactory) {
        super(machine, slots, 0L, IO.IN);
        this.inventory = new ExportOnlyAEFluidSlot[slots];
        for (int i = 0; i < slots; ++i) {
            this.inventory[i] = slotFactory.get();
            this.inventory[i].setOnContentsChanged(this::onContentsChanged);
        }
    }

    @Override
    public FluidStorage[] getStorages() {
        if (this.fluidStorages == null) {
            this.fluidStorages = (FluidStorage[])Arrays.stream(this.inventory).map(FluidStorageDelegate::new).toArray(FluidStorage[]::new);
        }
        return this.fluidStorages;
    }

    @Override
    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        return 0L;
    }

    @Override
    public boolean supportsFill(int tank) {
        return false;
    }

    @Override
    public FluidStack drainInternal(long maxDrain, boolean simulate) {
        if (maxDrain == 0L) {
            return FluidStack.empty();
        }
        FluidStack totalDrained = null;
        for (ExportOnlyAEFluidSlot tank : this.inventory) {
            if (totalDrained == null || totalDrained.isEmpty()) {
                totalDrained = tank.drain(maxDrain, simulate);
                if (totalDrained.isEmpty()) {
                    totalDrained = null;
                } else {
                    maxDrain -= totalDrained.getAmount();
                }
            } else {
                FluidStack copy = totalDrained.copy();
                copy.setAmount(maxDrain);
                FluidStack drain = tank.drain(copy, simulate);
                totalDrained.grow(drain.getAmount());
                maxDrain -= drain.getAmount();
            }
            if (maxDrain <= 0L) break;
        }
        return totalDrained == null ? FluidStack.empty() : totalDrained;
    }

    @Override
    public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, @Nullable String slotName, boolean simulate) {
        return ExportOnlyAEFluidList.handleIngredient(io, recipe, left, simulate, this.handlerIO, this.getStorages());
    }

    @Override
    public IConfigurableSlot getConfigurableSlot(int index) {
        return this.inventory[index];
    }

    @Override
    public int getConfigurableSlots() {
        return this.inventory.length;
    }

    public boolean isAutoPull() {
        return false;
    }

    public boolean isStocking() {
        return false;
    }

    public boolean ownsSlot(ExportOnlyAEFluidSlot testSlot) {
        for (ExportOnlyAEFluidSlot tank : this.inventory) {
            if (tank != testSlot) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    @NotNull
    public Object createSnapshot() {
        return Arrays.stream(this.inventory).map(IFluidTransfer::createSnapshot).toArray(Object[]::new);
    }

    @Override
    @Deprecated
    public void restoreFromSnapshot(Object snapshot) {
        Object[] array;
        if (snapshot instanceof Object[] && (array = (Object[])snapshot).length == this.inventory.length) {
            for (int i = 0; i < array.length; ++i) {
                this.inventory[i].restoreFromSnapshot(array[i]);
            }
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public ExportOnlyAEFluidSlot[] getInventory() {
        return this.inventory;
    }

    private static class FluidStorageDelegate
    extends FluidStorage {
        private final ExportOnlyAEFluidSlot fluid;

        public FluidStorageDelegate(ExportOnlyAEFluidSlot fluid) {
            super(0L);
            this.fluid = fluid;
        }

        @NotNull
        public FluidStack getFluid() {
            return this.fluid.getFluid();
        }

        @NotNull
        public FluidStack drain(FluidStack maxDrain, boolean simulate, boolean notifyChanges) {
            return this.fluid.drain(maxDrain, simulate, notifyChanges);
        }

        public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChange) {
            return 0L;
        }

        public boolean supportsFill(int tank) {
            return false;
        }

        public FluidStorage copy() {
            return new FluidStorageDelegate(this.fluid){

                @Override
                @NotNull
                public FluidStack drain(FluidStack maxDrain, boolean simulate, boolean notifyChanges) {
                    return super.drain(maxDrain, true, notifyChanges);
                }
            };
        }
    }
}

