/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.slot;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAESlot;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.mojang.datafixers.util.Pair;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ExportOnlyAEFluidSlot
extends ExportOnlyAESlot
implements IFluidStorage {
    public ExportOnlyAEFluidSlot() {
    }

    public ExportOnlyAEFluidSlot(@Nullable GenericStack config, @Nullable GenericStack stock) {
        super(config, stock);
    }

    @Override
    public void addStack(GenericStack stack) {
        this.stock = this.stock == null ? stack : GenericStack.sum((GenericStack)this.stock, (GenericStack)stack);
        this.onContentsChanged();
    }

    @Override
    public void setStock(@Nullable GenericStack stack) {
        if (this.stock == null && stack == null) {
            return;
        }
        if (stack == null) {
            this.stock = null;
        } else {
            if (stack.equals((Object)this.stock)) {
                return;
            }
            this.stock = stack;
        }
        this.onContentsChanged();
    }

    public FluidStack getFluid() {
        AEKey aEKey;
        if (this.stock != null && (aEKey = this.stock.what()) instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            return FluidStack.create((Fluid)fluidKey.getFluid(), (long)this.stock.amount(), (CompoundTag)fluidKey.getTag());
        }
        return FluidStack.empty();
    }

    public void setFluid(FluidStack fluid) {
    }

    public boolean isFluidValid(FluidStack stack) {
        return false;
    }

    public long getFluidAmount() {
        return this.stock != null ? this.stock.amount() : 0L;
    }

    public long getCapacity() {
        return 0L;
    }

    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        return 0L;
    }

    public long fill(FluidStack resource, boolean doFill) {
        return 0L;
    }

    public boolean supportsFill(int tank) {
        return false;
    }

    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        return this.drain(resource, simulate, notifyChanges);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain, boolean notifyChanges) {
        if (this.getFluid().isFluidEqual(resource)) {
            return this.drain(resource.getAmount(), doDrain, notifyChanges);
        }
        return FluidStack.empty();
    }

    public FluidStack drain(long maxDrain, boolean simulate, boolean notifyChanges) {
        AEKey aEKey;
        if (this.stock == null || !((aEKey = this.stock.what()) instanceof AEFluidKey)) {
            return FluidStack.empty();
        }
        AEFluidKey fluidKey = (AEFluidKey)aEKey;
        int drained = (int)Math.min(this.stock.amount(), maxDrain);
        FluidStack result = FluidStack.create((Fluid)fluidKey.getFluid(), (long)drained, (CompoundTag)fluidKey.getTag());
        if (!simulate) {
            this.stock = new GenericStack(this.stock.what(), this.stock.amount() - (long)drained);
            if (this.stock.amount() == 0L) {
                this.stock = null;
            }
            if (notifyChanges) {
                this.onContentsChanged();
            }
        }
        return result;
    }

    public boolean supportsDrain(int tank) {
        return tank == 0;
    }

    public void onContentsChanged() {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.run();
        }
    }

    @Override
    public ExportOnlyAEFluidSlot copy() {
        return new ExportOnlyAEFluidSlot(this.config == null ? null : ExportOnlyAESlot.copy(this.config), this.stock == null ? null : ExportOnlyAESlot.copy(this.stock));
    }

    @Deprecated
    public Object createSnapshot() {
        return Pair.of((Object)this.config, (Object)this.stock);
    }

    @Deprecated
    public void restoreFromSnapshot(Object snapshot) {
        if (snapshot instanceof Pair) {
            Pair pair = (Pair)snapshot;
            this.config = (GenericStack)pair.getFirst();
            this.stock = (GenericStack)pair.getSecond();
        }
    }
}

