/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.emi.oreprocessing;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.integration.emi.oreprocessing.GTEmiOreProcessing;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GTOreProcessingEmiCategory
extends EmiRecipeCategory {
    public static final GTOreProcessingEmiCategory CATEGORY = new GTOreProcessingEmiCategory();

    public GTOreProcessingEmiCategory() {
        super(GTCEu.id("ore_processing_diagram"), (EmiRenderable)EmiStack.of((ItemLike)Items.f_41834_));
    }

    public static void registerDisplays(EmiRegistry registry) {
        for (Material mat : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!mat.hasProperty(PropertyKey.ORE) || mat.hasFlag(MaterialFlags.NO_ORE_PROCESSING_TAB)) continue;
            registry.addRecipe((EmiRecipe)new GTEmiOreProcessing(mat));
        }
    }

    public static void registerWorkStations(EmiRegistry registry) {
        ArrayList<MachineDefinition> registeredMachines = new ArrayList<MachineDefinition>();
        GTRecipeType[] validTypes = new GTRecipeType[]{GTRecipeTypes.MACERATOR_RECIPES, GTRecipeTypes.ORE_WASHER_RECIPES, GTRecipeTypes.THERMAL_CENTRIFUGE_RECIPES, GTRecipeTypes.CENTRIFUGE_RECIPES, GTRecipeTypes.CHEMICAL_BATH_RECIPES, GTRecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES, GTRecipeTypes.SIFTER_RECIPES};
        for (MachineDefinition machine : GTRegistries.MACHINES) {
            if (machine.getRecipeTypes() == null) continue;
            for (GTRecipeType type : machine.getRecipeTypes()) {
                for (GTRecipeType validType : validTypes) {
                    if (type != validType || registeredMachines.contains(machine)) continue;
                    registry.addWorkstation((EmiRecipeCategory)CATEGORY, (EmiIngredient)EmiStack.of((ItemStack)machine.asStack()));
                    registeredMachines.add(machine);
                }
            }
        }
    }

    public Component getName() {
        return Component.m_237115_((String)"gtceu.jei.ore_processing_diagram");
    }
}

