/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IExhaustVentMachine;
import com.gregtechceu.gtceu.integration.jade.provider.BlockInfoProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class ExhaustVentBlockProvider
extends BlockInfoProvider<IExhaustVentMachine> {
    public ExhaustVentBlockProvider() {
        super(GTCEu.id("exhaust_vent_info"));
    }

    @Override
    @Nullable
    protected IExhaustVentMachine getCapability(Level level, BlockPos blockPos) {
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, blockPos);
        if (metaMachine instanceof IExhaustVentMachine) {
            IExhaustVentMachine exhaustVentMachine = (IExhaustVentMachine)((Object)metaMachine);
            return exhaustVentMachine;
        }
        return null;
    }

    @Override
    protected boolean allowDisplaying(IExhaustVentMachine capability) {
        return super.allowDisplaying(capability);
    }

    @Override
    protected void write(CompoundTag compoundTag, IExhaustVentMachine iExhaustVentMachine, BlockAccessor blockAccessor) {
        Direction direction = iExhaustVentMachine.getVentingDirection();
        compoundTag.m_128359_("ventDirection", direction.m_122433_());
        Level level = blockAccessor.getLevel();
        BlockPos pos = blockAccessor.getPosition().m_121945_(direction);
        if (level != null) {
            ResourceLocation key = BuiltInRegistries.f_256975_.m_7981_((Object)level.m_8055_(pos).m_60734_());
            compoundTag.m_128359_("ventBlock", key.toString());
        }
        compoundTag.m_128379_("ventBlocked", iExhaustVentMachine.isVentingBlocked());
        compoundTag.m_128379_("needsVenting", iExhaustVentMachine.isNeedsVenting());
    }

    @Override
    protected void addTooltip(CompoundTag compoundTag, ITooltip iTooltip, Player player, BlockAccessor blockAccessor, BlockEntity blockEntity, IPluginConfig iPluginConfig) {
        Direction direction = Direction.m_122402_((String)compoundTag.m_128461_("ventDirection"));
        if (direction != null) {
            iTooltip.add((Component)Component.m_237110_((String)"gtceu.top.exhaust_vent_direction", (Object[])new Object[]{StringUtils.capitalize((String)direction.m_122433_())}));
            if (!compoundTag.m_128471_("ventBlocked")) {
                return;
            }
            if (blockAccessor.showDetails()) {
                ItemStack block = ((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(compoundTag.m_128461_("ventBlock")))).m_5456_().m_7968_();
                iTooltip.append(iTooltip.getElementHelper().smallItem(block));
            }
            if (compoundTag.m_128471_("needsVenting")) {
                iTooltip.append((Component)Component.m_237113_((String)" ("));
                iTooltip.append((Component)Component.m_237115_((String)"gtceu.top.exhaust_vent_blocked").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)")").m_130940_(ChatFormatting.GRAY)));
            }
        }
    }
}

