/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.SteamTexture;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Rect;
import com.lowdragmc.lowdraglib.utils.Size;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class GTRecipeTypeBuilder
extends BuilderBase<GTRecipeType> {
    public transient String name;
    public transient String category;
    public final transient Object2IntMap<RecipeCapability<?>> maxInputs;
    public final transient Object2IntMap<RecipeCapability<?>> maxOutputs;
    private ProgressTexture progressBarTexture;
    private SteamTexture steamProgressBarTexture;
    private ProgressTexture.FillDirection steamMoveType;
    private transient IGuiTexture specialTexture;
    private transient Rect specialTexturePosition;
    private final transient Byte2ObjectMap<IGuiTexture> slotOverlays;
    @Nullable
    protected SoundEntry sound;
    protected int maxTooltips;
    protected boolean isFuelRecipeType;
    private GTRecipeType smallRecipeMap;
    private Supplier<ItemStack> iconSupplier;
    @Nullable
    protected BiConsumer<GTRecipe, WidgetGroup> uiBuilder;

    public GTRecipeTypeBuilder(ResourceLocation i, Object ... args) {
        super(i, new Object[0]);
        this.name = i.m_135815_();
        this.maxInputs = new Object2IntOpenHashMap();
        this.maxOutputs = new Object2IntOpenHashMap();
        this.progressBarTexture = new ProgressTexture();
        this.steamProgressBarTexture = null;
        this.steamMoveType = ProgressTexture.FillDirection.LEFT_TO_RIGHT;
        this.slotOverlays = new Byte2ObjectArrayMap();
        this.sound = null;
        this.maxTooltips = 3;
        this.isFuelRecipeType = false;
        this.smallRecipeMap = null;
        this.iconSupplier = null;
        this.uiBuilder = null;
    }

    public GTRecipeTypeBuilder category(String category) {
        this.category = category;
        return this;
    }

    public GTRecipeTypeBuilder setMaxIOSize(int maxInputs, int maxOutputs, int maxFluidInputs, int maxFluidOutputs) {
        return this.setMaxSize(IO.IN, ItemRecipeCapability.CAP, maxInputs).setMaxSize(IO.IN, FluidRecipeCapability.CAP, maxFluidInputs).setMaxSize(IO.OUT, ItemRecipeCapability.CAP, maxOutputs).setMaxSize(IO.OUT, FluidRecipeCapability.CAP, maxFluidOutputs);
    }

    public GTRecipeTypeBuilder setEUIO(IO io) {
        if (io.support(IO.IN)) {
            this.setMaxSize(IO.IN, EURecipeCapability.CAP, 1);
        }
        if (io.support(IO.OUT)) {
            this.setMaxSize(IO.OUT, EURecipeCapability.CAP, 1);
        }
        return this;
    }

    public GTRecipeTypeBuilder setMaxSize(IO io, RecipeCapability<?> cap, int max) {
        if (io == IO.IN || io == IO.BOTH) {
            this.maxInputs.put(cap, max);
        }
        if (io == IO.OUT || io == IO.BOTH) {
            this.maxOutputs.put(cap, max);
        }
        return this;
    }

    @Deprecated
    public GTRecipeTypeBuilder setSpecialTexture(int x, int y, int width, int height, IGuiTexture area) {
        this.specialTexturePosition = Rect.of((Position)new Position(x, y), (Size)new Size(width, height));
        this.specialTexture = area;
        return this;
    }

    public GTRecipeTypeBuilder setSlotOverlay(boolean isOutput, boolean isFluid, IGuiTexture slotOverlay) {
        return this.setSlotOverlay(isOutput, isFluid, false, slotOverlay).setSlotOverlay(isOutput, isFluid, true, slotOverlay);
    }

    public GTRecipeTypeBuilder setSlotOverlay(boolean isOutput, boolean isFluid, boolean isLast, IGuiTexture slotOverlay) {
        this.slotOverlays.put((byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0)), (Object)slotOverlay);
        return this;
    }

    public GTRecipeTypeBuilder setProgressBar(ResourceTexture progressBar, ProgressTexture.FillDirection moveType) {
        this.progressBarTexture = new ProgressTexture((IGuiTexture)progressBar.getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)progressBar.getSubTexture(0.0, 0.5, 1.0, 0.5)).setFillDirection(moveType);
        return this;
    }

    public GTRecipeTypeBuilder setSteamProgressBar(SteamTexture progressBar, ProgressTexture.FillDirection moveType) {
        this.steamProgressBarTexture = progressBar;
        this.steamMoveType = moveType;
        return this;
    }

    public GTRecipeTypeBuilder setSound(SoundEntry sound) {
        this.sound = sound;
        return this;
    }

    public GTRecipeTypeBuilder setMaxTooltips(int maxTooltips) {
        this.maxTooltips = maxTooltips;
        return this;
    }

    public GTRecipeTypeBuilder setFuelRecipeType(boolean isFuelRecipeType) {
        this.isFuelRecipeType = isFuelRecipeType;
        return this;
    }

    public GTRecipeTypeBuilder setSmallRecipeMap(GTRecipeType smallRecipeMap) {
        this.smallRecipeMap = smallRecipeMap;
        return this;
    }

    public GTRecipeTypeBuilder setIconSupplier(Supplier<ItemStack> iconSupplier) {
        this.iconSupplier = iconSupplier;
        return this;
    }

    public GTRecipeTypeBuilder setUiBuilder(BiConsumer<GTRecipe, WidgetGroup> uiBuilder) {
        this.uiBuilder = uiBuilder;
        return this;
    }

    @Override
    public GTRecipeType register() {
        GTRecipeType type = GTRecipeTypes.register(this.name, this.category, new RecipeType[0]);
        type.maxInputs.putAll((Map<RecipeCapability<?>, Integer>)this.maxInputs);
        type.maxOutputs.putAll((Map<RecipeCapability<?>, Integer>)this.maxOutputs);
        type.getSlotOverlays().putAll(this.slotOverlays);
        type.getRecipeUI().setProgressBarTexture(this.progressBarTexture);
        type.getRecipeUI().setSteamProgressBarTexture(this.steamProgressBarTexture);
        type.getRecipeUI().setSteamMoveType(this.steamMoveType);
        type.setSound(this.sound);
        type.setMaxTooltips(this.maxTooltips);
        type.setFuelRecipeType(this.isFuelRecipeType);
        type.setSmallRecipeMap(this.smallRecipeMap);
        type.setIconSupplier(this.iconSupplier);
        type.setUiBuilder(this.uiBuilder);
        this.value = type;
        return this.value;
    }
}

