/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.SimpleGeneratorMachine;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.client.renderer.machine.SimpleGeneratorMachineRenderer;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.MachineFunctionPresets;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.SimpleMachineBuilder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class GeneratorBuilder
extends SimpleMachineBuilder {
    public GeneratorBuilder(String name, Function<IMachineBlockEntity, MetaMachine> machineConstructor) {
        super(name, machineConstructor);
    }

    @Override
    public GeneratorBuilder tier(int tier) {
        return (GeneratorBuilder)super.tier(tier);
    }

    private static GeneratorBuilder[] tieredMachines(String name, BiConsumer<GeneratorBuilder, Integer> builderConsumer, float hazardStrengthPerOperation, Integer ... tiers) {
        GeneratorBuilder[] builders = new GeneratorBuilder[GTValues.TIER_COUNT];
        Integer[] integerArray = tiers;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int tier = integerArray[i];
            GeneratorBuilder register = new GeneratorBuilder(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, holder -> new SimpleGeneratorMachine((IMachineBlockEntity)holder, tier, hazardStrengthPerOperation * (float)tier, GTMachines.defaultTankSizeFunction, new Object[0])).tier(tier);
            builderConsumer.accept(register, tier);
            builders[tier] = register;
        }
        return builders;
    }

    private static void simple(GeneratorBuilder builder, int tier) {
        builder.langValue("%s %s Generator %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName(builder.id.m_135815_()), GTValues.VLVT[tier])).rotationState(RotationState.NON_Y_AXIS).recipeModifier(SimpleGeneratorMachine::recipeModifier, true).renderer(() -> new SimpleGeneratorMachineRenderer(tier, GTCEu.id("block/generators/" + builder.id.m_135815_()))).tooltips(GTMachines.explosion());
    }

    public static MachineBuilder<MachineDefinition> createAll(String name, Object ... args) {
        MachineBuilder[] builders = GeneratorBuilder.tieredMachines(name, GeneratorBuilder::simple, args.length < 2 ? 1.0f : (float)((Integer)args[0]).intValue(), MachineFunctionPresets.mapTierArray(Arrays.copyOfRange(args, args.length < 2 ? 0 : 1, args.length)));
        return MachineFunctionPresets.builder((String)name, (MachineBuilder[])builders, GeneratorBuilder.class, MachineDefinition::createDefinition, MetaMachineBlock::new, MetaMachineBlockEntity::createBlockEntity);
    }
}

