/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.prefix;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.core.mixins.BlockBehaviourAccessor;
import com.gregtechceu.gtceu.integration.kjs.Validator;
import com.gregtechceu.gtceu.integration.kjs.builders.prefix.TagPrefixBuilder;
import com.gregtechceu.gtceu.integration.kjs.built.KJSTagPrefix;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class OreTagPrefixBuilder
extends TagPrefixBuilder {
    public transient Supplier<BlockState> stateSupplier;
    public transient Supplier<Material> materialSupplier;
    public transient ResourceLocation baseModelLocation;
    public transient Supplier<BlockBehaviour.Properties> templateProperties;
    public transient boolean doubleDrops = false;
    public transient boolean isSand = false;
    public transient boolean shouldDropAsItem = false;

    public OreTagPrefixBuilder(ResourceLocation id, Object ... args) {
        super(id, args);
    }

    @Override
    public KJSTagPrefix create(String id) {
        return KJSTagPrefix.oreTagPrefix(id);
    }

    @Override
    public TagPrefix register() {
        Validator.validate(this.id, Validator.errorIfNull(this.stateSupplier, "stateSupplier"), Validator.onlySetDefault(this.templateProperties, () -> {
            this.templateProperties = () -> GTBlocks.copy(((BlockBehaviourAccessor)this.stateSupplier.get().m_60734_()).getBlockProperties(), BlockBehaviour.Properties.m_284310_());
        }), Validator.errorIfNull(this.baseModelLocation, "baseModelLocation"));
        this.value = this.base.registerOre(this.stateSupplier, this.materialSupplier, this.templateProperties, this.baseModelLocation, this.doubleDrops, this.isSand, this.shouldDropAsItem);
        return this.value;
    }

    public OreTagPrefixBuilder stateSupplier(Supplier<BlockState> stateSupplier) {
        this.stateSupplier = stateSupplier;
        return this;
    }

    public OreTagPrefixBuilder materialSupplier(Supplier<Material> materialSupplier) {
        this.materialSupplier = materialSupplier;
        return this;
    }

    public OreTagPrefixBuilder baseModelLocation(ResourceLocation baseModelLocation) {
        this.baseModelLocation = baseModelLocation;
        return this;
    }

    public OreTagPrefixBuilder templateProperties(Supplier<BlockBehaviour.Properties> templateProperties) {
        this.templateProperties = templateProperties;
        return this;
    }

    public OreTagPrefixBuilder doubleDrops(boolean doubleDrops) {
        this.doubleDrops = doubleDrops;
        return this;
    }

    public OreTagPrefixBuilder isSand(boolean isSand) {
        this.isSand = isSand;
        return this;
    }

    public OreTagPrefixBuilder shouldDropAsItem(boolean shouldDropAsItem) {
        this.shouldDropAsItem = shouldDropAsItem;
        return this;
    }
}

