/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.utils.FluidKey;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class GTHashMaps {
    private GTHashMaps() {
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemHandler(@NotNull IItemTransfer inputs) {
        return GTHashMaps.fromItemHandler(inputs, false);
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemHandler(@NotNull IItemTransfer inputs, boolean linked) {
        Object2IntMap<ItemStack> map = GTHashMaps.createItemStackMap(linked);
        for (int i = 0; i < inputs.getSlots(); ++i) {
            ItemStack stack = inputs.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            map.put((Object)stack.m_41777_(), map.getInt((Object)stack) + stack.m_41613_());
        }
        return map;
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemStackCollection(@NotNull Iterable<ItemStack> inputs) {
        return GTHashMaps.fromItemStackCollection(inputs, false);
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemStackCollection(@NotNull Iterable<ItemStack> inputs, boolean linked) {
        Object2IntMap<ItemStack> map = GTHashMaps.createItemStackMap(linked);
        for (ItemStack stack : inputs) {
            if (stack.m_41619_()) continue;
            map.put((Object)stack.m_41777_(), map.getInt((Object)stack) + stack.m_41613_());
        }
        return map;
    }

    @NotNull
    private static Object2IntMap<ItemStack> createItemStackMap(boolean linked) {
        ItemStackHashStrategy strategy = ItemStackHashStrategy.comparingAllButCount();
        return linked ? new Object2IntLinkedOpenCustomHashMap((Hash.Strategy)strategy) : new Object2IntOpenCustomHashMap((Hash.Strategy)strategy);
    }

    public static Map<FluidKey, Long> fromFluidHandler(IFluidTransfer fluidInputs) {
        Object2LongLinkedOpenHashMap map = new Object2LongLinkedOpenHashMap();
        for (int i = 0; i < fluidInputs.getTanks(); ++i) {
            FluidStack fluidStack = fluidInputs.getFluidInTank(i);
            if (fluidStack == FluidStack.empty() || fluidStack.getAmount() <= 0L) continue;
            FluidKey key = new FluidKey(fluidStack);
            map.put((Object)key, map.getLong((Object)key) + fluidStack.getAmount());
        }
        return map;
    }

    public static Map<FluidKey, Long> fromFluidCollection(Collection<FluidStack> fluidInputs) {
        Object2LongLinkedOpenHashMap map = new Object2LongLinkedOpenHashMap();
        for (FluidStack fluidStack : fluidInputs) {
            if (fluidStack == null || fluidStack.getAmount() <= 0L) continue;
            FluidKey key = new FluidKey(fluidStack);
            map.put((Object)key, map.getLong((Object)key) + fluidStack.getAmount());
        }
        return map;
    }
}

