/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;

public class SupplierMemoizer {
    public static <T> MemoizedSupplier<T> memoize(Supplier<T> delegate) {
        return new MemoizedSupplier<T>(delegate);
    }

    public static <T extends Block> MemoizedBlockSupplier<T> memoizeBlockSupplier(Supplier<T> delegate) {
        return new MemoizedBlockSupplier<T>(delegate);
    }

    public static class MemoizedSupplier<T>
    implements Supplier<T> {
        transient T value;
        volatile transient boolean initialized;
        final Supplier<T> delegate;

        MemoizedSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                MemoizedSupplier memoizedSupplier = this;
                synchronized (memoizedSupplier) {
                    if (!this.initialized) {
                        T t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return t;
                    }
                }
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forget() {
            MemoizedSupplier memoizedSupplier = this;
            synchronized (memoizedSupplier) {
                this.initialized = false;
                this.value = null;
            }
        }

        public String toString() {
            return "SupplierMemoizer.memoize(" + (this.initialized ? "<supplier that returned " + this.value + ">" : this.delegate) + ")";
        }
    }

    public static class MemoizedBlockSupplier<T extends Block>
    extends MemoizedSupplier<T> {
        MemoizedBlockSupplier(Supplier<T> delegate) {
            super(delegate);
        }

        @Override
        public String toString() {
            return "SupplierMemoizer.memoizeBlockSupplier(" + (this.initialized ? "<supplier that returned " + this.value + ">" : this.delegate) + ")";
        }
    }
}

