/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.client.gui.GuiSprites;
import dan200.computercraft.client.render.SpriteRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public final class ComputerBorderRenderer {
    public static final int MARGIN = 2;
    public static final int BORDER = 12;
    public static final int LIGHT_HEIGHT = 8;
    private static final int TEX_SIZE = 36;

    private ComputerBorderRenderer() {
    }

    public static void render(SpriteRenderer renderer, GuiSprites.ComputerTextures textures, int x, int y, int width, int height, boolean withLight) {
        int endX = x + width;
        int endY = y + height;
        TextureAtlasSprite border = GuiSprites.get(textures.border());
        ComputerBorderRenderer.blitBorder(renderer, border, x - 12, y - 12, 0, 0, 12, 12);
        ComputerBorderRenderer.blitBorder(renderer, border, x, y - 12, 12, 0, width, 12);
        ComputerBorderRenderer.blitBorder(renderer, border, endX, y - 12, 24, 0, 12, 12);
        ComputerBorderRenderer.blitBorder(renderer, border, x - 12, y, 0, 12, 12, height);
        ComputerBorderRenderer.blitBorder(renderer, border, endX, y, 24, 12, 12, height);
        if (withLight) {
            ResourceLocation pocketBottomTexture = textures.pocketBottom();
            if (pocketBottomTexture == null) {
                throw new NullPointerException(textures + " has no pocket texture");
            }
            TextureAtlasSprite pocketBottom = GuiSprites.get(pocketBottomTexture);
            renderer.blitHorizontalSliced(pocketBottom, x - 12, endY, width + 24, 20, 12, 12, 36);
        } else {
            ComputerBorderRenderer.blitBorder(renderer, border, x - 12, endY, 0, 24, 12, 12);
            ComputerBorderRenderer.blitBorder(renderer, border, x, endY, 12, 24, width, 12);
            ComputerBorderRenderer.blitBorder(renderer, border, endX, endY, 24, 24, 12, 12);
        }
    }

    private static void blitBorder(SpriteRenderer renderer, TextureAtlasSprite sprite, int x, int y, int u, int v, int width, int height) {
        renderer.blit(x, y, width, height, SpriteRenderer.u(sprite, u, 36), SpriteRenderer.v(sprite, v, 36), SpriteRenderer.u(sprite, u + 12, 36), SpriteRenderer.v(sprite, v + 12, 36));
    }
}

