/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.metrics;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadAllocations {
    private static final Logger LOG;
    @Nullable
    private static final MethodHandle threadAllocatedBytes;
    @Nullable
    private static final MethodHandle threadsAllocatedBytes;

    private ThreadAllocations() {
    }

    public static boolean isSupported() {
        return threadAllocatedBytes != null;
    }

    public static long getAllocatedBytes(long threadId) {
        if (threadAllocatedBytes == null) {
            throw new UnsupportedOperationException("Allocated bytes are not supported");
        }
        try {
            return threadAllocatedBytes.invokeExact(threadId);
        }
        catch (Throwable t) {
            throw (RuntimeException)ThreadAllocations.throwUnchecked0(t);
        }
    }

    public static long[] getAllocatedBytes(long[] threadIds) {
        if (threadsAllocatedBytes == null) {
            throw new UnsupportedOperationException("Allocated bytes are not supported");
        }
        try {
            return threadsAllocatedBytes.invokeExact(threadIds);
        }
        catch (Throwable t) {
            throw (RuntimeException)ThreadAllocations.throwUnchecked0(t);
        }
    }

    private static <T extends Throwable> T throwUnchecked0(Throwable t) throws T {
        throw t;
    }

    static {
        MethodHandle threadsAllocatedBytesHandle;
        MethodHandle threadAllocatedBytesHandle;
        LOG = LoggerFactory.getLogger(ThreadAllocations.class);
        try {
            Class<ThreadMXBean> threadMxBean = Class.forName("com.sun.management.ThreadMXBean").asSubclass(ThreadMXBean.class);
            ThreadMXBean bean = ManagementFactory.getPlatformMXBean(threadMxBean);
            threadMxBean.getMethod("setThreadAllocatedMemoryEnabled", Boolean.TYPE).invoke((Object)bean, true);
            threadMxBean.getMethod("getCurrentThreadAllocatedBytes", new Class[0]).invoke((Object)bean, new Object[0]);
            threadAllocatedBytesHandle = MethodHandles.publicLookup().findVirtual(threadMxBean, "getThreadAllocatedBytes", MethodType.methodType(Long.TYPE, Long.TYPE)).bindTo(bean);
            threadsAllocatedBytesHandle = MethodHandles.publicLookup().findVirtual(threadMxBean, "getThreadAllocatedBytes", MethodType.methodType(long[].class, long[].class)).bindTo(bean);
        }
        catch (LinkageError | ReflectiveOperationException | RuntimeException e) {
            LOG.warn("Cannot track allocated memory of computer threads", e);
            threadsAllocatedBytesHandle = null;
            threadAllocatedBytesHandle = null;
        }
        threadAllocatedBytes = threadAllocatedBytesHandle;
        threadsAllocatedBytes = threadsAllocatedBytesHandle;
    }
}

