/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlecharginstation.block;

import com.mikitellurium.turtlecharginstation.blockentity.TurtleChargingStationBlockEntity;
import com.mikitellurium.turtlecharginstation.networking.ModMessages;
import com.mikitellurium.turtlecharginstation.networking.packets.EnergySyncS2CPacket;
import com.mikitellurium.turtlecharginstation.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class TurtleChargingStationBlock
extends BaseEntityBlock {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    public static final BooleanProperty CHARGING = BooleanProperty.m_61465_((String)"charging");

    public TurtleChargingStationBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ENABLED, (Comparable)Boolean.TRUE)).m_61124_((Property)CHARGING, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TurtleChargingStationBlockEntity(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.f_46443_) {
            BlockEntity entity = pLevel.m_7702_(pPos);
            if (entity instanceof TurtleChargingStationBlockEntity) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)((TurtleChargingStationBlockEntity)entity), (BlockPos)pPos);
                ModMessages.sendToClients(new EnergySyncS2CPacket(((TurtleChargingStationBlockEntity)entity).getEnergyStorage().getEnergyStored(), pPos));
            } else {
                throw new IllegalStateException("Container provider is missing");
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_())) {
            this.checkPoweredState(pLevel, pPos, pState);
        }
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        this.checkPoweredState(pLevel, pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return TurtleChargingStationBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.TURTLE_CHARGING_STATION.get()), TurtleChargingStationBlockEntity::tick);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !level.m_276867_(pos);
        if (flag != (Boolean)state.m_61143_((Property)ENABLED)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{ENABLED});
        pBuilder.m_61104_(new Property[]{CHARGING});
    }
}

